/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.content.Intent;
import android.os.Parcelable;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadUtils;

public class FileDownloadBroadcastHandler {
    public static final String ACTION_COMPLETED = "filedownloader.intent.action.completed";
    public static final String KEY_MODEL = "model";

    public static FileDownloadModel parseIntent(Intent intent) {
        if (!ACTION_COMPLETED.equals(intent.getAction())) {
            throw new IllegalArgumentException(FileDownloadUtils.formatString("can't recognize the intent with action %s, on the current version we only support action [%s]", intent.getAction(), ACTION_COMPLETED));
        }
        return (FileDownloadModel)intent.getParcelableExtra(KEY_MODEL);
    }

    public static void sendCompletedBroadcast(FileDownloadModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        if (model.getStatus() != -3) {
            throw new IllegalStateException();
        }
        Intent intent = new Intent(ACTION_COMPLETED);
        intent.putExtra(KEY_MODEL, (Parcelable)model);
        FileDownloadHelper.getAppContext().sendBroadcast(intent);
    }
}

