/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_switch;

import android.content.Context;
import android.graphics.Color;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.weex_switch.SwitchButton;
import io.dcloud.feature.weex_switch.SwitchGroup;
import java.util.HashMap;

public class DCWXSwitchGroup
extends WXComponent<SwitchGroup> {
    public DCWXSwitchGroup(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.setContentBoxMeasurement(new ContentBoxMeasurement(){

            @Override
            public void measureInternal(float width, float height, int widthMeasureMode, int heightMeasureMode) {
                int defHeight = (int)WXViewUtils.getRealPxByWidth(31.0f, DCWXSwitchGroup.this.getInstance().getInstanceViewPortWidthWithFloat());
                int defWidth = (int)WXViewUtils.getRealPxByWidth(51.0f, DCWXSwitchGroup.this.getInstance().getInstanceViewPortWidthWithFloat());
                if (CSSConstants.isUndefined(height)) {
                    width = defWidth;
                    height = defHeight;
                }
                this.mMeasureWidth = width;
                this.mMeasureHeight = height;
            }

            @Override
            public void layoutBefore() {
            }

            @Override
            public void layoutAfter(float computedWidth, float computedHeight) {
            }
        });
    }

    @Override
    protected SwitchGroup initComponentHostView(@NonNull Context context) {
        SwitchGroup switchButton = new SwitchGroup(context);
        return switchButton;
    }

    @WXComponentProp(name="checked")
    public void setChecked(boolean checked) {
        ((SwitchButton)((SwitchGroup)((Object)this.getHostView())).getChildAt(0)).setChecked(checked);
    }

    @Override
    @WXComponentProp(name="disabled")
    public void setDisabled(boolean disabled) {
        ((SwitchButton)((SwitchGroup)((Object)this.getHostView())).getChildAt(0)).setEnabled(!disabled);
    }

    @WXComponentProp(name="color")
    public void setColor(String color2) {
        ((SwitchButton)((SwitchGroup)((Object)this.getHostView())).getChildAt(0)).setCheckedColor(Color.parseColor((String)color2));
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (type != null && type.equals("change") && this.getHostView() != null) {
            ((SwitchButton)((SwitchGroup)((Object)this.getHostView())).getChildAt(0)).setOnCheckedChangeListener(new SwitchButton.OnCheckedChangeListener(){

                @Override
                public void onCheckedChanged(SwitchButton view, boolean isChecked) {
                    HashMap<String, Object> domChanges = new HashMap<String, Object>();
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.put("value", isChecked + "");
                    domChanges.put("detail", valueMap);
                    DCWXSwitchGroup.this.fireEvent("change", domChanges);
                }
            });
        }
    }

    @Override
    protected void removeEventFromView(String type) {
        super.removeEventFromView(type);
        if (this.getHostView() != null && "change".equals(type)) {
            ((SwitchButton)((SwitchGroup)((Object)this.getHostView())).getChildAt(0)).setOnCheckedChangeListener(null);
        }
    }
}

