/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXViewUtils;

public class WXBaseCircleIndicator
extends FrameLayout
implements WXGestureObservable {
    private final Paint mPaintPage = new Paint();
    private final Paint mPaintFill = new Paint();
    private WXGesture wxGesture;
    private WXCircleViewPager mCircleViewPager;
    private float radius;
    private float circlePadding;
    private int pageColor = -3355444;
    private int fillColor = -12303292;
    private int realCurrentItem;
    private ViewPager.OnPageChangeListener mListener;

    public WXBaseCircleIndicator(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.radius = WXViewUtils.dip2px(5.0f);
        this.circlePadding = WXViewUtils.dip2px(5.0f);
        this.pageColor = -3355444;
        this.fillColor = -12303292;
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setAntiAlias(true);
        this.mPaintPage.setAntiAlias(true);
        this.mPaintPage.setColor(this.pageColor);
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setColor(this.fillColor);
        this.setWillNotDraw(false);
    }

    public WXBaseCircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void setCircleViewPager(WXCircleViewPager viewPager) {
        this.mCircleViewPager = viewPager;
        if (this.mCircleViewPager != null) {
            if (this.mListener == null) {
                this.mListener = new ViewPager.SimpleOnPageChangeListener(){

                    public void onPageSelected(int position) {
                        WXBaseCircleIndicator.this.realCurrentItem = WXBaseCircleIndicator.this.mCircleViewPager.getRealCurrentItem();
                        WXBaseCircleIndicator.this.invalidate();
                    }
                };
            }
            this.mCircleViewPager.addOnPageChangeListener(this.mListener);
            this.realCurrentItem = this.mCircleViewPager.getRealCurrentItem();
            if (this.realCurrentItem < 0) {
                this.realCurrentItem = 0;
            }
        }
        this.requestLayout();
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
        this.mPaintFill.setColor(fillColor);
    }

    public void setPageColor(int pageColor) {
        this.pageColor = pageColor;
        this.mPaintPage.setColor(pageColor);
    }

    public int getRealCurrentItem() {
        return this.realCurrentItem;
    }

    public void setRealCurrentItem(int realCurrentItem) {
        this.realCurrentItem = realCurrentItem;
        this.invalidate();
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = super.dispatchTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float dotWidth = (this.circlePadding + this.radius) * 2.0f;
        float firstCenterX = (float)(this.getWidth() / 2) - dotWidth * (float)(this.getCount() - 1) / 2.0f;
        float firstCenterY = this.getHeight() / 2 + this.getPaddingTop();
        for (int i = 0; i < this.getCount(); ++i) {
            float dx = firstCenterX + dotWidth * (float)i;
            float dy = firstCenterY;
            if (i != this.realCurrentItem) {
                canvas.drawCircle(dx, dy, this.radius, this.mPaintPage);
                continue;
            }
            canvas.drawCircle(dx, dy, this.radius, this.mPaintFill);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int viewWidth = widthMode == 0x40000000 ? widthSize : (int)((float)this.getPaddingLeft() + this.radius * 2.0f * (float)this.getCount() + this.circlePadding * (float)(this.getCount() - 1) + (float)this.getPaddingRight()) + 1;
        int viewHeight = heightMode == 0x40000000 ? heightSize : (int)((float)this.getPaddingTop() + this.radius * 2.0f + (float)this.getPaddingBottom()) + 1;
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    public int getCount() {
        if (this.mCircleViewPager == null || this.mCircleViewPager.getAdapter() == null) {
            return 0;
        }
        return this.mCircleViewPager.getRealCount();
    }
}

