/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.internal.JSFunctionInterface;
import com.alibaba.android.bindingx.core.internal.JSObjectInterface;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class Expression {
    private JSONObject root;

    Expression(String json) {
        try {
            this.root = (JSONObject)new JSONTokener(json).nextValue();
        }
        catch (Throwable e) {
            LogProxy.e("[Expression] expression is illegal. \n ", e);
        }
    }

    Expression(JSONObject root) {
        this.root = root;
    }

    Object execute(Map<String, Object> scope) throws IllegalArgumentException, JSONException {
        return this.execute(this.root, scope);
    }

    private double toNumber(Object value) {
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        return (Double)value;
    }

    private boolean toBoolean(Object value) {
        if (value instanceof String) {
            return "".equals(value);
        }
        if (value instanceof Double) {
            return (Double)value != 0.0;
        }
        return (Boolean)value;
    }

    private String toString(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "true" : "false";
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        return (String)value;
    }

    private boolean equal(Object v1, Object v2) {
        if (v1 instanceof JSObjectInterface && v2 instanceof JSObjectInterface) {
            return v1 == v2;
        }
        if (v1 instanceof String && v2 instanceof String) {
            return v1.equals(v2);
        }
        if (v1 instanceof Boolean && v2 instanceof Boolean) {
            return this.toBoolean(v1) == this.toBoolean(v2);
        }
        return this.toNumber(v1) == this.toNumber(v2);
    }

    private boolean strictlyEqual(Object v1, Object v2) {
        if (v1 instanceof JSObjectInterface && !(v2 instanceof JSObjectInterface)) {
            return false;
        }
        if (v1 instanceof Boolean && !(v2 instanceof Boolean)) {
            return false;
        }
        if (v1 instanceof Double && !(v2 instanceof Double)) {
            return false;
        }
        if (v1 instanceof String && !(v2 instanceof String)) {
            return false;
        }
        return v1 == v2;
    }

    private Object execute(JSONObject node, Map<String, Object> scope) throws IllegalArgumentException, JSONException {
        String type = node.getString("type");
        JSONArray children = node.optJSONArray("children");
        switch (type) {
            case "StringLiteral": {
                return node.getString("value");
            }
            case "NumericLiteral": {
                return node.getDouble("value");
            }
            case "BooleanLiteral": {
                return node.getBoolean("value");
            }
            case "Identifier": {
                return scope.get(node.getString("value"));
            }
            case "CallExpression": {
                JSFunctionInterface function = (JSFunctionInterface)this.execute(children.getJSONObject(0), scope);
                ArrayList<Object> arguments = new ArrayList<Object>();
                JSONArray jsonArguments = children.getJSONObject(1).getJSONArray("children");
                for (int i = 0; i < jsonArguments.length(); ++i) {
                    arguments.add(this.execute(jsonArguments.getJSONObject(i), scope));
                }
                return function.execute(arguments);
            }
            case "?": {
                if (((Boolean)this.execute(children.getJSONObject(0), scope)).booleanValue()) {
                    return this.execute(children.getJSONObject(1), scope);
                }
                return this.execute(children.getJSONObject(2), scope);
            }
            case "+": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) + this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "-": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) - this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "*": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) * this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "/": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) / this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "%": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) % this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "**": {
                return Math.pow(this.toNumber(this.execute(children.getJSONObject(0), scope)), this.toNumber(this.execute(children.getJSONObject(1), scope)));
            }
            case ">": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) > this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "<": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) < this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case ">=": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) >= this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "<=": {
                return this.toNumber(this.execute(children.getJSONObject(0), scope)) <= this.toNumber(this.execute(children.getJSONObject(1), scope));
            }
            case "==": {
                return this.equal(this.execute(children.getJSONObject(0), scope), this.execute(children.getJSONObject(1), scope));
            }
            case "===": {
                return this.strictlyEqual(this.execute(children.getJSONObject(0), scope), this.execute(children.getJSONObject(1), scope));
            }
            case "!=": {
                return !this.equal(this.execute(children.getJSONObject(0), scope), this.execute(children.getJSONObject(1), scope));
            }
            case "!==": {
                return !this.strictlyEqual(this.execute(children.getJSONObject(0), scope), this.execute(children.getJSONObject(1), scope));
            }
            case "&&": {
                Object result = this.execute(children.getJSONObject(0), scope);
                if (!this.toBoolean(result)) {
                    return result;
                }
                return this.execute(children.getJSONObject(1), scope);
            }
            case "||": {
                Object result = this.execute(children.getJSONObject(0), scope);
                if (this.toBoolean(result)) {
                    return result;
                }
                return this.execute(children.getJSONObject(1), scope);
            }
            case "!": {
                return !this.toBoolean(this.execute(children.getJSONObject(0), scope));
            }
        }
        return null;
    }
}

