/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;

public class GlPixelationFilter
extends GlFilter {
    private static final String PIXELATION_FRAGMENT_SHADER = "precision highp float;\nvarying highp vec2 vTextureCoord;\nuniform float imageWidthFactor;\nuniform float imageHeightFactor;\nuniform lowp sampler2D sTexture;\nuniform float pixel;\nvoid main()\n{\n  vec2 uv  = vTextureCoord.xy;\n  float dx = pixel * imageWidthFactor;\n  float dy = pixel * imageHeightFactor;\n  vec2 coord = vec2(dx * floor(uv.x / dx), dy * floor(uv.y / dy));\n  vec3 tc = texture2D(sTexture, coord).xyz;\n  gl_FragColor = vec4(tc, 1.0);\n}";
    private float pixel = 1.0f;
    private float imageWidthFactor = 0.0013888889f;
    private float imageHeightFactor = 0.0013888889f;

    public GlPixelationFilter() {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", PIXELATION_FRAGMENT_SHADER);
    }

    @Override
    public void setFrameSize(int width, int height) {
        super.setFrameSize(width, height);
        this.imageWidthFactor = 1.0f / (float)width;
        this.imageHeightFactor = 1.0f / (float)height;
    }

    @Override
    public void onDraw() {
        GLES20.glUniform1f((int)this.getHandle("pixel"), (float)this.pixel);
        GLES20.glUniform1f((int)this.getHandle("imageWidthFactor"), (float)this.imageWidthFactor);
        GLES20.glUniform1f((int)this.getHandle("imageHeightFactor"), (float)this.imageHeightFactor);
    }
}

