/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.text.TextUtils;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.RenderContext;
import com.taobao.weex.ui.component.DCWXScroller;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXComponent;
import io.dcloud.feature.weex_scroller.view.DCWXScrollView;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

class RenderContextImpl
implements RenderContext {
    private Map<String, WXComponent> mRegistry;
    private Map<String, WXComponent> mIdComponent;
    private List<DCWXScroller> mScrollers;
    private WXSDKInstance mWXSDKInstance;

    public RenderContextImpl(WXSDKInstance instance) {
        this.mWXSDKInstance = instance;
        this.mRegistry = new ConcurrentHashMap<String, WXComponent>();
        this.mScrollers = new CopyOnWriteArrayList<DCWXScroller>();
        this.mIdComponent = new ConcurrentHashMap<String, WXComponent>();
    }

    public void destroy() {
        this.mWXSDKInstance = null;
        try {
            this.mRegistry.clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public WXSDKInstance getWXSDKInstance() {
        return this.mWXSDKInstance;
    }

    @Override
    public WXSDKInstance getInstance() {
        return this.mWXSDKInstance;
    }

    @Override
    public WXComponent getComponent(String ref) {
        return this.mRegistry.get(ref);
    }

    public WXComponent getComponentById(String id2) {
        return this.mIdComponent.get(id2);
    }

    public void registerComponent(String ref, WXComponent comp) {
        String id2;
        if (comp instanceof DCWXScroller) {
            this.mScrollers.add((DCWXScroller)comp);
        }
        if (comp.getAttrs().containsKey("id") && !TextUtils.isEmpty((CharSequence)(id2 = (String)comp.getAttrs().get("id")))) {
            this.mIdComponent.put(id2, comp);
        }
        this.mRegistry.put(ref, comp);
    }

    @Override
    public WXComponent unregisterComponent(String ref) {
        return this.mRegistry.remove(ref);
    }

    public void setAllScrollerScrollable(boolean scrollable, String ref) {
        if (this.mScrollers.size() > 0) {
            Scrollable scrollView = this.getComponent(ref).getParentScroller();
            while (scrollView != null) {
                if (scrollView instanceof DCWXScroller) {
                    DCWXScroller scroller = (DCWXScroller)scrollView;
                    ViewGroup view = scroller.getInnerView();
                    if (view instanceof DCWXScrollView) {
                        ((DCWXScrollView)view).setScrollable(scrollable);
                    }
                    scrollView = scroller.getParentScroller();
                    continue;
                }
                scrollView = ((WXComponent)((Object)scrollView)).getParentScroller();
            }
        }
    }

    public int getComponentCount() {
        return this.mRegistry.size();
    }
}

