/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.taobao.weex.R;
import com.taobao.weex.ui.component.list.ListComponentView;
import com.taobao.weex.ui.component.list.StickyHeaderHelper;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;

public class BounceRecyclerView
extends BaseBounceView<WXRecyclerView>
implements ListComponentView,
WXGestureObservable {
    public static final int DEFAULT_COLUMN_COUNT = 1;
    public static final int DEFAULT_COLUMN_GAP = 1;
    private RecyclerViewBaseAdapter adapter = null;
    private int mLayoutType = 1;
    private int mColumnCount = 1;
    private float mColumnGap = 1.0f;
    private StickyHeaderHelper mStickyHeaderHelper;
    private int mOrientation = 0;

    public BounceRecyclerView(Context context, int type, int columnCount, float columnGap, int orientation) {
        super(context, orientation);
        this.mLayoutType = type;
        this.mColumnCount = columnCount;
        this.mColumnGap = columnGap;
        this.mOrientation = orientation;
        this.init(context);
        this.mStickyHeaderHelper = new StickyHeaderHelper((ViewGroup)this);
    }

    public BounceRecyclerView(Context context, int type, int orientation) {
        this(context, type, 1, 1.0f, orientation);
    }

    @Override
    public void setRecyclerViewBaseAdapter(RecyclerViewBaseAdapter adapter) {
        this.adapter = adapter;
        if (this.getInnerView() != null) {
            ((WXRecyclerView)this.getInnerView()).setAdapter(adapter);
        }
    }

    @Override
    public RecyclerViewBaseAdapter getRecyclerViewBaseAdapter() {
        return this.adapter;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = super.dispatchTouchEvent(event);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WXRecyclerView setInnerView(Context context) {
        WXRecyclerView wxRecyclerView = null;
        if (R.layout.weex_recycler_layout != 0) {
            XmlResourceParser parser = this.getResources().getXml(R.layout.weex_recycler_layout);
            AttributeSet attributes = Xml.asAttributeSet((XmlPullParser)parser);
            try {
                int type;
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type == 2) {
                    // empty if block
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            wxRecyclerView = new WXRecyclerView(context, attributes);
            wxRecyclerView.setScrollBarStyle(0x2000000);
            try {
                Method method = View.class.getDeclaredMethod("initializeScrollbars", TypedArray.class);
                method.setAccessible(true);
                method.invoke((Object)wxRecyclerView, new Object[]{null});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mOrientation == 1) {
                wxRecyclerView.setVerticalScrollBarEnabled(true);
            } else {
                wxRecyclerView.setHorizontalScrollBarEnabled(true);
            }
        } else {
            wxRecyclerView = new WXRecyclerView(context);
        }
        wxRecyclerView.setOverScrollMode(0);
        wxRecyclerView.initView(context, this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        return wxRecyclerView;
    }

    @Override
    public void onRefreshingComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onLoadmoreComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void notifyStickyShow(WXCell component) {
        this.mStickyHeaderHelper.notifyStickyShow(component);
    }

    @Override
    public void updateStickyView(int currentStickyPos) {
        this.mStickyHeaderHelper.updateStickyView(currentStickyPos);
    }

    @Override
    public void notifyStickyRemove(WXCell compToRemove) {
        this.mStickyHeaderHelper.notifyStickyRemove(compToRemove);
    }

    public StickyHeaderHelper getStickyHeaderHelper() {
        return this.mStickyHeaderHelper;
    }

    @Override
    public void registerGestureListener(@Nullable WXGesture wxGesture) {
        ((WXRecyclerView)this.getInnerView()).registerGestureListener(wxGesture);
    }

    @Override
    public WXGesture getGestureListener() {
        return ((WXRecyclerView)this.getInnerView()).getGestureListener();
    }
}

