/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter;

import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.Nullable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.WebSocketCloseCodes;
import dc.squareup.okhttp3.ConnectionPool;
import dc.squareup.okhttp3.ConnectionSpec;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.WebSocket;
import dc.squareup.okhttp3.WebSocketListener;
import dc.squareup.okio.ByteString;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import java.io.EOFException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class DefaultWebSocketAdapter
implements IWebSocketAdapter {
    private WebSocket ws;
    private IWebSocketAdapter.EventListener eventListener;
    private static ConnectionPool mConnectPool;

    @Override
    public void connect(String url, @Nullable String protocol, IWebSocketAdapter.EventListener listener) {
        this.eventListener = listener;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        try {
            SSLSocketFactory factory = null;
            if (Build.VERSION.SDK_INT < 21) {
                factory = DCloudTrustManager.getSSLSocketFactory((String)"TLSv1.2");
                if (factory != null) {
                    clientBuilder.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT));
                }
            } else {
                factory = DCloudTrustManager.getSSLSocketFactory();
            }
            if (factory != null) {
                clientBuilder.sslSocketFactory(factory);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        clientBuilder.readTimeout(24L, TimeUnit.HOURS);
        clientBuilder.writeTimeout(24L, TimeUnit.HOURS);
        clientBuilder.hostnameVerifier((HostnameVerifier)DCloudTrustManager.getHostnameVerifier((boolean)false));
        Request.Builder builder = new Request.Builder();
        if (!TextUtils.isEmpty((CharSequence)protocol)) {
            builder.addHeader("Sec-WebSocket-Protocol", protocol);
        }
        builder.addHeader("Origin", "http://localhost");
        builder.url(url);
        Request wsRequest = builder.build();
        OkHttpClient okHttpClient = clientBuilder.build();
        okHttpClient.newWebSocket(wsRequest, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                DefaultWebSocketAdapter.this.ws = webSocket;
                DefaultWebSocketAdapter.this.eventListener.onOpen();
                Headers wsHeaders = response.headers();
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : wsHeaders.names()) {
                    headers.put(name, wsHeaders.values(name).toString());
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                String msg = text;
                DefaultWebSocketAdapter.this.eventListener.onMessage(msg);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
                byte[] sources = bytes.toByteArray();
                String base64Str = Base64.encodeToString((byte[])sources, (int)2);
                JSONObject object = new JSONObject();
                object.put("@type", (Object)"binary");
                object.put("base64", (Object)base64Str);
                DefaultWebSocketAdapter.this.eventListener.onMessage(object.toJSONString());
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                DefaultWebSocketAdapter.this.eventListener.onClose(code, reason, true);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                DefaultWebSocketAdapter.this.eventListener.onClose(code, reason, true);
            }

            public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
                super.onFailure(webSocket, t, response);
                t.printStackTrace();
                if (t instanceof EOFException) {
                    DefaultWebSocketAdapter.this.eventListener.onClose(WebSocketCloseCodes.CLOSE_NORMAL.getCode(), WebSocketCloseCodes.CLOSE_NORMAL.name(), true);
                } else {
                    DefaultWebSocketAdapter.this.eventListener.onError(t.getMessage());
                }
            }
        });
    }

    @Override
    public void connect(String url, @Nullable String protocol, String headerJson, IWebSocketAdapter.EventListener listener) {
        this.eventListener = listener;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        try {
            SSLSocketFactory factory;
            if (Build.VERSION.SDK_INT < 21) {
                factory = DCloudTrustManager.getSSLSocketFactory((String)"TLSv1.2");
                if (factory != null) {
                    clientBuilder.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT));
                }
            } else {
                factory = DCloudTrustManager.getSSLSocketFactory();
            }
            if (factory != null) {
                clientBuilder.sslSocketFactory(factory);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        clientBuilder.readTimeout(24L, TimeUnit.HOURS);
        clientBuilder.writeTimeout(24L, TimeUnit.HOURS);
        if (mConnectPool == null) {
            mConnectPool = new ConnectionPool();
        }
        clientBuilder.connectionPool(mConnectPool);
        clientBuilder.hostnameVerifier((HostnameVerifier)DCloudTrustManager.getHostnameVerifier((boolean)false));
        Request.Builder builder = new Request.Builder();
        if (!TextUtils.isEmpty((CharSequence)protocol)) {
            builder.addHeader("Sec-WebSocket-Protocol", protocol);
        }
        builder.addHeader("Origin", "http://localhost");
        try {
            Map headMaps;
            if (!TextUtils.isEmpty((CharSequence)headerJson) && (headMaps = (Map)JSON.parse((String)headerJson)) != null) {
                for (Map.Entry entry : headMaps.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    if (TextUtils.isEmpty((CharSequence)key)) continue;
                    builder.addHeader(key, val);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        builder.url(url);
        Request wsRequest = builder.build();
        OkHttpClient okHttpClient = clientBuilder.build();
        okHttpClient.newWebSocket(wsRequest, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                DefaultWebSocketAdapter.this.ws = webSocket;
                DefaultWebSocketAdapter.this.eventListener.onOpen();
                Headers wsHeaders = response.headers();
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : wsHeaders.names()) {
                    headers.put(name, wsHeaders.values(name).toString());
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                String msg = text;
                DefaultWebSocketAdapter.this.eventListener.onMessage(msg);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
                byte[] sources = bytes.toByteArray();
                String base64Str = Base64.encodeToString((byte[])sources, (int)2);
                JSONObject object = new JSONObject();
                object.put("@type", (Object)"binary");
                object.put("base64", (Object)base64Str);
                DefaultWebSocketAdapter.this.eventListener.onMessage(object.toJSONString());
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                DefaultWebSocketAdapter.this.eventListener.onClose(code, reason, true);
            }

            public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
                super.onFailure(webSocket, t, response);
                t.printStackTrace();
                if (t instanceof EOFException) {
                    DefaultWebSocketAdapter.this.eventListener.onClose(WebSocketCloseCodes.CLOSE_NORMAL.getCode(), WebSocketCloseCodes.CLOSE_NORMAL.name(), true);
                } else {
                    DefaultWebSocketAdapter.this.eventListener.onError(t.getMessage());
                }
            }
        });
    }

    @Override
    public void send(String data) {
        try {
            JSONObject object = JSON.parseObject((String)data);
            String type = object.getString("@type");
            if (type != null && type.equals("binary") && object.containsKey((Object)"base64")) {
                this.send(object);
                return;
            }
        }
        catch (Exception object) {
            // empty catch block
        }
        if (this.ws != null) {
            try {
                this.ws.send(data);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.reportError(e.getMessage());
            }
        } else {
            this.reportError("WebSocket is not ready");
        }
    }

    public void send(JSONObject data) {
        block7: {
            if (this.ws != null) {
                try {
                    String type = data.getString("@type");
                    if (type != null && type.equals("binary") && data.containsKey((Object)"base64")) {
                        byte[] base64Byte = Base64.decode((String)data.getString("base64"), (int)0);
                        if (base64Byte != null) {
                            ByteString byteString = ByteString.of((byte[])base64Byte);
                            this.ws.send(byteString);
                        } else {
                            this.reportError("some error occur");
                        }
                        break block7;
                    }
                    this.reportError("some error occur");
                }
                catch (Exception e) {
                    this.reportError(e.getMessage());
                }
            } else {
                this.reportError("WebSocket is not ready");
            }
        }
    }

    @Override
    public void close(int code, String reason) {
        if (this.ws != null) {
            try {
                this.ws.close(code, reason);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.reportError(e.getMessage());
            }
        }
    }

    @Override
    public void destroy() {
        if (this.ws != null) {
            try {
                this.ws.close(WebSocketCloseCodes.CLOSE_GOING_AWAY.getCode(), WebSocketCloseCodes.CLOSE_GOING_AWAY.name());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void reportError(String message) {
        if (this.eventListener != null) {
            this.eventListener.onError(message);
        }
    }
}

