/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.plugin.weex;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.WeakRunnable;
import com.alibaba.android.bindingx.core.internal.Utils;
import com.alibaba.android.bindingx.plugin.weex.IWXViewUpdater;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.dom.transition.WXTransition;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class WXViewUpdateService {
    private static final Map<String, IWXViewUpdater> sTransformPropertyUpdaterMap;
    private static final LayoutUpdater sLayoutUpdater;
    private static final NOpUpdater EMPTY_INVOKER;
    private static final String PERSPECTIVE = "perspective";
    private static final String TRANSFORM_ORIGIN = "transformOrigin";
    private static final String LAYOUT_PROPERTY_WIDTH = "width";
    private static final String LAYOUT_PROPERTY_HEIGHT = "height";
    private static final String LAYOUT_PROPERTY_MARGIN_LEFT = "margin-left";
    private static final String LAYOUT_PROPERTY_MARGIN_RIGHT = "margin-right";
    private static final String LAYOUT_PROPERTY_MARGIN_TOP = "margin-top";
    private static final String LAYOUT_PROPERTY_MARGIN_BOTTOM = "margin-bottom";
    private static final String LAYOUT_PROPERTY_PADDING_LEFT = "padding-left";
    private static final String LAYOUT_PROPERTY_PADDING_RIGHT = "padding-right";
    private static final String LAYOUT_PROPERTY_PADDING_TOP = "padding-top";
    private static final String LAYOUT_PROPERTY_PADDING_BOTTOM = "padding-bottom";
    private static final List<String> LAYOUT_PROPERTIES;
    private static final Handler sUIHandler;

    WXViewUpdateService() {
    }

    @NonNull
    static IWXViewUpdater findUpdater(@NonNull String prop) {
        IWXViewUpdater updater = sTransformPropertyUpdaterMap.get(prop);
        if (updater != null) {
            return updater;
        }
        if (LAYOUT_PROPERTIES.contains(prop)) {
            sLayoutUpdater.setPropertyName(prop);
            return sLayoutUpdater;
        }
        LogProxy.e((String)("unknown property [" + prop + "]"));
        return EMPTY_INVOKER;
    }

    private static void runOnUIThread(Runnable runnable) {
        sUIHandler.post((Runnable)new WeakRunnable(runnable));
    }

    public static void clearCallbacks() {
        sUIHandler.removeCallbacksAndMessages(null);
    }

    private static double getRealSize(double size, @NonNull PlatformManager.IDeviceResolutionTranslator translator) {
        return translator.webToNative(size, new Object[0]);
    }

    @Nullable
    private static View findScrollTarget(@NonNull WXComponent component) {
        if (!(component instanceof WXScroller)) {
            LogProxy.e((String)"scroll offset only support on Scroller Component");
            return null;
        }
        WXScroller scroller = (WXScroller)component;
        return scroller.getInnerView();
    }

    static {
        sLayoutUpdater = new LayoutUpdater();
        EMPTY_INVOKER = new NOpUpdater();
        LAYOUT_PROPERTIES = Arrays.asList(LAYOUT_PROPERTY_WIDTH, LAYOUT_PROPERTY_HEIGHT, LAYOUT_PROPERTY_MARGIN_LEFT, LAYOUT_PROPERTY_MARGIN_RIGHT, LAYOUT_PROPERTY_MARGIN_TOP, LAYOUT_PROPERTY_MARGIN_BOTTOM, LAYOUT_PROPERTY_PADDING_LEFT, LAYOUT_PROPERTY_PADDING_RIGHT, LAYOUT_PROPERTY_PADDING_TOP, LAYOUT_PROPERTY_PADDING_BOTTOM);
        sUIHandler = new Handler(Looper.getMainLooper());
        sTransformPropertyUpdaterMap = new HashMap<String, IWXViewUpdater>();
        sTransformPropertyUpdaterMap.put("opacity", new OpacityUpdater());
        sTransformPropertyUpdaterMap.put("transform.translate", new TranslateUpdater());
        sTransformPropertyUpdaterMap.put("transform.translateX", new TranslateXUpdater());
        sTransformPropertyUpdaterMap.put("transform.translateY", new TranslateYUpdater());
        sTransformPropertyUpdaterMap.put("transform.scale", new ScaleUpdater());
        sTransformPropertyUpdaterMap.put("transform.scaleX", new ScaleXUpdater());
        sTransformPropertyUpdaterMap.put("transform.scaleY", new ScaleYUpdater());
        sTransformPropertyUpdaterMap.put("transform.rotate", new RotateUpdater());
        sTransformPropertyUpdaterMap.put("transform.rotateZ", new RotateUpdater());
        sTransformPropertyUpdaterMap.put("transform.rotateX", new RotateXUpdater());
        sTransformPropertyUpdaterMap.put("transform.rotateY", new RotateYUpdater());
        sTransformPropertyUpdaterMap.put("background-color", new BackgroundUpdater());
        sTransformPropertyUpdaterMap.put("color", new ColorUpdater());
        sTransformPropertyUpdaterMap.put("scroll.contentOffset", new ContentOffsetUpdater());
        sTransformPropertyUpdaterMap.put("scroll.contentOffsetX", new ContentOffsetXUpdater());
        sTransformPropertyUpdaterMap.put("scroll.contentOffsetY", new ContentOffsetYUpdater());
        sTransformPropertyUpdaterMap.put("border-top-left-radius", new BorderRadiusTopLeftUpdater());
        sTransformPropertyUpdaterMap.put("border-top-right-radius", new BorderRadiusTopRightUpdater());
        sTransformPropertyUpdaterMap.put("border-bottom-left-radius", new BorderRadiusBottomLeftUpdater());
        sTransformPropertyUpdaterMap.put("border-bottom-right-radius", new BorderRadiusBottomRightUpdater());
        sTransformPropertyUpdaterMap.put("border-radius", new BorderRadiusUpdater());
    }

    private static final class BorderRadiusUpdater
    implements IWXViewUpdater {
        private BorderRadiusUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (cmd instanceof ArrayList) {
                final ArrayList l = (ArrayList)cmd;
                if (l.size() != 4) {
                    return;
                }
                WXViewUpdateService.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Drawable drawable = targetView.getBackground();
                        if (drawable != null && drawable instanceof BorderDrawable) {
                            double topLeft = 0.0;
                            double topRight = 0.0;
                            double bottomLeft = 0.0;
                            double bottomRight = 0.0;
                            if (l.get(0) instanceof Double) {
                                topLeft = (Double)l.get(0);
                            }
                            if (l.get(1) instanceof Double) {
                                topRight = (Double)l.get(1);
                            }
                            if (l.get(2) instanceof Double) {
                                bottomLeft = (Double)l.get(2);
                            }
                            if (l.get(3) instanceof Double) {
                                bottomRight = (Double)l.get(3);
                            }
                            BorderDrawable borderDrawable = (BorderDrawable)drawable;
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_LEFT, (float)WXViewUpdateService.getRealSize(topLeft, translator));
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_RIGHT, (float)WXViewUpdateService.getRealSize(topRight, translator));
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, (float)WXViewUpdateService.getRealSize(bottomLeft, translator));
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, (float)WXViewUpdateService.getRealSize(bottomRight, translator));
                        }
                    }
                });
            } else if (cmd instanceof Double) {
                final double value = (Double)cmd;
                WXViewUpdateService.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Drawable drawable = targetView.getBackground();
                        if (drawable != null && drawable instanceof BorderDrawable) {
                            BorderDrawable borderDrawable = (BorderDrawable)drawable;
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_LEFT, (float)WXViewUpdateService.getRealSize(value, translator));
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_RIGHT, (float)WXViewUpdateService.getRealSize(value, translator));
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, (float)WXViewUpdateService.getRealSize(value, translator));
                            borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, (float)WXViewUpdateService.getRealSize(value, translator));
                        }
                    }
                });
            }
        }
    }

    private static final class BorderRadiusBottomRightUpdater
    implements IWXViewUpdater {
        private BorderRadiusBottomRightUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            final double d = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Drawable drawable = targetView.getBackground();
                    if (drawable != null && drawable instanceof BorderDrawable) {
                        BorderDrawable borderDrawable = (BorderDrawable)drawable;
                        borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, (float)WXViewUpdateService.getRealSize(d, translator));
                    }
                }
            });
        }
    }

    private static final class BorderRadiusBottomLeftUpdater
    implements IWXViewUpdater {
        private BorderRadiusBottomLeftUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            final double d = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Drawable drawable = targetView.getBackground();
                    if (drawable != null && drawable instanceof BorderDrawable) {
                        BorderDrawable borderDrawable = (BorderDrawable)drawable;
                        borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, (float)WXViewUpdateService.getRealSize(d, translator));
                    }
                }
            });
        }
    }

    private static final class BorderRadiusTopRightUpdater
    implements IWXViewUpdater {
        private BorderRadiusTopRightUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            final double d = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Drawable drawable = targetView.getBackground();
                    if (drawable != null && drawable instanceof BorderDrawable) {
                        BorderDrawable borderDrawable = (BorderDrawable)drawable;
                        borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_RIGHT, (float)WXViewUpdateService.getRealSize(d, translator));
                    }
                }
            });
        }
    }

    private static final class BorderRadiusTopLeftUpdater
    implements IWXViewUpdater {
        private BorderRadiusTopLeftUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            final double d = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Drawable drawable = targetView.getBackground();
                    if (drawable != null && drawable instanceof BorderDrawable) {
                        BorderDrawable borderDrawable = (BorderDrawable)drawable;
                        borderDrawable.setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_LEFT, (float)WXViewUpdateService.getRealSize(d, translator));
                    }
                }
            });
        }
    }

    private static final class ColorUpdater
    implements IWXViewUpdater {
        private ColorUpdater() {
        }

        @Override
        public void update(final @NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Integer)) {
                return;
            }
            final int d = (Integer)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        if (targetView instanceof TextView) {
                            ((TextView)targetView).setTextColor(d);
                        } else if (component instanceof WXText && targetView instanceof WXTextView) {
                            try {
                                ((WXTextView)targetView).setTextColor(d);
                                targetView.invalidate();
                            }
                            catch (Throwable e) {
                                LogProxy.e((String)"can not update text color, try fallback to call the old API", (Throwable)e);
                                Layout layout = ((WXTextView)targetView).getTextLayout();
                                if (layout == null) break block6;
                                TextPaint paint = layout.getPaint();
                                if (paint != null) {
                                    paint.setColor(d);
                                }
                                targetView.invalidate();
                            }
                        }
                    }
                }
            });
        }
    }

    private static final class BackgroundUpdater
    implements IWXViewUpdater {
        private BackgroundUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Integer)) {
                return;
            }
            final int d = (Integer)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Drawable drawable = targetView.getBackground();
                    if (drawable == null) {
                        targetView.setBackgroundColor(d);
                    } else if (drawable instanceof BorderDrawable) {
                        BorderDrawable borderDrawable = (BorderDrawable)drawable;
                        borderDrawable.setColor(d);
                    } else if (drawable instanceof ColorDrawable) {
                        ColorDrawable colorDrawable = (ColorDrawable)drawable;
                        colorDrawable.setColor(d);
                    }
                }
            });
        }
    }

    static final class LayoutUpdater
    implements IWXViewUpdater {
        private String propertyName;

        LayoutUpdater() {
        }

        void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void update(@NonNull WXComponent component, @NonNull View targetView, @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double) || TextUtils.isEmpty((CharSequence)this.propertyName)) {
                return;
            }
            double d = (Double)cmd;
            String property = null;
            switch (this.propertyName) {
                case "width": {
                    property = WXViewUpdateService.LAYOUT_PROPERTY_WIDTH;
                    break;
                }
                case "height": {
                    property = WXViewUpdateService.LAYOUT_PROPERTY_HEIGHT;
                    break;
                }
                case "margin-left": {
                    property = "marginLeft";
                    break;
                }
                case "margin-right": {
                    property = "marginRight";
                    break;
                }
                case "margin-top": {
                    property = "marginTop";
                    break;
                }
                case "margin-bottom": {
                    property = "marginBottom";
                    break;
                }
                case "padding-left": {
                    property = "paddingLeft";
                    break;
                }
                case "padding-right": {
                    property = "paddingRight";
                    break;
                }
                case "padding-top": {
                    property = "paddingTop";
                    break;
                }
                case "padding-bottom": {
                    property = "paddingBottom";
                    break;
                }
            }
            if (TextUtils.isEmpty((CharSequence)property)) {
                return;
            }
            WXTransition.asynchronouslyUpdateLayout((WXComponent)component, (String)property, (float)((float)WXViewUpdateService.getRealSize(d, translator)));
            this.propertyName = null;
        }
    }

    private static final class RotateYUpdater
    implements IWXViewUpdater {
        private RotateYUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, final @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, final @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    int perspective = WXUtils.getInt(config.get(WXViewUpdateService.PERSPECTIVE));
                    perspective = Utils.normalizedPerspectiveValue((Context)targetView.getContext(), (int)perspective);
                    Pair pivot = Utils.parseTransformOrigin((String)WXUtils.getString(config.get(WXViewUpdateService.TRANSFORM_ORIGIN), null), (View)targetView);
                    if (perspective != 0) {
                        targetView.setCameraDistance((float)perspective);
                    }
                    if (pivot != null) {
                        targetView.setPivotX(((Float)pivot.first).floatValue());
                        targetView.setPivotY(((Float)pivot.second).floatValue());
                    }
                    double d = (Double)cmd;
                    targetView.setRotationY((float)d);
                }
            });
        }
    }

    private static final class RotateXUpdater
    implements IWXViewUpdater {
        private RotateXUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, final @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, final @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    int perspective = WXUtils.getInt(config.get(WXViewUpdateService.PERSPECTIVE));
                    perspective = Utils.normalizedPerspectiveValue((Context)targetView.getContext(), (int)perspective);
                    Pair pivot = Utils.parseTransformOrigin((String)WXUtils.getString(config.get(WXViewUpdateService.TRANSFORM_ORIGIN), null), (View)targetView);
                    if (perspective != 0) {
                        targetView.setCameraDistance((float)perspective);
                    }
                    if (pivot != null) {
                        targetView.setPivotX(((Float)pivot.first).floatValue());
                        targetView.setPivotY(((Float)pivot.second).floatValue());
                    }
                    double d = (Double)cmd;
                    targetView.setRotationX((float)d);
                }
            });
        }
    }

    private static final class RotateUpdater
    implements IWXViewUpdater {
        private RotateUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, final @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, final @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    int perspective = WXUtils.getInt(config.get(WXViewUpdateService.PERSPECTIVE));
                    perspective = Utils.normalizedPerspectiveValue((Context)targetView.getContext(), (int)perspective);
                    Pair pivot = Utils.parseTransformOrigin((String)WXUtils.getString(config.get(WXViewUpdateService.TRANSFORM_ORIGIN), null), (View)targetView);
                    if (perspective != 0) {
                        targetView.setCameraDistance((float)perspective);
                    }
                    if (pivot != null) {
                        targetView.setPivotX(((Float)pivot.first).floatValue());
                        targetView.setPivotY(((Float)pivot.second).floatValue());
                    }
                    double d = (Double)cmd;
                    targetView.setRotation((float)d);
                }
            });
        }
    }

    private static final class ScaleYUpdater
    implements IWXViewUpdater {
        private ScaleYUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, final @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, final @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Pair pivot = Utils.parseTransformOrigin((String)WXUtils.getString(config.get(WXViewUpdateService.TRANSFORM_ORIGIN), null), (View)targetView);
                    if (pivot != null) {
                        targetView.setPivotX(((Float)pivot.first).floatValue());
                        targetView.setPivotY(((Float)pivot.second).floatValue());
                    }
                    double d = (Double)cmd;
                    targetView.setScaleY((float)d);
                }
            });
        }
    }

    private static final class ScaleXUpdater
    implements IWXViewUpdater {
        private ScaleXUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, final @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, final @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Pair pivot = Utils.parseTransformOrigin((String)WXUtils.getString(config.get(WXViewUpdateService.TRANSFORM_ORIGIN), null), (View)targetView);
                    if (pivot != null) {
                        targetView.setPivotX(((Float)pivot.first).floatValue());
                        targetView.setPivotY(((Float)pivot.second).floatValue());
                    }
                    double d3 = (Double)cmd;
                    targetView.setScaleX((float)d3);
                }
            });
        }
    }

    private static final class ScaleUpdater
    implements IWXViewUpdater {
        private ScaleUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, final @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, final @NonNull Map<String, Object> config) {
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    ArrayList list;
                    int perspective = WXUtils.getInt(config.get(WXViewUpdateService.PERSPECTIVE));
                    perspective = Utils.normalizedPerspectiveValue((Context)targetView.getContext(), (int)perspective);
                    Pair pivot = Utils.parseTransformOrigin((String)WXUtils.getString(config.get(WXViewUpdateService.TRANSFORM_ORIGIN), null), (View)targetView);
                    if (perspective != 0) {
                        targetView.setCameraDistance((float)perspective);
                    }
                    if (pivot != null) {
                        targetView.setPivotX(((Float)pivot.first).floatValue());
                        targetView.setPivotY(((Float)pivot.second).floatValue());
                    }
                    if (cmd instanceof Double) {
                        double val = (Double)cmd;
                        targetView.setScaleX((float)val);
                        targetView.setScaleY((float)val);
                    } else if (cmd instanceof ArrayList && (list = (ArrayList)cmd).size() >= 2 && list.get(0) instanceof Double && list.get(1) instanceof Double) {
                        double x = (Double)list.get(0);
                        double y = (Double)list.get(1);
                        targetView.setScaleX((float)x);
                        targetView.setScaleY((float)y);
                    }
                }
            });
        }
    }

    private static final class TranslateYUpdater
    implements IWXViewUpdater {
        private TranslateYUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            final double d = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    targetView.setTranslationY((float)WXViewUpdateService.getRealSize(d, translator));
                }
            });
        }
    }

    private static final class TranslateXUpdater
    implements IWXViewUpdater {
        private TranslateXUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            final double d = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    targetView.setTranslationX((float)WXViewUpdateService.getRealSize(d, translator));
                }
            });
        }
    }

    private static final class TranslateUpdater
    implements IWXViewUpdater {
        private TranslateUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof ArrayList)) {
                return;
            }
            ArrayList list = (ArrayList)cmd;
            if (list.size() >= 2 && list.get(0) instanceof Double && list.get(1) instanceof Double) {
                final double x1 = (Double)list.get(0);
                final double y1 = (Double)list.get(1);
                WXViewUpdateService.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        targetView.setTranslationX((float)WXViewUpdateService.getRealSize(x1, translator));
                        targetView.setTranslationY((float)WXViewUpdateService.getRealSize(y1, translator));
                    }
                });
            }
        }
    }

    private static final class OpacityUpdater
    implements IWXViewUpdater {
        private OpacityUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, final @NonNull View targetView, @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            double val = (Double)cmd;
            final float alpha = (float)val;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    targetView.setAlpha(alpha);
                }
            });
        }
    }

    private static final class ContentOffsetYUpdater
    implements IWXViewUpdater {
        private ContentOffsetYUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            if (!(cmd instanceof Double)) {
                return;
            }
            final View scrollView = WXViewUpdateService.findScrollTarget(component);
            if (scrollView == null) {
                return;
            }
            final double val = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    scrollView.setScrollY((int)WXViewUpdateService.getRealSize(val, translator));
                }
            });
        }
    }

    private static final class ContentOffsetXUpdater
    implements IWXViewUpdater {
        private ContentOffsetXUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            final View scrollView = WXViewUpdateService.findScrollTarget(component);
            if (scrollView == null) {
                return;
            }
            if (!(cmd instanceof Double)) {
                return;
            }
            final double val = (Double)cmd;
            WXViewUpdateService.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    scrollView.setScrollX((int)WXViewUpdateService.getRealSize(val, translator));
                }
            });
        }
    }

    private static final class ContentOffsetUpdater
    implements IWXViewUpdater {
        private ContentOffsetUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, @NonNull View targetView, @NonNull Object cmd, final @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
            ArrayList l;
            final View scrollView = WXViewUpdateService.findScrollTarget(component);
            if (scrollView == null) {
                return;
            }
            if (cmd instanceof Double) {
                final double val = (Double)cmd;
                WXViewUpdateService.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        scrollView.setScrollX((int)WXViewUpdateService.getRealSize(val, translator));
                        scrollView.setScrollY((int)WXViewUpdateService.getRealSize(val, translator));
                    }
                });
            } else if (cmd instanceof ArrayList && (l = (ArrayList)cmd).size() >= 2 && l.get(0) instanceof Double && l.get(1) instanceof Double) {
                final double x = (Double)l.get(0);
                final double y = (Double)l.get(1);
                WXViewUpdateService.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        scrollView.setScrollX((int)WXViewUpdateService.getRealSize(x, translator));
                        scrollView.setScrollY((int)WXViewUpdateService.getRealSize(y, translator));
                    }
                });
            }
        }
    }

    private static final class NOpUpdater
    implements IWXViewUpdater {
        private NOpUpdater() {
        }

        @Override
        public void update(@NonNull WXComponent component, @NonNull View targetView, @NonNull Object cmd, @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config) {
        }
    }
}

