/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.net;

import android.content.Context;
import android.util.Log;
import com.daya.orchestra.accompany.common.AccompanyManager;
import com.daya.orchestra.accompany.common.Constants;
import com.daya.orchestra.accompany.net.SSLSocketClient;
import com.daya.orchestra.accompany.utils.NetworkUtil;
import com.daya.orchestra.accompany.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitClientNoToken {
    private static final String API_HOST = AccompanyManager.getInstance().getBaseServerUrl();
    private static RetrofitClientNoToken instance;
    private static OkHttpClient okHttpClient;
    private static Retrofit retrofit;

    private RetrofitClientNoToken() {
        okHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).cache(RetrofitClientNoToken.createMCache()).retryOnConnectionFailure(true).sslSocketFactory(SSLSocketClient.getSSLSocketFactory(), (X509TrustManager)SSLSocketClient.getTrustManager()).hostnameVerifier(SSLSocketClient.getHostnameVerifier()).addInterceptor((Interceptor)this.initLogInterceptor()).build();
        retrofit = new Retrofit.Builder().baseUrl(API_HOST).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
    }

    private HttpLoggingInterceptor initLogInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        if (Constants.DEBUG) {
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        } else {
            interceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        }
        return interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RetrofitClientNoToken getInstance() {
        if (instance != null) return instance;
        Class<RetrofitClientNoToken> clazz = RetrofitClientNoToken.class;
        synchronized (RetrofitClientNoToken.class) {
            if (instance != null) return instance;
            instance = new RetrofitClientNoToken();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public OkHttpClient getOkHttpClient() {
        return okHttpClient;
    }

    public Retrofit getRetrofit() {
        return retrofit;
    }

    private static Cache createMCache() {
        File cacheFile = new File(String.valueOf(Utils.getApp().getCacheDir()));
        return new Cache(cacheFile, 0x3C00000L);
    }

    private Interceptor cacheInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                if (!NetworkUtil.isNetworkAvailable((Context)Utils.getApp())) {
                    request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                }
                Response response = chain.proceed(request);
                if (NetworkUtil.isNetworkAvailable((Context)Utils.getApp())) {
                    String cacheControl = request.cacheControl().toString();
                    Log.i((String)"has network", (String)("cacheControl=" + cacheControl));
                    return response.newBuilder().header("Cache-Control", cacheControl).removeHeader("Pragma").build();
                }
                int maxStale = 2419200;
                Log.i((String)"network error ", (String)("maxStale=" + maxStale));
                return response.newBuilder().header("Cache-Control", "public, only-if-cached, max-stale=" + maxStale).removeHeader("Pragma").build();
            }
        };
    }
}

