/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.recorder;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface AudioChunk {
    public double maxAmplitude();

    public byte[] toBytes();

    public short[] toShorts();

    public static class Shorts
    extends AbstractAudioChunk {
        private static final short SILENCE_THRESHOLD = 2700;
        private short[] shorts;

        Shorts(short[] bytes) {
            this.shorts = bytes;
        }

        boolean isOverSilence() {
            for (short sh : this.shorts) {
                if (sh <= 2700 && sh >= -2700) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte[] toBytes() {
            byte[] buffer = new byte[this.shorts.length * 2];
            for (int i = 0; i < this.shorts.length; ++i) {
                buffer[2 * i] = (byte)(this.shorts[i] & 0xFF);
                buffer[2 * i + 1] = (byte)((this.shorts[i] & 0xFF00) >> 8);
            }
            return buffer;
        }

        @Override
        public short[] toShorts() {
            return this.shorts;
        }
    }

    public static class Bytes
    extends AbstractAudioChunk {
        private byte[] bytes;

        Bytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte[] toBytes() {
            return this.bytes;
        }

        @Override
        public short[] toShorts() {
            short[] shorts = new short[this.bytes.length / 2];
            ByteBuffer.wrap(this.bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shorts);
            return shorts;
        }
    }

    public static abstract class AbstractAudioChunk
    implements AudioChunk {
        private static final double REFERENCE = 0.6;

        @Override
        public double maxAmplitude() {
            short nMaxAmp = 0;
            for (short sh : this.toShorts()) {
                if (sh <= nMaxAmp) continue;
                nMaxAmp = sh;
            }
            if (nMaxAmp > 0) {
                return Math.abs(20.0 * Math.log10((double)nMaxAmp / 0.6));
            }
            return 0.0;
        }
    }
}

