/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.symbol;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.jinmingyunle.midiplaylib.musictools.NoteDuration;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;

public class RestSymbol
implements MusicSymbol {
    private int starttime;
    private NoteDuration duration;
    private int width;

    public RestSymbol(int start, NoteDuration dur) {
        this.starttime = start;
        this.duration = dur;
        this.width = this.getMinWidth();
    }

    @Override
    public int getStartTime() {
        return this.starttime;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int value) {
        this.width = value;
    }

    @Override
    public int getMinWidth() {
        return 22;
    }

    @Override
    public int getAboveStaff() {
        return 0;
    }

    @Override
    public int getBelowStaff() {
        return 0;
    }

    @Override
    public void Draw(Canvas canvas, Paint paint, int ytop) {
        canvas.translate((float)(this.getWidth() - this.getMinWidth()), 0.0f);
        canvas.translate(4.0f, 0.0f);
        if (this.duration == NoteDuration.Whole) {
            this.DrawWhole(canvas, paint, ytop);
        } else if (this.duration == NoteDuration.Half) {
            this.DrawHalf(canvas, paint, ytop);
        } else if (this.duration == NoteDuration.Quarter) {
            this.DrawQuarter(canvas, paint, ytop);
        } else if (this.duration == NoteDuration.Eighth) {
            this.DrawEighth(canvas, paint, ytop);
        }
        canvas.translate(-4.0f, 0.0f);
        canvas.translate((float)(-(this.getWidth() - this.getMinWidth())), 0.0f);
    }

    public void DrawWhole(Canvas canvas, Paint paint, int ytop) {
        int y = ytop + 9;
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, (float)y, 10.0f, (float)(y + 4), paint);
        paint.setStyle(Paint.Style.STROKE);
    }

    public void DrawHalf(Canvas canvas, Paint paint, int ytop) {
        int y = ytop + 9 + 4;
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, (float)y, 10.0f, (float)(y + 4), paint);
        paint.setStyle(Paint.Style.STROKE);
    }

    public void DrawQuarter(Canvas canvas, Paint paint, int ytop) {
        paint.setStrokeCap(Paint.Cap.BUTT);
        int y = ytop + 4;
        int x = 2;
        int xend = x + 6;
        paint.setStrokeWidth(1.0f);
        canvas.drawLine((float)x, (float)y, (float)(xend - 1), (float)(y + 9 - 1), paint);
        paint.setStrokeWidth(3.0f);
        y = ytop + 9 + 1;
        canvas.drawLine((float)(xend - 2), (float)y, (float)x, (float)(y + 9), paint);
        paint.setStrokeWidth(1.0f);
        y = ytop + 18 - 1;
        canvas.drawLine(0.0f, (float)y, (float)(xend + 2), (float)(y + 9), paint);
        paint.setStrokeWidth(3.0f);
        canvas.drawLine((float)xend, (float)(y + 6), (float)(x / 2), (float)(y + 6), paint);
        paint.setStrokeWidth(1.0f);
        canvas.drawLine(0.0f, (float)(y + 6 + 1), (float)(xend - 1), (float)(y + 13), paint);
    }

    public void DrawEighth(Canvas canvas, Paint paint, int ytop) {
        int y = ytop + 9 - 1;
        RectF rect = new RectF(0.0f, (float)(y + 1), 6.0f, (float)(y + 1 + 7 - 1));
        paint.setStyle(Paint.Style.FILL);
        canvas.drawOval(rect, paint);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(1.0f);
        canvas.drawLine(2.0f, (float)(y + 7 - 1), 10.0f, (float)(y + 3), paint);
        canvas.drawLine(10.0f, (float)(y + 3), 5.0f, (float)(y + 18), paint);
    }

    public String toString() {
        return String.format("RestSymbol starttime=%1$s duration=%2$s width=%3$s", new Object[]{this.starttime, this.duration, this.width});
    }
}

