/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.ThreadUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.r;
import com.tencent.liteav.trtc.b;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import com.tencent.trtc.TRTCStatistics;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.microedition.khronos.egl.EGL10;

@JNINamespace(value="liteav::trtc")
public class TrtcCloudJni {
    private static final String TAG = "TrtcCloudJni";
    private static boolean mHasInited = false;
    private static final Object INIT_LOCK = new Object();
    private long mNativeTrtcCloudJni = 0L;
    private String mLocalUserId = "";
    private TRTCCloudListener mListener;
    private Handler mListenerHandler;
    private TRTCCloudListener.TRTCAudioFrameListener mAudioFrameListener;
    private final a<TRTCCloudListener.TRTCVideoFrameListener> mVideoFrameListenerWrapper;
    private TRTCCloudListener.TRTCVideoFrameListener mCalledGLCreatedFrameListener;
    private final Map<String, a<TRTCCloudListener.TRTCVideoRenderListener>> mRemoteVideoRenderListenerMap;
    private final a<TRTCCloudListener.TRTCVideoRenderListener> mLocalVideoRenderListenerWrapper;
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mJniReadLock = this.mReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mJniWriteLock = this.mReadWriteLock.writeLock();
    private final HashSet<View> mFloatingWindowSet = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(int env) {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (!mHasInited) {
                mHasInited = true;
                TrtcCloudJni.nativeGlobalInit(env);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninit() {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (mHasInited) {
                mHasInited = false;
                TrtcCloudJni.nativeGlobalUninit();
            }
            return;
        }
    }

    public TrtcCloudJni(boolean createBySharedInstance) {
        this(0L, createBySharedInstance);
    }

    public TrtcCloudJni(long mainPipeline, boolean createBySharedInstance) {
        this.mNativeTrtcCloudJni = mainPipeline == 0L ? TrtcCloudJni.nativeCreatePipeline(this, createBySharedInstance) : TrtcCloudJni.nativeCreateSubCloud(this, mainPipeline);
        this.mVideoFrameListenerWrapper = new a(0);
        this.mLocalVideoRenderListenerWrapper = new a(0);
        this.mRemoteVideoRenderListenerMap = new HashMap<String, a<TRTCCloudListener.TRTCVideoRenderListener>>();
        this.mListenerHandler = new Handler(Looper.getMainLooper());
    }

    public long getTrtcCloudJni() {
        this.mJniReadLock.lock();
        try {
            long l2 = this.mNativeTrtcCloudJni;
            return l2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void destroy() {
        this.mJniWriteLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeDestroyPipeline(this.mNativeTrtcCloudJni);
                this.mNativeTrtcCloudJni = 0L;
            }
            return;
        }
        finally {
            this.mJniWriteLock.unlock();
        }
    }

    public long createDeviceManager() {
        this.mJniReadLock.lock();
        try {
            long l2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeCreateDeviceManager(this.mNativeTrtcCloudJni) : 0L;
            return l2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public long createBeautyManager() {
        this.mJniReadLock.lock();
        try {
            long l2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeCreateBeautyManager(this.mNativeTrtcCloudJni) : 0L;
            return l2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public long createAudioEffectManager() {
        this.mJniReadLock.lock();
        try {
            long l2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeCreateAudioEffectManager(this.mNativeTrtcCloudJni) : 0L;
            return l2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setListener(TRTCCloudListener listener) {
        this.mListener = listener;
    }

    public void setListenerHandler(Handler listenerHandler) {
        this.mJniReadLock.lock();
        this.mListenerHandler = listenerHandler == null ? new Handler(Looper.getMainLooper()) : listenerHandler;
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetListenerHandler(this.mNativeTrtcCloudJni, listenerHandler);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    private void runOnListenerThread(Runnable task) {
        Handler handler = this.mListenerHandler;
        if (Looper.myLooper() != handler.getLooper()) {
            handler.post(task);
            return;
        }
        task.run();
    }

    public void enterRoom(TRTCCloudDef.TRTCParams param, int scene) {
        if (param == null) {
            LiteavLog.e(TAG, "enterRoom param is null");
            TrtcCloudJni trtcCloudJni = this;
            trtcCloudJni.runOnListenerThread(com.tencent.liteav.trtc.a.a(trtcCloudJni));
            return;
        }
        this.mJniReadLock.lock();
        try {
            this.mLocalUserId = param.userId;
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeEnterRoom(this.mNativeTrtcCloudJni, new EnterRoomParams(param), scene);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void exitRoom() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeExitRoom(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void switchRole(int role) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSwitchRole(this.mNativeTrtcCloudJni, role);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void switchRole(int role, String privateMapKey) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSwitchRoleWithPrivateMapKey(this.mNativeTrtcCloudJni, role, privateMapKey);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void connectOtherRoom(String param) {
        if (this.mNativeTrtcCloudJni != 0L) {
            TrtcCloudJni.nativeConnectOtherRoom(this.mNativeTrtcCloudJni, param);
        }
    }

    public void disconnectOtherRoom() {
        if (this.mNativeTrtcCloudJni != 0L) {
            TrtcCloudJni.nativeDisconnectOtherRoom(this.mNativeTrtcCloudJni);
        }
    }

    public void setDefaultStreamRecvMode(boolean autoRecvAudio, boolean autoRecvVideo) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetDefaultStreamRecvMode(this.mNativeTrtcCloudJni, autoRecvAudio, autoRecvVideo);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startLocalPreview(boolean frontCamera, TXCloudVideoView view) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartLocalPreview(this.mNativeTrtcCloudJni, frontCamera, new DisplayTarget(view));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void updateLocalView(TXCloudVideoView view) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeUpdateLocalView(this.mNativeTrtcCloudJni, new DisplayTarget(view));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopLocalPreview() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopLocalPreview(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startRemoteView(String userId, int streamType, TXCloudVideoView view) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartRemoteView(this.mNativeTrtcCloudJni, userId, streamType, new DisplayTarget(view));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startRemoteView(String userId, TXCloudVideoView view) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartRemoteViewWithoutStreamType(this.mNativeTrtcCloudJni, userId, new DisplayTarget(view));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void updateRemoteView(String userId, int streamType, TXCloudVideoView view) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeUpdateRemoteView(this.mNativeTrtcCloudJni, userId, streamType, new DisplayTarget(view));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopRemoteView(String userId, int streamType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopRemoteView(this.mNativeTrtcCloudJni, userId, streamType);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopRemoteView(String userId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopRemoteViewWithoutStreamType(this.mNativeTrtcCloudJni, userId);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopAllRemoteView() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopAllRemoteView(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setWatermark(Bitmap image, int streamType, float x2, float y2, float width) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetWatermark(this.mNativeTrtcCloudJni, image, streamType, x2, y2, width);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setVideoEncoderParams(int streamType, TRTCCloudDef.TRTCVideoEncParam params) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetVideoEncoderParams(this.mNativeTrtcCloudJni, streamType, new VideoEncParams(params));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startScreenCapture(int streamType, TRTCCloudDef.TRTCVideoEncParam encParams, final TRTCCloudDef.TRTCScreenShareParams shareParams) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                ScreenShareParams screenShareParams = null;
                if (shareParams != null) {
                    screenShareParams = new ScreenShareParams(shareParams);
                }
                if (encParams == null) {
                    TrtcCloudJni.nativeStartScreenCapture(this.mNativeTrtcCloudJni, streamType, null, screenShareParams);
                    LiteavLog.w(TAG, "startScreenCapture encParams is null");
                } else {
                    TrtcCloudJni.nativeStartScreenCapture(this.mNativeTrtcCloudJni, streamType, new VideoEncParams(encParams), screenShareParams);
                }
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        if (shareParams != null) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    TrtcCloudJni.this.showFloatingWindow(shareParams.floatingView);
                }
            });
        }
    }

    public void stopScreenCapture(int streamType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopScreenCapture(this.mNativeTrtcCloudJni, streamType);
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                TrtcCloudJni.this.hideFloatingWindow();
            }
        });
    }

    public void pauseScreenCapture(int streamType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativePauseScreenCapture(this.mNativeTrtcCloudJni, streamType);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void resumeScreenCapture(int streamType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeResumeScreenCapture(this.mNativeTrtcCloudJni, streamType);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void enableCustomVideoCapture(int streamType, boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeEnableCustomVideoCapture(this.mNativeTrtcCloudJni, streamType, enable);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void sendCustomVideoData(int streamType, TRTCCloudDef.TRTCVideoFrame frame) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                PixelFrame pixelFrame = new PixelFrame();
                TrtcCloudJni.shadowCopy(frame, pixelFrame);
                TrtcCloudJni.nativeSendCustomVideoData(this.mNativeTrtcCloudJni, streamType, pixelFrame);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setVideoMuteImage(int streamType, Bitmap image, int fps) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetVideoMuteImage(this.mNativeTrtcCloudJni, streamType, image, fps);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setVideoEncoderRotation(int rotation) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetVideoEncoderRotation(this.mNativeTrtcCloudJni, rotation);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setVideoEncoderMirror(boolean mirror) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetVideoEncoderMirror(this.mNativeTrtcCloudJni, mirror);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setGSensorMode(int streamType, int mode) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetGSensorMode(this.mNativeTrtcCloudJni, streamType, mode);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int enableEncSmallVideoStream(boolean enable, TRTCCloudDef.TRTCVideoEncParam smallVideoEncParam) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeEnableEncSmallVideoStream(this.mNativeTrtcCloudJni, enable, new VideoEncParams(smallVideoEncParam));
            }
            return 0;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int setRemoteVideoStreamType(String userId, int streamType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetRemoteVideoStreamType(this.mNativeTrtcCloudJni, userId, streamType);
            }
            return 0;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void snapshotVideo(String userId, int streamType, TRTCCloudListener.TRTCSnapshotListener listener) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSnapshotVideo(this.mNativeTrtcCloudJni, userId, streamType, listener);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setLocalViewFillMode(int mode) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetLocalViewFillMode(this.mNativeTrtcCloudJni, mode);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setLocalViewRotation(int rotation) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetLocalViewRotation(this.mNativeTrtcCloudJni, rotation);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setLocalViewMirror(int mirrorType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetLocalViewMirror(this.mNativeTrtcCloudJni, mirrorType);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setRemoteViewFillMode(String userId, int streamType, int mode) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetRemoteViewFillMode(this.mNativeTrtcCloudJni, userId, streamType, mode);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int setPriorRemoteVideoStreamType(int streamType) {
        if (this.mNativeTrtcCloudJni != 0L) {
            TrtcCloudJni.nativeSetPriorRemoteVideoStreamType(this.mNativeTrtcCloudJni, streamType);
        }
        return 0;
    }

    public void setRemoteViewRotation(String userId, int streamType, int rotation) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                if (rotation == 1) {
                    rotation = 3;
                } else if (rotation == 3) {
                    rotation = 1;
                }
                TrtcCloudJni.nativeSetRemoteViewRotation(this.mNativeTrtcCloudJni, userId, streamType, rotation);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setRemoteViewMirror(String userId, int streamType, int mirrorType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetRemoteViewMirror(this.mNativeTrtcCloudJni, userId, streamType, mirrorType);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startPublishing(String streamId, int streamType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartPublishing(this.mNativeTrtcCloudJni, streamId, streamType);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopPublishing() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopPublishing(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startPublishCDNStream(TRTCCloudDef.TRTCPublishCDNParam param) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartPublishCDNStream(this.mNativeTrtcCloudJni, new PublishCDNParams(param));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopPublishCDNStream() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopPublishCDNStream(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setMixTranscodingConfig(TRTCCloudDef.TRTCTranscodingConfig config) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetMixTranscodingConfig(this.mNativeTrtcCloudJni, config == null ? null : new TranscodingConfig(config));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startPublishMediaStream(TRTCCloudDef.TRTCPublishTarget target, TRTCCloudDef.TRTCStreamEncoderParam params, TRTCCloudDef.TRTCStreamMixingConfig config) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartPublishMediaStream(this.mNativeTrtcCloudJni, target == null ? null : new PublishTarget(target), params == null ? null : new StreamEncoderParam(params), config == null ? null : new StreamMixingConfig(config));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void updatePublishMediaStream(String taskId, TRTCCloudDef.TRTCPublishTarget target, TRTCCloudDef.TRTCStreamEncoderParam params, TRTCCloudDef.TRTCStreamMixingConfig config) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeUpdatePublishMediaStream(this.mNativeTrtcCloudJni, taskId, target == null ? null : new PublishTarget(target), params == null ? null : new StreamEncoderParam(params), config == null ? null : new StreamMixingConfig(config));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopPublishMediaStream(String taskId) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopPublishMediaStream(this.mNativeTrtcCloudJni, taskId);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void muteLocalVideo(int streamType, boolean mute) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeMuteLocalVideo(this.mNativeTrtcCloudJni, streamType, mute);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startLocalAudio(int quality) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartLocalAudioWithQuality(this.mNativeTrtcCloudJni, quality);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startLocalAudio() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartLocalAudio(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopLocalAudio() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopLocalAudio(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void muteRemoteVideoStream(String userId, int streamType, boolean mute) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeMuteRemoteVideoStream(this.mNativeTrtcCloudJni, userId, streamType, mute);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void muteAllRemoteVideoStreams(boolean mute) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeMuteAllRemoteVideoStreams(this.mNativeTrtcCloudJni, mute);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setNetworkQosParam(TRTCCloudDef.TRTCNetworkQosParam param) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetNetworkQosParam(this.mNativeTrtcCloudJni, param.preference, param.controlMode);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void switchRoom(TRTCCloudDef.TRTCSwitchRoomConfig config) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSwitchRoom(this.mNativeTrtcCloudJni, new SwitchRoomConfig(config));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setAudioQuality(int quality) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetAudioQuality(this.mNativeTrtcCloudJni, quality);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void muteLocalAudio(boolean mute) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeMuteLocalAudio(this.mNativeTrtcCloudJni, mute);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void muteRemoteAudio(String userId, boolean mute) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeMuteRemoteAudio(this.mNativeTrtcCloudJni, userId, mute);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void muteAllRemoteAudio(boolean mute) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeMuteAllRemoteAudio(this.mNativeTrtcCloudJni, mute);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setRemoteAudioVolume(String userId, int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetRemoteAudioVolume(this.mNativeTrtcCloudJni, userId, volume);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setAudioCaptureVolume(int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetAudioCaptureVolume(this.mNativeTrtcCloudJni, volume);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int getAudioCaptureVolume() {
        this.mJniReadLock.lock();
        try {
            int n2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeGetAudioCaptureVolume(this.mNativeTrtcCloudJni) : 0;
            return n2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setAudioPlayoutVolume(int volume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetAudioPlayoutVolume(this.mNativeTrtcCloudJni, volume);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int getAudioPlayoutVolume() {
        this.mJniReadLock.lock();
        try {
            int n2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeGetAudioPlayoutVolume(this.mNativeTrtcCloudJni) : 0;
            return n2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void enableAudioVolumeEvaluation(int interval, boolean enable_vad) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeEnableAudioVolumeEvaluation(this.mNativeTrtcCloudJni, interval, enable_vad);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setRemoteAudioParallelParams(TRTCCloudDef.TRTCAudioParallelParams params) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetRemoteAudioParallelParams(this.mNativeTrtcCloudJni, new AudioParallelParams(params));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void enable3DSpatialAudioEffect(boolean enabled) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeEnable3DSpatialAudioEffect(this.mNativeTrtcCloudJni, enabled);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void updateSelf3DSpatialPosition(int[] position, float[] axisForward, float[] axisRight, float[] axisUp) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeUpdateSelf3DSpatialPosition(this.mNativeTrtcCloudJni, position, axisForward, axisRight, axisUp);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void updateRemote3DSpatialPosition(String userId, int[] position) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeUpdateRemote3DSpatialPosition(this.mNativeTrtcCloudJni, userId, position);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void set3DSpatialReceivingRange(String userId, int range) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSet3DSpatialReceivingRange(this.mNativeTrtcCloudJni, userId, range);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int startAudioRecording(TRTCCloudDef.TRTCAudioRecordingParams param) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni == 0L) {
                return 0;
            }
            int n2 = TrtcCloudJni.nativeStartAudioRecording(this.mNativeTrtcCloudJni, new AudioRecordingParams(param));
            return n2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopAudioRecording() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopAudioRecording(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startLocalRecording(TRTCCloudDef.TRTCLocalRecordingParams params) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartLocalRecording(this.mNativeTrtcCloudJni, new LocalRecordingParams(params));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopLocalRecording() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopLocalRecording(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void enableCustomAudioCapture(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeEnableCustomAudioCapture(this.mNativeTrtcCloudJni, enable);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void sendCustomAudioData(TRTCCloudDef.TRTCAudioFrame frame) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSendCustomAudioData(this.mNativeTrtcCloudJni, new AudioFrame(frame));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void callExperimentalAPI(String jsonStr) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeCallExperimentalAPI(this.mNativeTrtcCloudJni, jsonStr);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void startSystemAudioLoopback() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartSystemAudioLoopback(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopSystemAudioLoopback() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopSystemAudioLoopback(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int setCapturedRawAudioFrameCallbackFormat(int sampleRate, int channels, int lengthInSample, int mode) {
        this.mJniReadLock.lock();
        try {
            int n2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeSetCapturedRawAudioFrameCallbackFormat(this.mNativeTrtcCloudJni, sampleRate, channels, lengthInSample, mode) : 0;
            return n2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int setLocalProcessedAudioFrameCallbackFormat(int sampleRate, int channels, int lengthInSample, int mode) {
        this.mJniReadLock.lock();
        try {
            int n2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeSetLocalProcessedAudioFrameCallbackFormat(this.mNativeTrtcCloudJni, sampleRate, channels, lengthInSample, mode) : 0;
            return n2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int setMixedPlayAudioFrameCallbackFormat(int sampleRate, int channels, int lengthInSample, int mode) {
        this.mJniReadLock.lock();
        try {
            int n2 = this.mNativeTrtcCloudJni != 0L ? TrtcCloudJni.nativeSetMixedPlayAudioFrameCallbackFormat(this.mNativeTrtcCloudJni, sampleRate, channels, lengthInSample, mode) : 0;
            return n2;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setAudioFrameListener(TRTCCloudListener.TRTCAudioFrameListener listener) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni == 0L) {
                return;
            }
            this.mAudioFrameListener = listener;
            TrtcCloudJni.nativeEnableAudioFrameNotification(this.mNativeTrtcCloudJni, listener != null);
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void enableCustomAudioRendering(boolean enable) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni == 0L) {
                return;
            }
            TrtcCloudJni.nativeEnableCustomAudioRendering(this.mNativeTrtcCloudJni, enable);
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void getCustomAudioRenderingFrame(TRTCCloudDef.TRTCAudioFrame audioFrame) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni == 0L) {
                return;
            }
            TrtcCloudJni.nativeGetCustomAudioRenderingFrame(this.mNativeTrtcCloudJni, audioFrame.data, audioFrame.sampleRate, audioFrame.channel);
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void enableMixExternalAudioFrame(boolean enablePublish, boolean enablePlayout) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeEnableMixExternalAudioFrame(this.mNativeTrtcCloudJni, enablePublish, enablePlayout);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public int mixExternalAudioFrame(TRTCCloudDef.TRTCAudioFrame frame) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                int n2 = TrtcCloudJni.nativeMixExternalAudioFrame(this.mNativeTrtcCloudJni, new AudioFrame(frame));
                return n2;
            }
            return -1;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void setMixExternalAudioVolume(int publishVolume, int playoutVolume) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeSetMixExternalAudioVolume(this.mNativeTrtcCloudJni, publishVolume, playoutVolume);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLocalVideoProcessListener(int streamType, int pixelFormat, int bufferType, TRTCCloudListener.TRTCVideoFrameListener listener) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni == 0L) {
                return 0;
            }
            GLConstants.PixelFormatType pixelFormatType = TrtcCloudJni.convertTRTCFormatTypeToPixelFormatType(pixelFormat);
            GLConstants.PixelBufferType pixelBufferType = TrtcCloudJni.convertTRTCBufferTypeToPixelBufferType(bufferType);
            if (!TrtcCloudJni.isCustomPreprocessSupportedFormatType(pixelFormatType)) {
                return -1327;
            }
            if (!TrtcCloudJni.isCustomPreprocessSupportedBufferType(pixelBufferType)) {
                return -1328;
            }
            a<TRTCCloudListener.TRTCVideoFrameListener> a2 = this.mVideoFrameListenerWrapper;
            synchronized (a2) {
                if (this.mVideoFrameListenerWrapper.d != null) {
                    TrtcCloudJni.nativeEnableVideoCustomPreprocess(this.mNativeTrtcCloudJni, false, this.mVideoFrameListenerWrapper.a, this.mVideoFrameListenerWrapper.b.getValue(), this.mVideoFrameListenerWrapper.c.mValue);
                }
                this.mVideoFrameListenerWrapper.d = listener;
                this.mVideoFrameListenerWrapper.a = streamType;
                this.mVideoFrameListenerWrapper.b = pixelFormatType;
                this.mVideoFrameListenerWrapper.c = pixelBufferType;
                if (listener != null) {
                    TrtcCloudJni.nativeEnableVideoCustomPreprocess(this.mNativeTrtcCloudJni, true, this.mVideoFrameListenerWrapper.a, this.mVideoFrameListenerWrapper.b.getValue(), this.mVideoFrameListenerWrapper.c.mValue);
                }
            }
            return 0;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLocalVideoRenderListener(int pixelFormat, int bufferType, TRTCCloudListener.TRTCVideoRenderListener listener) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni == 0L) {
                return 0;
            }
            GLConstants.PixelFormatType pixelFormatType = TrtcCloudJni.convertTRTCFormatTypeToPixelFormatType(pixelFormat);
            GLConstants.PixelBufferType pixelBufferType = TrtcCloudJni.convertTRTCBufferTypeToPixelBufferType(bufferType);
            if (!TrtcCloudJni.isCustomRenderSupportedFormatType(pixelFormatType)) {
                return -1327;
            }
            if (!TrtcCloudJni.isCustomRenderSupportedBufferType(pixelBufferType)) {
                return -1328;
            }
            a<TRTCCloudListener.TRTCVideoRenderListener> a2 = this.mLocalVideoRenderListenerWrapper;
            synchronized (a2) {
                block16: {
                    if (this.mLocalVideoRenderListenerWrapper.d == null) break block16;
                    if (this.mLocalVideoRenderListenerWrapper.b != pixelFormatType || this.mLocalVideoRenderListenerWrapper.c != pixelBufferType || listener == null) {
                        TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, false, "", 0, this.mLocalVideoRenderListenerWrapper.b.getValue(), this.mLocalVideoRenderListenerWrapper.c.mValue);
                        TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, false, "", 2, this.mLocalVideoRenderListenerWrapper.b.getValue(), this.mLocalVideoRenderListenerWrapper.c.mValue);
                        break block16;
                    }
                    this.mLocalVideoRenderListenerWrapper.d = listener;
                    return 0;
                }
                this.mLocalVideoRenderListenerWrapper.d = listener;
                this.mLocalVideoRenderListenerWrapper.b = pixelFormatType;
                this.mLocalVideoRenderListenerWrapper.c = pixelBufferType;
                if (listener != null) {
                    TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, true, "", 0, this.mLocalVideoRenderListenerWrapper.b.getValue(), this.mLocalVideoRenderListenerWrapper.c.mValue);
                    TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, true, "", 2, this.mLocalVideoRenderListenerWrapper.b.getValue(), this.mLocalVideoRenderListenerWrapper.c.mValue);
                }
            }
            return 0;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRemoteVideoRenderListener(String userId, int pixelFormat, int bufferType, TRTCCloudListener.TRTCVideoRenderListener listener) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni == 0L) {
                return 0;
            }
            if (TextUtils.isEmpty((CharSequence)userId)) {
                return -3319;
            }
            GLConstants.PixelFormatType pixelFormatType = TrtcCloudJni.convertTRTCFormatTypeToPixelFormatType(pixelFormat);
            GLConstants.PixelBufferType pixelBufferType = TrtcCloudJni.convertTRTCBufferTypeToPixelBufferType(bufferType);
            if (!TrtcCloudJni.isCustomRenderSupportedFormatType(pixelFormatType)) {
                return -1327;
            }
            if (!TrtcCloudJni.isCustomRenderSupportedBufferType(pixelBufferType)) {
                return -1328;
            }
            Map<String, a<TRTCCloudListener.TRTCVideoRenderListener>> map = this.mRemoteVideoRenderListenerMap;
            synchronized (map) {
                a<TRTCCloudListener.TRTCVideoRenderListener> a2 = this.mRemoteVideoRenderListenerMap.get(userId);
                if (a2 != null) {
                    if (a2.b != pixelFormatType || a2.c != pixelBufferType || listener == null) {
                        TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, false, "", 0, a2.b.getValue(), a2.c.mValue);
                        TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, false, "", 2, a2.b.getValue(), a2.c.mValue);
                    } else {
                        a2.d = listener;
                        this.mRemoteVideoRenderListenerMap.put(userId, a2);
                    }
                }
                if (listener != null) {
                    a a3 = new a(0);
                    new a(0).d = listener;
                    a3.b = pixelFormatType;
                    a3.c = pixelBufferType;
                    TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, true, userId, 0, a3.b.getValue(), a3.c.mValue);
                    TrtcCloudJni.nativeEnableVideoCustomRender(this.mNativeTrtcCloudJni, true, userId, 2, a3.b.getValue(), a3.c.mValue);
                    this.mRemoteVideoRenderListenerMap.put(userId, a3);
                } else {
                    this.mRemoteVideoRenderListenerMap.remove(userId);
                }
            }
            return 0;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void showDashboardManager(int showType) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeShowDashboardManager(this.mNativeTrtcCloudJni, showType);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public boolean sendSEIMsg(byte[] data, int repeatCount) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                boolean bl2 = TrtcCloudJni.nativeSendSEIMsg(this.mNativeTrtcCloudJni, data, repeatCount);
                return bl2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public boolean sendCustomCmdMsg(int cmdID, byte[] data, boolean reliable, boolean ordered) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                boolean bl2 = TrtcCloudJni.nativeSendCustomCmdMsg(this.mNativeTrtcCloudJni, cmdID, data, reliable, ordered);
                return bl2;
            }
        }
        finally {
            this.mJniReadLock.unlock();
        }
        return false;
    }

    public void startSpeedTest(boolean isBandwidthMode, TRTCCloudDef.TRTCSpeedTestParams params) {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStartSpeedTest(this.mNativeTrtcCloudJni, isBandwidthMode, new SpeedTestParams(params));
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    public void stopSpeedTest() {
        this.mJniReadLock.lock();
        try {
            if (this.mNativeTrtcCloudJni != 0L) {
                TrtcCloudJni.nativeStopSpeedTest(this.mNativeTrtcCloudJni);
            }
            return;
        }
        finally {
            this.mJniReadLock.unlock();
        }
    }

    @CalledByNative
    public void onEnterRoom(int code) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onEnterRoom(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void onExitRoom(int code) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onExitRoom(code);
        }
        Object object = this.mLocalVideoRenderListenerWrapper;
        synchronized (object) {
            this.mLocalVideoRenderListenerWrapper.d = null;
        }
        object = this.mRemoteVideoRenderListenerMap;
        synchronized (object) {
            this.mRemoteVideoRenderListenerMap.clear();
            return;
        }
    }

    @CalledByNative
    public void onError(int errorCode, String errorMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onError(errorCode, errorMsg, null);
        }
    }

    @CalledByNative
    public void onWarning(int code, String msg, Bundle extra_info) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onWarning(code, msg, extra_info);
        }
    }

    @CalledByNative
    public static Bundle createExtraInfoBundle(String key, int value) {
        Bundle bundle = new Bundle();
        bundle.putInt(key, value);
        return bundle;
    }

    @CalledByNative
    public void onSwitchRole(int code, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onSwitchRole(code, errMsg);
        }
    }

    @CalledByNative
    public void onSwitchRoom(int code, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onSwitchRoom(code, errMsg);
        }
    }

    @CalledByNative
    public void onConnectOtherRoom(String userId, int errCode, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onConnectOtherRoom(userId, errCode, errMsg);
        }
    }

    @CalledByNative
    public void onDisConnectOtherRoom(int errCode, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onDisConnectOtherRoom(errCode, errMsg);
        }
    }

    @CalledByNative
    public void onUserOnline(String userId) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onRemoteUserEnterRoom(userId);
        }
    }

    @CalledByNative
    public void onUserOffline(String userId, int reason) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onRemoteUserLeaveRoom(userId, reason);
        }
    }

    @CalledByNative
    void onUserVideoAvailable(String userId, boolean isAvailable) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUserVideoAvailable(userId, isAvailable);
        }
    }

    @CalledByNative
    void onUserSubStreamAvailable(String userId, boolean available) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUserSubStreamAvailable(userId, available);
        }
    }

    @CalledByNative
    void onUserAudioAvailable(String userId, boolean isAvailable) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUserAudioAvailable(userId, isAvailable);
        }
    }

    @CalledByNative
    void onFirstVideoFrame(String userId, int streamType, int width, int height) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onFirstVideoFrame(userId, streamType, width, height);
        }
    }

    @CalledByNative
    void onFirstAudioFrame(String userId) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onFirstAudioFrame(userId);
        }
    }

    @CalledByNative
    void onSendFirstLocalAudioFrame() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onSendFirstLocalAudioFrame();
        }
    }

    @CalledByNative
    void onSendFirstLocalVideoFrame(int streamType) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onSendFirstLocalVideoFrame(streamType);
        }
    }

    @CalledByNative
    void onCameraDidReady() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onCameraDidReady();
        }
    }

    @CalledByNative
    void onStartPublishing(int err, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onStartPublishing(err, errMsg);
        }
    }

    @CalledByNative
    void onStopPublishing(int err, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onStopPublishing(err, errMsg);
        }
    }

    @CalledByNative
    void onStartPublishCDNStream(int err, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onStartPublishCDNStream(err, errMsg);
        }
    }

    @CalledByNative
    void onStopPublishCDNStream(int err, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onStopPublishCDNStream(err, errMsg);
        }
    }

    @CalledByNative
    void onSetMixTranscodingConfig(int err, String errMsg) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onSetMixTranscodingConfig(err, errMsg);
        }
    }

    @CalledByNative
    void onScreenCaptureStarted() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onScreenCaptureStarted();
        }
    }

    @CalledByNative
    void onScreenCapturePaused() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onScreenCapturePaused();
        }
    }

    @CalledByNative
    void onScreenCaptureResumed() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onScreenCaptureResumed();
        }
    }

    @CalledByNative
    void onScreenCaptureStopped(int reason) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onScreenCaptureStopped(reason);
        }
    }

    @CalledByNative
    void onMicDidReady() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onMicDidReady();
        }
    }

    @CalledByNative
    void onConnectionLost() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onConnectionLost();
        }
    }

    @CalledByNative
    void onTryToReconnect() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onTryToReconnect();
        }
    }

    @CalledByNative
    void onConnectionRecovery() {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onConnectionRecovery();
        }
    }

    @CalledByNative
    public void onNetworkQuality(int localQuality, String[] remoteUserIds, int[] remoteQuality) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            TRTCCloudDef.TRTCQuality tRTCQuality = new TRTCCloudDef.TRTCQuality();
            new TRTCCloudDef.TRTCQuality().userId = "";
            tRTCQuality.quality = localQuality;
            ArrayList<TRTCCloudDef.TRTCQuality> arrayList = new ArrayList<TRTCCloudDef.TRTCQuality>();
            if (remoteUserIds != null && remoteUserIds.length != 0 && remoteQuality != null && remoteQuality.length != 0 && remoteQuality.length == remoteUserIds.length) {
                for (int i2 = 0; i2 < remoteUserIds.length; ++i2) {
                    TRTCCloudDef.TRTCQuality tRTCQuality2 = new TRTCCloudDef.TRTCQuality();
                    new TRTCCloudDef.TRTCQuality().userId = remoteUserIds[i2];
                    tRTCQuality2.quality = remoteQuality[i2];
                    arrayList.add(tRTCQuality2);
                }
            }
            tRTCCloudListener.onNetworkQuality(tRTCQuality, arrayList);
        }
    }

    @CalledByNative
    public void onUserVoiceVolume(String[] userIds, int[] volumes, int[] vads, int totalVolume) {
        if (userIds == null || volumes == null) {
            return;
        }
        if (userIds.length != volumes.length) {
            throw new IllegalArgumentException("Invalid parameter, userIds and volumes do not match.");
        }
        ArrayList<TRTCCloudDef.TRTCVolumeInfo> arrayList = new ArrayList<TRTCCloudDef.TRTCVolumeInfo>();
        for (int i2 = 0; i2 < userIds.length; ++i2) {
            TRTCCloudDef.TRTCVolumeInfo tRTCVolumeInfo = new TRTCCloudDef.TRTCVolumeInfo();
            tRTCVolumeInfo.userId = userIds[i2].isEmpty() && this.mLocalUserId != null && !this.mLocalUserId.isEmpty() ? this.mLocalUserId : userIds[i2];
            tRTCVolumeInfo.volume = volumes[i2];
            tRTCVolumeInfo.vad = vads[i2];
            arrayList.add(tRTCVolumeInfo);
        }
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUserVoiceVolume(arrayList, totalVolume);
        }
    }

    @CalledByNative
    public void onStatistics(Statistics statistics) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onStatistics(statistics.a);
        }
    }

    @CalledByNative
    public void onAudioRouteChanged(int newRoute, int oldRoute) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onAudioRouteChanged(newRoute, oldRoute);
        }
    }

    @CalledByNative
    public void onAudioCaptureProcessedData(byte[] data, long timestamp, int sampleRate, int channels) {
        TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
        if (tRTCAudioFrameListener == null) {
            return;
        }
        TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
        new TRTCCloudDef.TRTCAudioFrame().data = data;
        tRTCAudioFrame.timestamp = timestamp;
        tRTCAudioFrame.sampleRate = sampleRate;
        tRTCAudioFrame.channel = channels;
        tRTCAudioFrameListener.onCapturedRawAudioFrame(tRTCAudioFrame);
    }

    @CalledByNative
    public void onAudioPlayoutData(byte[] data, long timestamp, int sampleRate, int channels) {
        TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
        if (tRTCAudioFrameListener == null) {
            return;
        }
        TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
        new TRTCCloudDef.TRTCAudioFrame().data = data;
        tRTCAudioFrame.timestamp = timestamp;
        tRTCAudioFrame.sampleRate = sampleRate;
        tRTCAudioFrame.channel = channels;
        tRTCAudioFrameListener.onMixedPlayAudioFrame(tRTCAudioFrame);
    }

    @CalledByNative
    public void onAudioRemoteStreamData(String id, byte[] data, long timestamp, int sampleRate, int channels, byte[] extraData) {
        TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
        if (tRTCAudioFrameListener == null) {
            return;
        }
        TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
        new TRTCCloudDef.TRTCAudioFrame().data = data;
        tRTCAudioFrame.timestamp = timestamp;
        tRTCAudioFrame.sampleRate = sampleRate;
        tRTCAudioFrame.channel = channels;
        tRTCAudioFrame.extraData = extraData;
        tRTCAudioFrameListener.onRemoteUserAudioFrame(tRTCAudioFrame, id);
    }

    @CalledByNative
    public byte[] onLocalAudioStreamData(byte[] data, long timestamp, int sampleRate, int channels) {
        TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
        if (tRTCAudioFrameListener == null) {
            return null;
        }
        TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
        new TRTCCloudDef.TRTCAudioFrame().data = data;
        tRTCAudioFrame.timestamp = timestamp;
        tRTCAudioFrame.sampleRate = sampleRate;
        tRTCAudioFrame.channel = channels;
        tRTCAudioFrameListener.onLocalProcessedAudioFrame(tRTCAudioFrame);
        if (tRTCAudioFrame.extraData == null) {
            return null;
        }
        if (tRTCAudioFrame.extraData.length > 100) {
            LiteavLog.w(TAG, "Audioframe.extraData length need to be under 100!");
            return null;
        }
        return tRTCAudioFrame.extraData;
    }

    @CalledByNative
    public void onAudioMixedAllData(byte[] data, int sampleRate, int channels) {
        TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
        if (tRTCAudioFrameListener == null) {
            return;
        }
        TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
        new TRTCCloudDef.TRTCAudioFrame().data = data;
        tRTCAudioFrame.timestamp = 0L;
        tRTCAudioFrame.sampleRate = sampleRate;
        tRTCAudioFrame.channel = channels;
        tRTCAudioFrameListener.onMixedAllAudioFrame(tRTCAudioFrame);
    }

    @CalledByNative
    public void onRenderVideoFrame(String userId, int streamType, TRTCCloudDef.TRTCVideoFrame videoFrame) {
        TRTCCloudListener.TRTCVideoRenderListener tRTCVideoRenderListener;
        TRTCCloudListener.TRTCVideoRenderListener tRTCVideoRenderListener2;
        if (TextUtils.isEmpty((CharSequence)userId)) {
            userId = this.mLocalUserId;
            tRTCVideoRenderListener2 = (TRTCCloudListener.TRTCVideoRenderListener)this.mLocalVideoRenderListenerWrapper.d;
        } else {
            a<TRTCCloudListener.TRTCVideoRenderListener> a2 = this.mRemoteVideoRenderListenerMap.get(userId);
            tRTCVideoRenderListener2 = tRTCVideoRenderListener = a2 == null ? null : (TRTCCloudListener.TRTCVideoRenderListener)a2.d;
        }
        if (tRTCVideoRenderListener2 != null) {
            tRTCVideoRenderListener.onRenderVideoFrame(userId, streamType, videoFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void onGLContextCreated() {
        a<TRTCCloudListener.TRTCVideoFrameListener> a2 = this.mVideoFrameListenerWrapper;
        synchronized (a2) {
            this.mCalledGLCreatedFrameListener = (TRTCCloudListener.TRTCVideoFrameListener)this.mVideoFrameListenerWrapper.d;
        }
        LiteavLog.i(TAG, "onGLContextCreated " + this.mCalledGLCreatedFrameListener);
        if (this.mCalledGLCreatedFrameListener != null) {
            this.mCalledGLCreatedFrameListener.onGLContextCreated();
        }
    }

    @CalledByNative
    public void onGLContextDestroy() {
        LiteavLog.i(TAG, "onGLContextDestroy " + this.mCalledGLCreatedFrameListener);
        if (this.mCalledGLCreatedFrameListener != null) {
            this.mCalledGLCreatedFrameListener.onGLContextDestory();
            this.mCalledGLCreatedFrameListener = null;
        }
    }

    @CalledByNative
    public void onPreprocessVideoFrame(int streamType, PixelFrame srcFrame, PixelFrame dstFrame) {
        if (this.mCalledGLCreatedFrameListener == null) {
            return;
        }
        TRTCCloudListener.TRTCVideoFrameListener tRTCVideoFrameListener = this.mCalledGLCreatedFrameListener;
        if (tRTCVideoFrameListener != null) {
            TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame = new TRTCCloudDef.TRTCVideoFrame();
            TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame2 = new TRTCCloudDef.TRTCVideoFrame();
            TrtcCloudJni.shadowCopy(srcFrame, tRTCVideoFrame);
            TrtcCloudJni.shadowCopy(dstFrame, tRTCVideoFrame2);
            tRTCVideoFrameListener.onProcessVideoFrame(tRTCVideoFrame, tRTCVideoFrame2);
            TrtcCloudJni.shadowCopy(tRTCVideoFrame, srcFrame);
            TrtcCloudJni.shadowCopy(tRTCVideoFrame2, dstFrame);
        }
    }

    @CalledByNative
    public void onSnapshotComplete(TRTCCloudListener.TRTCSnapshotListener listener, Bitmap bitmap) {
        this.runOnListenerThread(b.a(listener, bitmap));
    }

    @CalledByNative
    public void onLocalRecordBegin(int errCode, String storagePath) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onLocalRecordBegin(errCode, storagePath);
        }
    }

    @CalledByNative
    public void onLocalRecording(long duration, String storagePath) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onLocalRecording(duration, storagePath);
        }
    }

    @CalledByNative
    public void onLocalRecordComplete(int errCode, String storagePath) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onLocalRecordComplete(errCode, storagePath);
        }
    }

    @CalledByNative
    public void onSpeedTest(SpeedTestResult speedTestResult, int finishedCount, int totalCount) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onSpeedTest(speedTestResult.a, finishedCount, totalCount);
        }
    }

    @CalledByNative
    public void onSpeedTestResult(SpeedTestResult speedTestResult) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onSpeedTestResult(speedTestResult.a);
        }
    }

    @CalledByNative
    public void onRemoteVideoStatusUpdated(String userId, int stream_type, int status_type, int reason) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onRemoteVideoStatusUpdated(userId, stream_type, status_type, reason, null);
        }
    }

    @CalledByNative
    public void onRemoteAudioStatusUpdated(String userId, int status_type, int reason) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onRemoteAudioStatusUpdated(userId, status_type, reason, null);
        }
    }

    @CalledByNative
    public void onUserVideoSizeChanged(String userId, int stream_type, int newWidth, int newHeight) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUserVideoSizeChanged(userId, stream_type, newWidth, newHeight);
        }
    }

    @CalledByNative
    public void onSEIMessageReceived(byte[] msg, String userId) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onRecvSEIMsg(userId, msg);
        }
    }

    @CalledByNative
    public void onRecvCustomCmdMsg(String userId, int cmdID, int seq, byte[] message) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onRecvCustomCmdMsg(userId, cmdID, seq, message);
        }
    }

    @CalledByNative
    public void onMissCustomCmdMsg(String userId, int cmdID, int errCode, int missed) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onMissCustomCmdMsg(userId, cmdID, errCode, missed);
        }
    }

    @CalledByNative
    public void onUserEnter(String userId) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUserEnter(userId);
        }
    }

    @CalledByNative
    public void onUserExit(String userId) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUserExit(userId, 0);
        }
    }

    @CalledByNative
    public void onStartPublishMediaStream(String taskId, int code, String msg, String extra) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onStartPublishMediaStream(taskId, code, msg, null);
        }
    }

    @CalledByNative
    public void onUpdatePublishMediaStream(String taskId, int code, String msg, String extra) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onUpdatePublishMediaStream(taskId, code, msg, null);
        }
    }

    @CalledByNative
    public void onStopPublishMediaStream(String taskId, int code, String msg, String extra) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onStopPublishMediaStream(taskId, code, msg, null);
        }
    }

    @CalledByNative
    public void onCdnStreamStateChanged(String cdnUrl, int status, int code, String msg, String extra) {
        TRTCCloudListener tRTCCloudListener = this.mListener;
        if (tRTCCloudListener != null) {
            tRTCCloudListener.onCdnStreamStateChanged(cdnUrl, status, code, msg, null);
        }
    }

    @CalledByNative
    @SuppressLint(value={"NewApi"})
    public TRTCCloudDef.TRTCVideoFrame createTRTCVideoFrame(int format, int bufferType, Object eglContext, int textureId, int width, int height, int rotation, long pts, byte[] data, ByteBuffer buffer) {
        TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame = new TRTCCloudDef.TRTCVideoFrame();
        GLConstants.PixelBufferType pixelBufferType = GLConstants.PixelBufferType.a(bufferType);
        GLConstants.PixelFormatType pixelFormatType = GLConstants.PixelFormatType.a(format);
        tRTCVideoFrame.pixelFormat = TrtcCloudJni.convertPixelFormatTypeToTRTCFormatType(pixelFormatType);
        tRTCVideoFrame.bufferType = TrtcCloudJni.convertPixelBufferTypeToTRTCBufferType(pixelBufferType);
        tRTCVideoFrame.texture = new TRTCCloudDef.TRTCTexture();
        tRTCVideoFrame.texture.textureId = textureId;
        if (eglContext instanceof javax.microedition.khronos.egl.EGLContext) {
            tRTCVideoFrame.texture.eglContext10 = (javax.microedition.khronos.egl.EGLContext)eglContext;
        } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 17 && eglContext instanceof EGLContext) {
            tRTCVideoFrame.texture.eglContext14 = (EGLContext)eglContext;
        }
        tRTCVideoFrame.data = data;
        tRTCVideoFrame.buffer = buffer;
        tRTCVideoFrame.width = width;
        tRTCVideoFrame.height = height;
        tRTCVideoFrame.timestamp = pts;
        Rotation rotation2 = Rotation.a(rotation);
        tRTCVideoFrame.rotation = TrtcCloudJni.convertPixelFrameRotationToTRTCVideoRotation(rotation2);
        return tRTCVideoFrame;
    }

    @CalledByNative
    public ByteBuffer createByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static Object getCurrentContext() {
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 17) {
            return EGL14.eglGetCurrentContext();
        }
        return ((EGL10)javax.microedition.khronos.egl.EGLContext.getEGL()).eglGetCurrentContext();
    }

    @CalledByNative
    public static boolean isInUIThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public static void setLogLevel(int level) {
        TrtcCloudJni.nativeSetLogLevel(level);
    }

    public static void setConsoleEnabled(boolean enabled) {
        TrtcCloudJni.nativeSetConsoleEnabled(enabled);
    }

    public static void setLogCompressEnabled(boolean enabled) {
        TrtcCloudJni.nativeSetLogCompressEnabled(enabled);
    }

    public static void setLogDirPath(String path) {
        TrtcCloudJni.nativeSetLogPath(path);
    }

    @SuppressLint(value={"NewApi"})
    private static void shadowCopy(@NonNull PixelFrame src, @NonNull TRTCCloudDef.TRTCVideoFrame dst) {
        dst.pixelFormat = TrtcCloudJni.convertPixelFormatTypeToTRTCFormatType(src.getPixelFormatType());
        dst.bufferType = TrtcCloudJni.convertPixelBufferTypeToTRTCBufferType(src.getPixelBufferType());
        dst.texture = new TRTCCloudDef.TRTCTexture();
        dst.texture.textureId = src.getTextureId();
        if (src.getGLContext() instanceof javax.microedition.khronos.egl.EGLContext) {
            dst.texture.eglContext10 = (javax.microedition.khronos.egl.EGLContext)src.getGLContext();
        } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 17 && src.getGLContext() instanceof EGLContext) {
            dst.texture.eglContext14 = (EGLContext)src.getGLContext();
        }
        dst.data = src.getData();
        dst.buffer = src.getBuffer();
        dst.width = src.getWidth();
        dst.height = src.getHeight();
        dst.timestamp = src.getTimestamp();
        dst.rotation = TrtcCloudJni.convertPixelFrameRotationToTRTCVideoRotation(src.getRotation());
    }

    private static void shadowCopy(@NonNull TRTCCloudDef.TRTCVideoFrame src, @NonNull PixelFrame dst) {
        TRTCCloudDef.TRTCTexture tRTCTexture = src.texture;
        dst.setPixelFormatType(TrtcCloudJni.convertTRTCFormatTypeToPixelFormatType(src.pixelFormat));
        dst.setPixelBufferType(TrtcCloudJni.convertTRTCBufferTypeToPixelBufferType(src.bufferType));
        int n2 = -1;
        EGLContext eGLContext = null;
        if (tRTCTexture != null) {
            n2 = tRTCTexture.textureId;
            eGLContext = tRTCTexture.eglContext10 == null ? tRTCTexture.eglContext14 : tRTCTexture.eglContext10;
        }
        dst.setTextureId(n2);
        dst.setGLContext(eGLContext);
        dst.setData(src.data);
        dst.setBuffer(src.buffer);
        dst.setWidth(src.width);
        dst.setHeight(src.height);
        dst.setTimestamp(src.timestamp);
        dst.setRotation(TrtcCloudJni.covertTRTCVideoRotationToPixelFrameRotation(src.rotation));
    }

    private static int convertPixelFrameRotationToTRTCVideoRotation(Rotation rotation) {
        switch (rotation) {
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        return 0;
    }

    private static Rotation covertTRTCVideoRotationToPixelFrameRotation(int rotation) {
        switch (rotation) {
            case 1: {
                return Rotation.b;
            }
            case 2: {
                return Rotation.c;
            }
            case 3: {
                return Rotation.d;
            }
        }
        return Rotation.a;
    }

    @SuppressLint(value={"NewApi"})
    private void showFloatingWindow(View view) {
        if (view == null) {
            return;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 23 && !Settings.canDrawOverlays((Context)view.getContext())) {
            LiteavLog.e(TAG, "can't show floating window for no drawing overlay permission");
            return;
        }
        if (this.mFloatingWindowSet.contains(view)) {
            LiteavLog.i(TAG, "the window has been added");
            return;
        }
        WindowManager windowManager = (WindowManager)view.getContext().getSystemService("window");
        if (windowManager == null) {
            LiteavLog.e(TAG, "get windowManager error");
            return;
        }
        this.mFloatingWindowSet.add(view);
        int n2 = 2005;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 26) {
            n2 = 2038;
        } else if (LiteavSystemInfo.getSystemOSVersionInt() > 24) {
            n2 = 2002;
        }
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(n2);
        new WindowManager.LayoutParams(n2).flags = 8;
        layoutParams.flags |= 0x40000;
        layoutParams.width = -2;
        layoutParams.height = -2;
        layoutParams.format = -3;
        windowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    private void hideFloatingWindow() {
        if (this.mFloatingWindowSet.isEmpty()) {
            return;
        }
        for (View view : this.mFloatingWindowSet) {
            WindowManager windowManager;
            if (view == null || (windowManager = (WindowManager)view.getContext().getSystemService("window")) == null) continue;
            windowManager.removeViewImmediate(view);
        }
        this.mFloatingWindowSet.clear();
    }

    private static native void nativeGlobalInit(int var0);

    private static native void nativeGlobalUninit();

    private static native void nativeSetLogPath(String var0);

    private static native void nativeSetLogLevel(int var0);

    private static native void nativeSetConsoleEnabled(boolean var0);

    private static native void nativeSetLogCompressEnabled(boolean var0);

    private static native void nativeSetListenerHandler(long var0, Handler var2);

    private static native long nativeCreatePipeline(TrtcCloudJni var0, boolean var1);

    private static native long nativeCreateSubCloud(TrtcCloudJni var0, long var1);

    private static native void nativeDestroyPipeline(long var0);

    private static native long nativeCreateAudioEffectManager(long var0);

    private static native long nativeCreateDeviceManager(long var0);

    private static native long nativeCreateBeautyManager(long var0);

    private static native void nativeEnterRoom(long var0, EnterRoomParams var2, int var3);

    private static native void nativeExitRoom(long var0);

    private static native void nativeSwitchRole(long var0, int var2);

    private static native void nativeSwitchRoleWithPrivateMapKey(long var0, int var2, String var3);

    private static native void nativeStartLocalPreview(long var0, boolean var2, DisplayTarget var3);

    private static native void nativeUpdateLocalView(long var0, DisplayTarget var2);

    private static native void nativeStopLocalPreview(long var0);

    private static native void nativeSetVideoEncoderRotation(long var0, int var2);

    private static native void nativeSetVideoEncoderMirror(long var0, boolean var2);

    private static native void nativeSetLocalViewFillMode(long var0, int var2);

    private static native void nativeSetLocalViewRotation(long var0, int var2);

    private static native void nativeSetLocalViewMirror(long var0, int var2);

    private static native void nativeSetRemoteViewFillMode(long var0, String var2, int var3, int var4);

    private static native void nativeSetRemoteViewRotation(long var0, String var2, int var3, int var4);

    private static native void nativeSetPriorRemoteVideoStreamType(long var0, int var2);

    private static native void nativeSetRemoteViewMirror(long var0, String var2, int var3, int var4);

    private static native void nativeStartRemoteView(long var0, String var2, int var3, DisplayTarget var4);

    private static native void nativeStartRemoteViewWithoutStreamType(long var0, String var2, DisplayTarget var3);

    private static native void nativeStopRemoteView(long var0, String var2, int var3);

    private static native void nativeStopRemoteViewWithoutStreamType(long var0, String var2);

    private static native void nativeStopAllRemoteView(long var0);

    private static native void nativeUpdateRemoteView(long var0, String var2, int var3, DisplayTarget var4);

    private static native void nativeConnectOtherRoom(long var0, String var2);

    private static native void nativeDisconnectOtherRoom(long var0);

    private static native void nativeStartPublishing(long var0, String var2, int var3);

    private static native void nativeStopPublishing(long var0);

    private static native void nativeStartPublishCDNStream(long var0, PublishCDNParams var2);

    private static native void nativeStopPublishCDNStream(long var0);

    private static native void nativeSetMixTranscodingConfig(long var0, TranscodingConfig var2);

    private static native void nativeStartPublishMediaStream(long var0, PublishTarget var2, StreamEncoderParam var3, StreamMixingConfig var4);

    private static native void nativeUpdatePublishMediaStream(long var0, String var2, PublishTarget var3, StreamEncoderParam var4, StreamMixingConfig var5);

    private static native void nativeStopPublishMediaStream(long var0, String var2);

    private static native void nativeSetDefaultStreamRecvMode(long var0, boolean var2, boolean var3);

    private static native void nativeMuteLocalVideo(long var0, int var2, boolean var3);

    private static native void nativeMuteAllRemoteVideoStreams(long var0, boolean var2);

    private static native void nativeMuteRemoteVideoStream(long var0, String var2, int var3, boolean var4);

    private static native void nativeStartLocalAudioWithQuality(long var0, int var2);

    private static native void nativeStartLocalAudio(long var0);

    private static native void nativeSetAudioQuality(long var0, int var2);

    private static native void nativeStopLocalAudio(long var0);

    private static native void nativeMuteLocalAudio(long var0, boolean var2);

    private static native void nativeMuteRemoteAudio(long var0, String var2, boolean var3);

    private static native void nativeMuteAllRemoteAudio(long var0, boolean var2);

    private static native void nativeSetRemoteAudioVolume(long var0, String var2, int var3);

    private static native void nativeSetAudioCaptureVolume(long var0, int var2);

    private static native int nativeGetAudioCaptureVolume(long var0);

    private static native void nativeSetAudioPlayoutVolume(long var0, int var2);

    private static native int nativeGetAudioPlayoutVolume(long var0);

    private static native void nativeEnableAudioVolumeEvaluation(long var0, int var2, boolean var3);

    private static native void nativeSetRemoteAudioParallelParams(long var0, AudioParallelParams var2);

    private static native void nativeEnable3DSpatialAudioEffect(long var0, boolean var2);

    private static native void nativeUpdateSelf3DSpatialPosition(long var0, int[] var2, float[] var3, float[] var4, float[] var5);

    private static native void nativeUpdateRemote3DSpatialPosition(long var0, String var2, int[] var3);

    private static native void nativeSet3DSpatialReceivingRange(long var0, String var2, int var3);

    private static native int nativeStartAudioRecording(long var0, AudioRecordingParams var2);

    private static native void nativeStopAudioRecording(long var0);

    private static native void nativeStartLocalRecording(long var0, LocalRecordingParams var2);

    private static native void nativeStopLocalRecording(long var0);

    private static native void nativeStartSpeedTest(long var0, boolean var2, SpeedTestParams var3);

    private static native void nativeStopSpeedTest(long var0);

    private static native void nativeEnableCustomAudioCapture(long var0, boolean var2);

    private static native void nativeSendCustomAudioData(long var0, AudioFrame var2);

    private static native int nativeSetCapturedRawAudioFrameCallbackFormat(long var0, int var2, int var3, int var4, int var5);

    private static native int nativeSetLocalProcessedAudioFrameCallbackFormat(long var0, int var2, int var3, int var4, int var5);

    private static native int nativeSetMixedPlayAudioFrameCallbackFormat(long var0, int var2, int var3, int var4, int var5);

    private static native void nativeEnableAudioFrameNotification(long var0, boolean var2);

    private static native void nativeEnableVideoCustomPreprocess(long var0, boolean var2, int var3, int var4, int var5);

    private static native void nativeEnableVideoCustomRender(long var0, boolean var2, String var3, int var4, int var5, int var6);

    private static native void nativeSetVideoMuteImage(long var0, int var2, Bitmap var3, int var4);

    private static native void nativeSetGSensorMode(long var0, int var2, int var3);

    private static native void nativeEnableEncSmallVideoStream(long var0, boolean var2, VideoEncParams var3);

    private static native void nativeSetRemoteVideoStreamType(long var0, String var2, int var3);

    private static native void nativeSnapshotVideo(long var0, String var2, int var3, TRTCCloudListener.TRTCSnapshotListener var4);

    private static native void nativeSetWatermark(long var0, Bitmap var2, int var3, float var4, float var5, float var6);

    private static native void nativeSetVideoEncoderParams(long var0, int var2, VideoEncParams var3);

    private static native void nativeStartScreenCapture(long var0, int var2, VideoEncParams var3, ScreenShareParams var4);

    private static native void nativeStopScreenCapture(long var0, int var2);

    private static native void nativePauseScreenCapture(long var0, int var2);

    private static native void nativeResumeScreenCapture(long var0, int var2);

    private static native void nativeEnableCustomVideoCapture(long var0, int var2, boolean var3);

    private static native void nativeSendCustomVideoData(long var0, int var2, PixelFrame var3);

    private static native void nativeEnableCustomAudioRendering(long var0, boolean var2);

    private static native void nativeGetCustomAudioRenderingFrame(long var0, byte[] var2, int var3, int var4);

    private static native void nativeShowDashboardManager(long var0, int var2);

    private static native void nativeEnableMixExternalAudioFrame(long var0, boolean var2, boolean var3);

    private static native int nativeMixExternalAudioFrame(long var0, AudioFrame var2);

    private static native void nativeSetMixExternalAudioVolume(long var0, int var2, int var3);

    private static native void nativeCallExperimentalAPI(long var0, String var2);

    private static native boolean nativeSendSEIMsg(long var0, byte[] var2, int var3);

    private static native boolean nativeSendCustomCmdMsg(long var0, int var2, byte[] var3, boolean var4, boolean var5);

    private static native void nativeSetNetworkQosParam(long var0, int var2, int var3);

    private static native void nativeSwitchRoom(long var0, SwitchRoomConfig var2);

    private static native void nativeStartSystemAudioLoopback(long var0);

    private static native void nativeStopSystemAudioLoopback(long var0);

    private static GLConstants.PixelFormatType convertTRTCFormatTypeToPixelFormatType(int trtcFormatType) {
        GLConstants.PixelFormatType pixelFormatType;
        switch (trtcFormatType) {
            case 4: {
                pixelFormatType = GLConstants.PixelFormatType.c;
                break;
            }
            case 2: 
            case 5: {
                pixelFormatType = GLConstants.PixelFormatType.f;
                break;
            }
            default: {
                pixelFormatType = GLConstants.PixelFormatType.a;
            }
        }
        return pixelFormatType;
    }

    private static GLConstants.PixelBufferType convertTRTCBufferTypeToPixelBufferType(int trtcBufferType) {
        GLConstants.PixelBufferType pixelBufferType;
        switch (trtcBufferType) {
            case 2: {
                pixelBufferType = GLConstants.PixelBufferType.d;
                break;
            }
            case 1: {
                pixelBufferType = GLConstants.PixelBufferType.a;
                break;
            }
            default: {
                pixelBufferType = GLConstants.PixelBufferType.b;
            }
        }
        return pixelBufferType;
    }

    private static int convertPixelFormatTypeToTRTCFormatType(GLConstants.PixelFormatType formatType) {
        int n2 = formatType == GLConstants.PixelFormatType.a ? 1 : (formatType == GLConstants.PixelFormatType.c ? 4 : (formatType == GLConstants.PixelFormatType.f ? 5 : 0));
        return n2;
    }

    private static int convertPixelBufferTypeToTRTCBufferType(GLConstants.PixelBufferType bufferType) {
        int n2 = bufferType == GLConstants.PixelBufferType.a ? 1 : (bufferType == GLConstants.PixelBufferType.d ? 2 : (bufferType == GLConstants.PixelBufferType.b ? 3 : 0));
        return n2;
    }

    private static boolean isCustomRenderSupportedFormatType(GLConstants.PixelFormatType pixelFormatType) {
        return pixelFormatType == GLConstants.PixelFormatType.a || pixelFormatType == GLConstants.PixelFormatType.c || pixelFormatType == GLConstants.PixelFormatType.f;
    }

    private static boolean isCustomRenderSupportedBufferType(GLConstants.PixelBufferType pixelBufferType) {
        return pixelBufferType == GLConstants.PixelBufferType.a || pixelBufferType == GLConstants.PixelBufferType.d || pixelBufferType == GLConstants.PixelBufferType.b;
    }

    private static boolean isCustomPreprocessSupportedFormatType(GLConstants.PixelFormatType pixelFormatType) {
        return pixelFormatType == GLConstants.PixelFormatType.a || pixelFormatType == GLConstants.PixelFormatType.c || pixelFormatType == GLConstants.PixelFormatType.f;
    }

    private static boolean isCustomPreprocessSupportedBufferType(GLConstants.PixelBufferType pixelBufferType) {
        return pixelBufferType == GLConstants.PixelBufferType.a || pixelBufferType == GLConstants.PixelBufferType.d || pixelBufferType == GLConstants.PixelBufferType.b;
    }

    static /* synthetic */ void lambda$onSnapshotComplete$1(TRTCCloudListener.TRTCSnapshotListener listener, Bitmap bitmap) {
        if (listener != null) {
            listener.onSnapshotComplete(bitmap);
        }
    }

    static /* synthetic */ void lambda$enterRoom$0(TrtcCloudJni this_) {
        this_.onEnterRoom(-3316);
        this_.onError(-3316, "enter room param null");
    }

    static {
        r.a();
    }

    static final class a<T> {
        public int a;
        public GLConstants.PixelFormatType b;
        public GLConstants.PixelBufferType c;
        public T d;

        private a() {
        }

        /* synthetic */ a(byte by2) {
            this();
        }
    }

    static class StreamMixingConfig {
        private TRTCCloudDef.TRTCStreamMixingConfig a;

        public StreamMixingConfig(TRTCCloudDef.TRTCStreamMixingConfig config) {
            this.a = config;
        }

        @CalledByNative(value="StreamMixingConfig")
        public int getBackgroundColor() {
            return this.a.backgroundColor;
        }

        @CalledByNative(value="StreamMixingConfig")
        public String getBackgroundImage() {
            if (this.a.backgroundImage != null) {
                return this.a.backgroundImage;
            }
            return "";
        }

        @CalledByNative(value="StreamMixingConfig")
        public VideoLayout[] getVideoLayoutList() {
            if (this.a.videoLayoutList == null) {
                return null;
            }
            VideoLayout[] videoLayoutArray = new VideoLayout[this.a.videoLayoutList.size()];
            for (int i2 = 0; i2 < this.a.videoLayoutList.size(); ++i2) {
                videoLayoutArray[i2] = new VideoLayout(this.a.videoLayoutList.get(i2));
            }
            return videoLayoutArray;
        }

        @CalledByNative(value="StreamMixingConfig")
        public TRTCUser[] getAudioMixUserList() {
            if (this.a.audioMixUserList == null) {
                return null;
            }
            TRTCUser[] tRTCUserArray = new TRTCUser[this.a.audioMixUserList.size()];
            for (int i2 = 0; i2 < this.a.audioMixUserList.size(); ++i2) {
                tRTCUserArray[i2] = new TRTCUser(this.a.audioMixUserList.get(i2));
            }
            return tRTCUserArray;
        }

        @CalledByNative(value="StreamMixingConfig")
        public Watermark[] getWatermarkList() {
            if (this.a.watermarkList == null) {
                return null;
            }
            Watermark[] watermarkArray = new Watermark[this.a.watermarkList.size()];
            for (int i2 = 0; i2 < this.a.watermarkList.size(); ++i2) {
                watermarkArray[i2] = new Watermark(this.a.watermarkList.get(i2));
            }
            return watermarkArray;
        }
    }

    static class StreamEncoderParam {
        private TRTCCloudDef.TRTCStreamEncoderParam a;

        public StreamEncoderParam(TRTCCloudDef.TRTCStreamEncoderParam param) {
            this.a = param;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getVideoEncodedWidth() {
            return this.a.videoEncodedWidth;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getVideoEncodedHeight() {
            return this.a.videoEncodedHeight;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getVideoEncodedFPS() {
            return this.a.videoEncodedFPS;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getVideoEncodedGOP() {
            return this.a.videoEncodedGOP;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getVideoEncodedKbps() {
            return this.a.videoEncodedKbps;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getAudioEncodedSampleRate() {
            return this.a.audioEncodedSampleRate;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getAudioEncodedChannelNum() {
            return this.a.audioEncodedChannelNum;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getAudioEncodedKbps() {
            return this.a.audioEncodedKbps;
        }

        @CalledByNative(value="StreamEncoderParam")
        public int getAudioEncodedCodecType() {
            return this.a.audioEncodedCodecType;
        }
    }

    static class Watermark {
        private TRTCCloudDef.TRTCWatermark a;

        public Watermark(TRTCCloudDef.TRTCWatermark waterMark) {
            this.a = waterMark;
        }

        @CalledByNative(value="Watermark")
        public String getWatermarkUrl() {
            if (this.a.watermarkUrl != null) {
                return this.a.watermarkUrl;
            }
            return "";
        }

        @CalledByNative(value="Watermark")
        public int getX() {
            return this.a.x;
        }

        @CalledByNative(value="Watermark")
        public int getY() {
            return this.a.y;
        }

        @CalledByNative(value="Watermark")
        public int getWidth() {
            return this.a.width;
        }

        @CalledByNative(value="Watermark")
        public int getHeight() {
            return this.a.height;
        }

        @CalledByNative(value="Watermark")
        public int getZOrder() {
            return this.a.zOrder;
        }
    }

    static class VideoLayout {
        private TRTCCloudDef.TRTCVideoLayout a;

        public VideoLayout(TRTCCloudDef.TRTCVideoLayout layout2) {
            this.a = layout2;
        }

        @CalledByNative(value="VideoLayout")
        public int getX() {
            return this.a.x;
        }

        @CalledByNative(value="VideoLayout")
        public int getY() {
            return this.a.y;
        }

        @CalledByNative(value="VideoLayout")
        public int getWidth() {
            return this.a.width;
        }

        @CalledByNative(value="VideoLayout")
        public int getHeight() {
            return this.a.height;
        }

        @CalledByNative(value="VideoLayout")
        public int getZOrder() {
            return this.a.zOrder;
        }

        @CalledByNative(value="VideoLayout")
        public int getFillMode() {
            return this.a.fillMode;
        }

        @CalledByNative(value="VideoLayout")
        public int getBackgroundColor() {
            return this.a.backgroundColor;
        }

        @CalledByNative(value="VideoLayout")
        public String getPlaceHolderImage() {
            if (this.a.placeHolderImage != null) {
                return this.a.placeHolderImage;
            }
            return "";
        }

        @CalledByNative(value="VideoLayout")
        public TRTCUser getTRTCUser() {
            return new TRTCUser(this.a.fixedVideoUser);
        }

        @CalledByNative(value="VideoLayout")
        public int getVideoStreamType() {
            return this.a.fixedVideoStreamType;
        }
    }

    static class PublishTarget {
        private TRTCCloudDef.TRTCPublishTarget a;

        public PublishTarget(TRTCCloudDef.TRTCPublishTarget target) {
            this.a = target;
        }

        @CalledByNative(value="PublishTarget")
        public int getMode() {
            return this.a.mode;
        }

        @CalledByNative(value="PublishTarget")
        public PublishCdnUrl[] getPublishCdnUrls() {
            if (this.a.cdnUrlList == null) {
                return null;
            }
            PublishCdnUrl[] publishCdnUrlArray = new PublishCdnUrl[this.a.cdnUrlList.size()];
            for (int i2 = 0; i2 < this.a.cdnUrlList.size(); ++i2) {
                publishCdnUrlArray[i2] = new PublishCdnUrl(this.a.cdnUrlList.get(i2));
            }
            return publishCdnUrlArray;
        }

        @CalledByNative(value="PublishTarget")
        public TRTCUser getTRTCUser() {
            return new TRTCUser(this.a.mixStreamIdentity);
        }
    }

    static class TRTCUser {
        private TRTCCloudDef.TRTCUser a;

        public TRTCUser(TRTCCloudDef.TRTCUser user) {
            this.a = user;
        }

        @CalledByNative(value="TRTCUser")
        public String getUserId() {
            if (this.a.userId != null) {
                return this.a.userId;
            }
            return "";
        }

        @CalledByNative(value="TRTCUser")
        public int getIntRoomId() {
            return this.a.intRoomId;
        }

        @CalledByNative(value="TRTCUser")
        public String getStrRoomId() {
            if (this.a.strRoomId != null) {
                return this.a.strRoomId;
            }
            return "";
        }
    }

    static class PublishCdnUrl {
        private TRTCCloudDef.TRTCPublishCdnUrl a;

        public PublishCdnUrl(TRTCCloudDef.TRTCPublishCdnUrl url) {
            this.a = url;
        }

        @CalledByNative(value="PublishCdnUrl")
        public String getRtmpUrl() {
            if (this.a.rtmpUrl != null) {
                return this.a.rtmpUrl;
            }
            return "";
        }

        @CalledByNative(value="PublishCdnUrl")
        public boolean getIsInternalLine() {
            return this.a.isInternalLine;
        }
    }

    static class SwitchRoomConfig {
        private TRTCCloudDef.TRTCSwitchRoomConfig a;

        public SwitchRoomConfig(TRTCCloudDef.TRTCSwitchRoomConfig config) {
            this.a = config;
        }

        @CalledByNative(value="SwitchRoomConfig")
        public int getRoomId() {
            return this.a.roomId;
        }

        @CalledByNative(value="SwitchRoomConfig")
        public String getStringRoomId() {
            if (this.a.strRoomId != null) {
                return this.a.strRoomId;
            }
            return "";
        }

        @CalledByNative(value="SwitchRoomConfig")
        public String getUserSig() {
            if (this.a.userSig != null) {
                return this.a.userSig;
            }
            return "";
        }

        @CalledByNative(value="SwitchRoomConfig")
        public String getPrivateMapKey() {
            if (this.a.privateMapKey != null) {
                return this.a.privateMapKey;
            }
            return "";
        }
    }

    static class SpeedTestResult {
        private TRTCCloudDef.TRTCSpeedTestResult a = new TRTCCloudDef.TRTCSpeedTestResult();

        SpeedTestResult() {
        }

        @CalledByNative(value="SpeedTestResult")
        public static SpeedTestResult createSpeedTestResult(boolean success, String errMsg, String ip, int quality, float upLostRate, float downLostRate, int rtt, int availableUpBandwidth, int availableDownBandwidth) {
            SpeedTestResult speedTestResult = new SpeedTestResult();
            new SpeedTestResult().a.success = success;
            speedTestResult.a.errMsg = errMsg;
            speedTestResult.a.ip = ip;
            speedTestResult.a.quality = quality;
            speedTestResult.a.upLostRate = upLostRate;
            speedTestResult.a.downLostRate = downLostRate;
            speedTestResult.a.rtt = rtt;
            speedTestResult.a.availableUpBandwidth = availableUpBandwidth;
            speedTestResult.a.availableDownBandwidth = availableDownBandwidth;
            return speedTestResult;
        }
    }

    static class SpeedTestParams {
        private final TRTCCloudDef.TRTCSpeedTestParams a;

        public SpeedTestParams(TRTCCloudDef.TRTCSpeedTestParams params) {
            this.a = params;
        }

        @CalledByNative(value="SpeedTestParams")
        public int getSDKAppId() {
            return this.a.sdkAppId;
        }

        @CalledByNative(value="SpeedTestParams")
        public String getUserId() {
            return this.a.userId;
        }

        @CalledByNative(value="SpeedTestParams")
        public String getUserSig() {
            return this.a.userSig;
        }

        @CalledByNative(value="SpeedTestParams")
        public int getExpectedUpBandwidth() {
            return this.a.expectedUpBandwidth;
        }

        @CalledByNative(value="SpeedTestParams")
        public int getExpectedDownBandwidth() {
            return this.a.expectedDownBandwidth;
        }
    }

    static class LocalRecordingParams {
        private final TRTCCloudDef.TRTCLocalRecordingParams a;

        public LocalRecordingParams(TRTCCloudDef.TRTCLocalRecordingParams params) {
            this.a = params;
        }

        @CalledByNative(value="LocalRecordingParams")
        public String getFilePath() {
            return this.a.filePath;
        }

        @CalledByNative(value="LocalRecordingParams")
        public int getRecordType() {
            return this.a.recordType;
        }

        @CalledByNative(value="LocalRecordingParams")
        public int getInterval() {
            return this.a.interval;
        }
    }

    static class AudioRecordingParams {
        private final TRTCCloudDef.TRTCAudioRecordingParams a;

        public AudioRecordingParams(TRTCCloudDef.TRTCAudioRecordingParams params) {
            this.a = params;
        }

        @CalledByNative(value="AudioRecordingParams")
        public String getFilePath() {
            return this.a.filePath;
        }

        @CalledByNative(value="AudioRecordingParams")
        public int getContent() {
            return this.a.recordingContent;
        }
    }

    static class Statistics {
        private TRTCStatistics a = new TRTCStatistics();

        Statistics() {
        }

        @CalledByNative(value="Statistics")
        public static Statistics createStatistics(int appCpu, int systemCpu, int upLoss, int downLoss, int rtt, int gatewayRtt, long sendBytes, long receiveBytes, ArrayList<LocalStatistics> localArray, ArrayList<RemoteStatistics> remoteArray) {
            Statistics statistics = new Statistics();
            new Statistics().a.appCpu = appCpu;
            statistics.a.systemCpu = systemCpu;
            statistics.a.upLoss = upLoss;
            statistics.a.downLoss = downLoss;
            statistics.a.rtt = rtt;
            statistics.a.gatewayRtt = gatewayRtt;
            statistics.a.sendBytes = sendBytes;
            statistics.a.receiveBytes = receiveBytes;
            statistics.a.localArray = new ArrayList();
            statistics.a.remoteArray = new ArrayList();
            if (localArray != null) {
                for (LocalStatistics object : localArray) {
                    statistics.a.localArray.add(object.a);
                }
            }
            if (remoteArray != null) {
                for (RemoteStatistics remoteStatistics : remoteArray) {
                    statistics.a.remoteArray.add(remoteStatistics.a);
                }
            }
            return statistics;
        }
    }

    static class RemoteStatistics {
        public TRTCStatistics.TRTCRemoteStatistics a = new TRTCStatistics.TRTCRemoteStatistics();

        RemoteStatistics() {
        }

        @CalledByNative(value="RemoteStatistics")
        public static RemoteStatistics createRemoteStatistics(String userId, int streamType, int width, int height, int frameRate, int videoPacketLoss, int videoBitrate, int videoTotalBlockTime, int videoBlockRate, int audioSampleRate, int audioBitrate, int audioPacketLoss, int audioTotalBlockTime, int audioBlockRate, int jitterBufferDelay, int point2PointDelay, int finalLoss) {
            RemoteStatistics remoteStatistics = new RemoteStatistics();
            new RemoteStatistics().a.userId = userId;
            remoteStatistics.a.streamType = streamType;
            remoteStatistics.a.width = width;
            remoteStatistics.a.height = height;
            remoteStatistics.a.frameRate = frameRate;
            remoteStatistics.a.audioPacketLoss = audioPacketLoss;
            remoteStatistics.a.videoPacketLoss = videoPacketLoss;
            remoteStatistics.a.videoBlockRate = videoBlockRate;
            remoteStatistics.a.videoTotalBlockTime = videoTotalBlockTime;
            remoteStatistics.a.videoBitrate = videoBitrate;
            remoteStatistics.a.audioBitrate = audioBitrate;
            remoteStatistics.a.audioSampleRate = audioSampleRate;
            remoteStatistics.a.audioTotalBlockTime = audioTotalBlockTime;
            remoteStatistics.a.audioBlockRate = audioBlockRate;
            remoteStatistics.a.jitterBufferDelay = jitterBufferDelay;
            remoteStatistics.a.point2PointDelay = point2PointDelay;
            remoteStatistics.a.finalLoss = finalLoss;
            return remoteStatistics;
        }

        @CalledByNative(value="RemoteStatistics")
        public static ArrayList<RemoteStatistics> createRemoteStatisticsArray() {
            return new ArrayList<RemoteStatistics>();
        }

        @CalledByNative(value="RemoteStatistics")
        public static void addRemoteStatistics(RemoteStatistics statistics, ArrayList<RemoteStatistics> remoteStatisticsArrayList) {
            remoteStatisticsArrayList.add(statistics);
        }
    }

    static class LocalStatistics {
        private TRTCStatistics.TRTCLocalStatistics a = new TRTCStatistics.TRTCLocalStatistics();

        LocalStatistics() {
        }

        @CalledByNative(value="LocalStatistics")
        public static LocalStatistics createLocalStatistics(int streamType, int width, int height, int frameRate, int videoBitrate, int audioSampleRate, int audioBitrate, int audioCaptureState) {
            LocalStatistics localStatistics = new LocalStatistics();
            new LocalStatistics().a.streamType = streamType;
            localStatistics.a.width = width;
            localStatistics.a.height = height;
            localStatistics.a.frameRate = frameRate;
            localStatistics.a.videoBitrate = videoBitrate;
            localStatistics.a.audioBitrate = audioBitrate;
            localStatistics.a.audioSampleRate = audioSampleRate;
            localStatistics.a.audioCaptureState = audioCaptureState;
            return localStatistics;
        }

        @CalledByNative(value="LocalStatistics")
        public static ArrayList<LocalStatistics> createLocalStatisticsArray() {
            return new ArrayList<LocalStatistics>();
        }

        @CalledByNative(value="LocalStatistics")
        public static void addLocalStatistics(LocalStatistics statistics, ArrayList<LocalStatistics> localStatisticsArrayList) {
            localStatisticsArrayList.add(statistics);
        }
    }

    static class AudioFrame {
        private TRTCCloudDef.TRTCAudioFrame a;

        public AudioFrame(TRTCCloudDef.TRTCAudioFrame frame) {
            this.a = frame;
        }

        @CalledByNative(value="AudioFrame")
        public byte[] getData() {
            return this.a.data;
        }

        @CalledByNative(value="AudioFrame")
        public int getSampleRate() {
            return this.a.sampleRate;
        }

        @CalledByNative(value="AudioFrame")
        public int getChannel() {
            return this.a.channel;
        }

        @CalledByNative(value="AudioFrame")
        public long getTimestamp() {
            return this.a.timestamp;
        }
    }

    static class AudioParallelParams {
        private TRTCCloudDef.TRTCAudioParallelParams a;

        public AudioParallelParams(TRTCCloudDef.TRTCAudioParallelParams params) {
            this.a = params;
        }

        @CalledByNative(value="AudioParallelParams")
        public int getMaxCount() {
            return this.a.maxCount;
        }

        @CalledByNative(value="AudioParallelParams")
        public String[] getIncludeUsers() {
            return this.a.includeUsers.toArray(new String[this.a.includeUsers.size()]);
        }
    }

    static class EnterRoomParams {
        private TRTCCloudDef.TRTCParams a;

        public EnterRoomParams(TRTCCloudDef.TRTCParams params) {
            this.a = params;
        }

        @CalledByNative(value="EnterRoomParams")
        public int getSdkAppId() {
            return this.a.sdkAppId;
        }

        @CalledByNative(value="EnterRoomParams")
        public int getRoomId() {
            return this.a.roomId;
        }

        @CalledByNative(value="EnterRoomParams")
        public String getStrRoomId() {
            return this.a.strRoomId;
        }

        @CalledByNative(value="EnterRoomParams")
        public String getUserId() {
            return this.a.userId;
        }

        @CalledByNative(value="EnterRoomParams")
        public String getUserSig() {
            return this.a.userSig;
        }

        @CalledByNative(value="EnterRoomParams")
        public int getRole() {
            return this.a.role;
        }

        @CalledByNative(value="EnterRoomParams")
        public String getPrivateMapKey() {
            return this.a.privateMapKey;
        }

        @CalledByNative(value="EnterRoomParams")
        public String getStreamId() {
            return this.a.streamId;
        }

        @CalledByNative(value="EnterRoomParams")
        public String getRecordId() {
            return this.a.userDefineRecordId;
        }

        @CalledByNative(value="EnterRoomParams")
        public String getBusinessInfo() {
            return this.a.businessInfo;
        }
    }

    static class ScreenShareParams {
        private final TRTCCloudDef.TRTCScreenShareParams a;

        public ScreenShareParams(TRTCCloudDef.TRTCScreenShareParams params) {
            this.a = params;
        }

        @CalledByNative(value="ScreenShareParams")
        public Object getMediaProjection() {
            return this.a.mediaProjection;
        }
    }

    static class VideoEncParams {
        private TRTCCloudDef.TRTCVideoEncParam a;

        public VideoEncParams(TRTCCloudDef.TRTCVideoEncParam params) {
            this.a = params;
        }

        @CalledByNative(value="VideoEncParams")
        public int getVideoResolution() {
            return this.a.videoResolution;
        }

        @CalledByNative(value="VideoEncParams")
        public int getVideoResolutionMode() {
            return this.a.videoResolutionMode;
        }

        @CalledByNative(value="VideoEncParams")
        public int getVideoFps() {
            return this.a.videoFps;
        }

        @CalledByNative(value="VideoEncParams")
        public int getVideoBitrate() {
            return this.a.videoBitrate;
        }

        @CalledByNative(value="VideoEncParams")
        public int getMinVideoBitrate() {
            return this.a.minVideoBitrate;
        }

        @CalledByNative(value="VideoEncParams")
        public boolean isEnableAdjustRes() {
            return this.a.enableAdjustRes;
        }
    }

    public static class PublishCDNParams {
        private TRTCCloudDef.TRTCPublishCDNParam a;

        public PublishCDNParams(TRTCCloudDef.TRTCPublishCDNParam params) {
            this.a = params;
        }

        @CalledByNative(value="PublishCDNParams")
        public int getAppId() {
            return this.a.appId;
        }

        @CalledByNative(value="PublishCDNParams")
        public int getBizId() {
            return this.a.bizId;
        }

        @CalledByNative(value="PublishCDNParams")
        public String getUrl() {
            if (TextUtils.isEmpty((CharSequence)this.a.url)) {
                return "";
            }
            return this.a.url;
        }

        @CalledByNative(value="PublishCDNParams")
        public String getStreamId() {
            if (TextUtils.isEmpty((CharSequence)this.a.streamId)) {
                return "";
            }
            return this.a.streamId;
        }
    }

    static class MixUser {
        private TRTCCloudDef.TRTCMixUser a;

        private MixUser(TRTCCloudDef.TRTCMixUser user) {
            this.a = user;
        }

        @CalledByNative(value="MixUser")
        public String getUserId() {
            if (TextUtils.isEmpty((CharSequence)this.a.userId)) {
                return "";
            }
            return this.a.userId;
        }

        @CalledByNative(value="MixUser")
        public String getRoomId() {
            if (TextUtils.isEmpty((CharSequence)this.a.roomId)) {
                return "";
            }
            return this.a.roomId;
        }

        @CalledByNative(value="MixUser")
        public int getX() {
            return this.a.x;
        }

        @CalledByNative(value="MixUser")
        public int getY() {
            return this.a.y;
        }

        @CalledByNative(value="MixUser")
        public int getWidth() {
            return this.a.width;
        }

        @CalledByNative(value="MixUser")
        public int getHeight() {
            return this.a.height;
        }

        @CalledByNative(value="MixUser")
        public int getZOrder() {
            return this.a.zOrder;
        }

        @CalledByNative(value="MixUser")
        public int getStreamType() {
            return this.a.streamType;
        }

        @CalledByNative(value="MixUser")
        public boolean getPureAudio() {
            return this.a.pureAudio;
        }

        @CalledByNative(value="MixUser")
        public int getInputType() {
            return this.a.inputType;
        }

        @CalledByNative(value="MixUser")
        public int getRenderMode() {
            return this.a.renderMode;
        }

        @CalledByNative(value="MixUser")
        public int getSoundLevel() {
            return this.a.soundLevel;
        }

        @CalledByNative(value="MixUser")
        public String getImage() {
            if (TextUtils.isEmpty((CharSequence)this.a.image)) {
                return "";
            }
            return this.a.image;
        }

        /* synthetic */ MixUser(TRTCCloudDef.TRTCMixUser x0, byte by2) {
            this(x0);
        }
    }

    static class TranscodingConfig {
        private TRTCCloudDef.TRTCTranscodingConfig a;

        public TranscodingConfig(TRTCCloudDef.TRTCTranscodingConfig config) {
            this.a = config;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getMode() {
            return this.a.mode;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getAppId() {
            return this.a.appId;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getBizId() {
            return this.a.bizId;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getVideoWidth() {
            return this.a.videoWidth;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getVideoHeight() {
            return this.a.videoHeight;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getVideoBitrate() {
            return this.a.videoBitrate;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getVideoFramerate() {
            return this.a.videoFramerate;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getVideoGOP() {
            return this.a.videoGOP;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getBackgroundColor() {
            return this.a.backgroundColor;
        }

        @CalledByNative(value="TranscodingConfig")
        public String getBackgroundImage() {
            if (TextUtils.isEmpty((CharSequence)this.a.backgroundImage)) {
                return "";
            }
            return this.a.backgroundImage;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getAudioSampleRate() {
            return this.a.audioSampleRate;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getAudioBitrate() {
            return this.a.audioBitrate;
        }

        @CalledByNative(value="TranscodingConfig")
        public int getAudioChannels() {
            return this.a.audioChannels;
        }

        @CalledByNative(value="TranscodingConfig")
        public MixUser[] getMixUsers() {
            if (this.a.mixUsers == null) {
                return null;
            }
            MixUser[] mixUserArray = new MixUser[this.a.mixUsers.size()];
            for (int i2 = 0; i2 < this.a.mixUsers.size(); ++i2) {
                mixUserArray[i2] = new MixUser(this.a.mixUsers.get(i2), 0);
            }
            return mixUserArray;
        }

        @CalledByNative(value="TranscodingConfig")
        public String getStreamId() {
            if (TextUtils.isEmpty((CharSequence)this.a.streamId)) {
                return "";
            }
            return this.a.streamId;
        }
    }
}

