/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.util;

public final class Base64 {
    private static final byte[] DECODE_MAP;
    private static final char[] ENCODE_MAP;

    public static byte[] decode(String base64String) {
        byte[] buffer = new byte[Base64.decodeLength(base64String)];
        Base64.decode(base64String, buffer, 0);
        return buffer;
    }

    public static int decode(String base64String, byte[] buffer, int offset) {
        int p = 0;
        byte[] base64Chars = base64String.getBytes();
        for (int i = 0; i < base64Chars.length; ++i) {
            if (i % 4 == 0) {
                buffer[offset + i - p] = (byte)(DECODE_MAP[base64Chars[i]] << 2);
                continue;
            }
            if (i % 4 == 1 && offset + i - p - 1 < buffer.length) {
                int n = offset + i - p - 1;
                buffer[n] = (byte)(buffer[n] | DECODE_MAP[base64Chars[i]] >> 4);
                if (offset + i - p >= buffer.length) continue;
                buffer[offset + i - p] = (byte)(DECODE_MAP[base64Chars[i]] << 4);
                continue;
            }
            if (i % 4 == 2 && offset + i - p - 1 < buffer.length) {
                int n = offset + i - p - 1;
                buffer[n] = (byte)(buffer[n] | DECODE_MAP[base64Chars[i]] >>> 2);
                if (offset + i - p >= buffer.length) continue;
                buffer[offset + i - p] = (byte)(DECODE_MAP[base64Chars[i]] << 6);
                continue;
            }
            if (i % 4 != 3 || offset + i - p - 1 >= buffer.length) continue;
            int n = offset + i - p - 1;
            buffer[n] = (byte)(buffer[n] | DECODE_MAP[base64Chars[i]]);
            ++p;
        }
        return Base64.decodeLength(base64String);
    }

    public static int decodeLength(String base64String) {
        int originalLength = base64String.length();
        if (originalLength == 0) {
            return 0;
        }
        if (base64String.charAt(originalLength - 2) == '=') {
            return (originalLength - 2) * 3 / 4;
        }
        if (base64String.charAt(originalLength - 1) == '=') {
            return (originalLength - 1) * 3 / 4;
        }
        return originalLength * 3 / 4;
    }

    public static String encode(byte[] bytes) {
        return Base64.encode(bytes, 0, bytes.length);
    }

    public static String encode(byte[] bytes, int offset, int length) {
        StringBuilder buffer = new StringBuilder(length * 3);
        for (int i = offset; i < offset + length; i += 3) {
            int p5;
            int p4;
            int p3;
            int p2;
            int p0 = bytes[i] & 0xFC;
            p0 >>= 2;
            int p1 = bytes[i] & 3;
            p1 <<= 4;
            if (i + 1 < offset + length) {
                p2 = bytes[i + 1] & 0xF0;
                p2 >>= 4;
                p3 = bytes[i + 1] & 0xF;
                p3 <<= 2;
            } else {
                p2 = 0;
                p3 = 0;
            }
            if (i + 2 < offset + length) {
                p4 = bytes[i + 2] & 0xC0;
                p4 >>= 6;
                p5 = bytes[i + 2] & 0x3F;
            } else {
                p4 = 0;
                p5 = 0;
            }
            if (i + 2 < offset + length) {
                buffer.append(ENCODE_MAP[p0]);
                buffer.append(ENCODE_MAP[p1 | p2]);
                buffer.append(ENCODE_MAP[p3 | p4]);
                buffer.append(ENCODE_MAP[p5]);
                continue;
            }
            if (i + 1 < offset + length) {
                buffer.append(ENCODE_MAP[p0]);
                buffer.append(ENCODE_MAP[p1 | p2]);
                buffer.append(ENCODE_MAP[p3]);
                buffer.append('=');
                continue;
            }
            buffer.append(ENCODE_MAP[p0]);
            buffer.append(ENCODE_MAP[p1 | p2]);
            buffer.append('=');
            buffer.append('=');
        }
        return buffer.toString();
    }

    private Base64() {
    }

    static {
        ENCODE_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
        DECODE_MAP = new byte[128];
        for (int b = 0; b < 64; b = (int)((byte)(b + 1))) {
            Base64.DECODE_MAP[Base64.ENCODE_MAP[b]] = b;
        }
        Base64.DECODE_MAP[43] = 62;
        Base64.DECODE_MAP[47] = 63;
    }
}

