/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.symbol;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.jinmingyunle.midiplaylib.R;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;

public class TimeSigSymbol
implements MusicSymbol {
    private static Bitmap[] images;
    private int numerator;
    private int denominator;
    private int width;
    private boolean candraw;

    public TimeSigSymbol(int numer, int denom) {
        this.numerator = numer;
        this.denominator = denom;
        this.candraw = numer >= 0 && numer < images.length && images[numer] != null && denom >= 0 && denom < images.length && images[numer] != null;
        this.width = this.getMinWidth();
    }

    public static void LoadImages(Context context) {
        if (images != null) {
            return;
        }
        images = new Bitmap[13];
        Resources res = context.getResources();
        TimeSigSymbol.images[2] = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.two);
        TimeSigSymbol.images[3] = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.three);
        TimeSigSymbol.images[4] = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.four);
        TimeSigSymbol.images[6] = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.six);
        TimeSigSymbol.images[8] = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.eight);
        TimeSigSymbol.images[9] = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.nine);
        TimeSigSymbol.images[12] = BitmapFactory.decodeResource((Resources)res, (int)R.mipmap.twelve);
    }

    @Override
    public int getStartTime() {
        return -1;
    }

    @Override
    public int getMinWidth() {
        if (this.candraw) {
            return images[2].getWidth() * 9 * 2 / images[2].getHeight();
        }
        return 0;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int value) {
        this.width = value;
    }

    @Override
    public int getAboveStaff() {
        return 0;
    }

    @Override
    public int getBelowStaff() {
        return 0;
    }

    @Override
    public void Draw(Canvas canvas, Paint paint, int ytop) {
        if (!this.candraw) {
            return;
        }
        canvas.translate((float)(this.getWidth() - this.getMinWidth()), 0.0f);
        Bitmap numer = images[this.numerator];
        Bitmap denom = images[this.denominator];
        int imgheight = 18;
        int imgwidth = numer.getWidth() * imgheight / numer.getHeight();
        Rect src = new Rect(0, 0, numer.getWidth(), numer.getHeight());
        Rect dest = new Rect(0, ytop, imgwidth, ytop + imgheight);
        canvas.drawBitmap(numer, src, dest, paint);
        src = new Rect(0, 0, denom.getWidth(), denom.getHeight());
        dest = new Rect(0, ytop + 18, imgwidth, ytop + 18 + imgheight);
        canvas.drawBitmap(denom, src, dest, paint);
        canvas.translate((float)(-(this.getWidth() - this.getMinWidth())), 0.0f);
    }

    public String toString() {
        return String.format("TimeSigSymbol numerator=%1$s denominator=%2$s", this.numerator, this.denominator);
    }
}

