/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.AudioDualMonoMode;
import cn.rongcloud.rtc.api.RCRTCAudioMixer;
import cn.rongcloud.rtc.api.callback.RCRTCAudioMixingStateChangeListener;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.audio.AudioMixer;
import cn.rongcloud.rtc.core.audio.AudioWriteHelper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.plugin.PluginUtils;
import cn.rongcloud.rtc.plugin.player.INetPlayer;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NetAudioMixer
extends RCRTCAudioMixer
implements INetPlayer.INetPlayerListener {
    private static final int MAX_VOL = 100;
    private static final int MIN_VOL = 0;
    private AudioMixer mAudioMixer;
    private RCRTCAudioMixer.Mode mMode;
    private boolean mPlayback = false;
    private int mVolume = 100;
    private int mMixVolume = 100;
    INetPlayer mPlayer;
    private AudioWriteHelper audioWriteHelper;
    int poolSize = 1;
    private BlockingQueue<Runnable> mQueue = new LinkedBlockingQueue<Runnable>();
    ExecutorService mPlayerThreadExecutor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, this.mQueue);
    private BlockingQueue<Runnable> mQueueForWrite = new LinkedBlockingQueue<Runnable>();
    ExecutorService mWritePcmThreadExecutor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, this.mQueueForWrite);
    private boolean isNetFlag = false;
    private boolean isStopFlag = false;
    static final int reportTime = 600;
    long curtime = 0L;

    public NetAudioMixer(AudioMixer audioMixer) {
        this.mAudioMixer = audioMixer;
        this.mPlayer = (INetPlayer)PluginUtils.loadPlayerPluginByName("cn.rongcloud.rtc.media.player.api.ImplNetPlayer");
        this.mPlayer.setListener(this);
    }

    @Override
    public boolean startMix(final String path, final RCRTCAudioMixer.Mode mode, final boolean playback, final int loopCount) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            ReportUtil.libError(ReportUtil.TAG.NETSTARTMIX, RTCErrorCode.RongRTCCodeParameterError, "desc", "- startMix() path is empty !");
            return false;
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (NetAudioMixer.this.mAudioMixer.startMix(path, mode, playback, loopCount)) {
                    NetAudioMixer.this.isNetFlag = false;
                    return true;
                }
                if (!RTCEngineImpl.getInstance().isNetProtocol(path)) {
                    ReportUtil.libError(ReportUtil.TAG.NETSTARTMIX, RTCErrorCode.RongRTCCodeParameterError, "desc", "- startMix() path is not net protocol !");
                    return false;
                }
                NetAudioMixer.this.audioWriteHelper = new AudioWriteHelper(false);
                NetAudioMixer.this.mQueue.clear();
                NetAudioMixer.this.mQueueForWrite.clear();
                ReportUtil.appTask(ReportUtil.TAG.NETSTARTMIX, "path|mode|playback|loopCount|mixingVolume|playbackVolume", new Object[]{path, mode, playback, loopCount, NetAudioMixer.this.mMixVolume, NetAudioMixer.this.mVolume});
                NetAudioMixer.this.isNetFlag = true;
                NetAudioMixer.this.isStopFlag = false;
                NetAudioMixer.this.mMode = mode;
                NetAudioMixer.this.mPlayback = playback;
                INetPlayer.Builder builder = new INetPlayer.Builder();
                int tmpVolume = 0;
                tmpVolume = !NetAudioMixer.this.mPlayback ? 0 : NetAudioMixer.this.mVolume;
                builder.setUrl(path).setPlayCount(loopCount).setVolume((float)tmpVolume / 100.0f);
                NetAudioMixer.this.mPlayer.play(builder, true);
                ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PREPAREING, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER});
                NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.PREPAREING, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER);
                ReportUtil.appRes(ReportUtil.TAG.NETSTARTMIX, "path", path);
                return true;
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            return futureTask.get();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return false;
    }

    @Override
    public boolean start() {
        return this.mAudioMixer.start();
    }

    @Override
    public boolean startWrite() {
        return this.mAudioMixer.startWrite();
    }

    @Override
    public void stopWrite() {
        this.mAudioMixer.stopWrite();
    }

    @Override
    public void write(byte[] data, int sampleRate, int channelCount, int audioFormat, int volume, RCRTCAudioMixer.Mode mode) {
        this.mAudioMixer.write(data, sampleRate, channelCount, audioFormat, volume, mode);
    }

    @Override
    public void setAudioMixingStateChangeListener(final RCRTCAudioMixingStateChangeListener listener) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NetAudioMixer.this.mAudioMixer.setAudioMixingStateChangeListener(listener);
            }
        });
    }

    @Override
    public void setPlayback(final boolean playback) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NetAudioMixer.this.mPlayback = playback;
                if (!NetAudioMixer.this.mPlayback) {
                    NetAudioMixer.this.mPlayer.setVolume(0);
                }
                NetAudioMixer.this.mAudioMixer.setPlayback(playback);
            }
        });
    }

    @Override
    public void setMixingVolume(final int vol) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NetAudioMixer.this.mMixVolume = vol;
                NetAudioMixer.this.mAudioMixer.setMixingVolume(vol);
            }
        });
    }

    @Override
    public int getMixingVolume() {
        FutureTask<Integer> futureTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return NetAudioMixer.this.mAudioMixer.getMixingVolume();
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            return futureTask.get();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return -1;
    }

    @Override
    public void setPlaybackVolume(final int vol) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NetAudioMixer.this.mVolume = vol;
                NetAudioMixer.this.mPlayer.setVolume(NetAudioMixer.this.mVolume);
                NetAudioMixer.this.mAudioMixer.setPlaybackVolume(vol);
            }
        });
    }

    @Override
    public int getPlaybackVolume() {
        FutureTask<Integer> futureTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return NetAudioMixer.this.mAudioMixer.getPlaybackVolume();
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            return futureTask.get();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return -1;
    }

    @Override
    public int getDurationMillis() {
        FutureTask<Integer> futureTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (NetAudioMixer.this.isNetFlag) {
                    int duration = (int)NetAudioMixer.this.mPlayer.getDuration();
                    return duration;
                }
                return NetAudioMixer.this.mAudioMixer.getDurationMillis();
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            int duration = futureTask.get();
            return duration;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return -1;
    }

    @Override
    public int getDurationMillis(final String path) {
        FutureTask<Integer> futureTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return NetAudioMixer.this.mAudioMixer.getDurationMillis(path);
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            return futureTask.get();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return -1;
    }

    @Override
    public float getCurrentPosition() {
        FutureTask<Float> futureTask = new FutureTask<Float>(new Callable<Float>(){

            @Override
            public Float call() throws Exception {
                if (NetAudioMixer.this.isNetFlag) {
                    if (0L == NetAudioMixer.this.mPlayer.getDuration()) {
                        return Float.valueOf(0.0f);
                    }
                    return Float.valueOf((float)NetAudioMixer.this.mPlayer.getCurrentPosition() / (float)NetAudioMixer.this.mPlayer.getDuration());
                }
                return Float.valueOf(NetAudioMixer.this.mAudioMixer.getCurrentPosition());
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            return futureTask.get().floatValue();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return -1.0f;
    }

    @Override
    public void seekTo(final float position) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (NetAudioMixer.this.isNetFlag) {
                    NetAudioMixer.this.mPlayer.seek((long)((float)NetAudioMixer.this.mPlayer.getDuration() * position));
                } else {
                    NetAudioMixer.this.mAudioMixer.seekTo(position);
                }
            }
        });
    }

    @Override
    public void stop() {
        this.mQueue.clear();
        this.mQueueForWrite.clear();
        FutureTask futureTask = new FutureTask(new Callable(){

            public Object call() throws Exception {
                if (NetAudioMixer.this.isNetFlag) {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.STOPPED_BY_USER});
                    NetAudioMixer.this.mPlayer.stopSync();
                    NetAudioMixer.this.mQueueForWrite.clear();
                    NetAudioMixer.this.isStopFlag = true;
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.STOPPED_BY_USER);
                    NetAudioMixer.this.audioWriteHelper.release();
                    NetAudioMixer.this.audioWriteHelper = null;
                } else {
                    NetAudioMixer.this.mAudioMixer.stop();
                }
                return null;
            }
        });
        this.mPlayerThreadExecutor.submit(futureTask);
        try {
            futureTask.get();
            return;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void resume() {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (NetAudioMixer.this.isNetFlag) {
                    NetAudioMixer.this.mPlayer.resume();
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.RESUMED_BY_USER});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.RESUMED_BY_USER);
                } else {
                    NetAudioMixer.this.mAudioMixer.resume();
                }
            }
        });
    }

    @Override
    public void pause() {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (NetAudioMixer.this.isNetFlag) {
                    NetAudioMixer.this.mPlayer.pause();
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PAUSED, RCRTCAudioMixer.MixingStateReason.PAUSED_BY_USER});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.PAUSED, RCRTCAudioMixer.MixingStateReason.PAUSED_BY_USER);
                } else {
                    NetAudioMixer.this.mAudioMixer.pause();
                }
            }
        });
    }

    @Override
    public void setVolume(final int volume) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NetAudioMixer.this.mVolume = volume;
                NetAudioMixer.this.mMixVolume = volume;
                NetAudioMixer.this.mPlayer.setVolume(volume);
                NetAudioMixer.this.mAudioMixer.setVolume(volume);
            }
        });
    }

    @Override
    public void setPitch(final int pitch) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int tempPath = pitch;
                if (NetAudioMixer.this.audioWriteHelper != null && NetAudioMixer.this.isNetFlag) {
                    ReportUtil.appError(ReportUtil.TAG.SOUND_EFFECT_PITCH, "not spport for net file", "");
                    return;
                }
                if (NetAudioMixer.this.mAudioMixer != null) {
                    NetAudioMixer.this.mAudioMixer.setPitch(tempPath);
                }
            }
        });
    }

    @Override
    public void setPlaybackSpeed(final int speed) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (NetAudioMixer.this.audioWriteHelper != null && NetAudioMixer.this.isNetFlag) {
                    ReportUtil.appError(ReportUtil.TAG.SOUND_EFFECT_TEMPO, "not spport for net file", "");
                    return;
                }
                if (NetAudioMixer.this.mAudioMixer != null) {
                    NetAudioMixer.this.mAudioMixer.setPlaybackSpeed(speed);
                }
            }
        });
    }

    @Override
    public void setAudioDualMonoMode(AudioDualMonoMode mode) {
        if (this.mAudioMixer != null) {
            this.mAudioMixer.setAudioDualMonoMode(mode);
        }
    }

    @Override
    public void onPrepared(INetPlayer.MediaInfo mediaInfo) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER});
                NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER);
            }
        });
    }

    @Override
    public void onPrepared() {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER});
                NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER);
            }
        });
    }

    @Override
    public void onError(final int error) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (-1004 == error) {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_IO});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_IO);
                } else if (-110 == error) {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_TIMED_OUT});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_TIMED_OUT);
                } else if (-1010 == error) {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_UNSUPPORTED});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_UNSUPPORTED);
                } else if (-999 == error) {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_BYUSER});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_BYUSER);
                } else if (-10000 == error) {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_INFO_VIDEO_INTERRUPT});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_INFO_VIDEO_INTERRUPT);
                } else {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_UNKNOWN});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.ERROR, RCRTCAudioMixer.MixingStateReason.MEDIA_ERROR_UNKNOWN);
                }
            }
        });
    }

    @Override
    public void onCompletion(final int count) {
        this.mPlayerThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (0 == count) {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ALL_LOOPS_COMPLETED});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ALL_LOOPS_COMPLETED);
                } else {
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ONE_LOOP_COMPLETED});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ONE_LOOP_COMPLETED);
                    ReportUtil.libStatus(ReportUtil.TAG.NETMIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.START_NEW_LOOP});
                    NetAudioMixer.this.mAudioMixer.StateChange(RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.START_NEW_LOOP);
                }
            }
        });
    }

    @Override
    public void onPcm(byte[] audioData, int offsetInBytes, int sizeInBytes, final int sampleRate, final int channelCount, final int audioFormat) {
        final byte[] newBuf = new byte[sizeInBytes];
        System.arraycopy(audioData, offsetInBytes, newBuf, 0, sizeInBytes);
        this.mWritePcmThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (NetAudioMixer.this.isStopFlag) {
                    return;
                }
                AudioWriteHelper helper = NetAudioMixer.this.audioWriteHelper;
                if (null != helper) {
                    NetAudioMixer.this.audioWriteHelper.write(newBuf, sampleRate, channelCount, audioFormat, NetAudioMixer.this.mMixVolume, NetAudioMixer.this.mMode);
                }
            }
        });
        if (600L < System.currentTimeMillis() - this.curtime) {
            this.mPlayerThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (NetAudioMixer.this.isStopFlag) {
                        return;
                    }
                    float progress = 0.0f;
                    ReportUtil.libTask(ReportUtil.TAG.NETPLAYREPORTPROGRESS, "task", "start report");
                    long duration = NetAudioMixer.this.mPlayer.getDuration();
                    progress = 0L == duration ? 0.0f : (float)NetAudioMixer.this.mPlayer.getCurrentPosition() / (float)duration;
                    ReportUtil.libTask(ReportUtil.TAG.NETPLAYREPORTPROGRESS, "task|progress", "report over", Float.valueOf(progress));
                    NetAudioMixer.this.mAudioMixer.reportPlayingProgress(progress);
                }
            });
            this.curtime = System.currentTimeMillis();
        }
    }
}

