/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request.adp;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.services.request.Ks3HttpRequest;
import com.ksyun.ks3.services.request.adp.Adp;
import com.ksyun.ks3.util.HttpUtils;
import com.ksyun.ks3.util.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class PutAdpRequest
extends Ks3HttpRequest {
    private List<Adp> adps = new ArrayList<Adp>();
    private String notifyURL;

    public PutAdpRequest(String bucketName, String key) {
        this.setBucketname(bucketName);
        this.setObjectkey(key);
    }

    public PutAdpRequest(String bucketName, String key, List<Adp> adps) {
        this(bucketName, key);
        this.setAdps(adps);
    }

    @Override
    protected void setupRequest() throws Ks3ClientException {
        this.setHttpMethod(HttpMethod.PUT);
        this.addParams("adp", "");
        this.addHeader(HttpHeaders.AsynchronousProcessingList, URLEncoder.encode(HttpUtils.convertAdps2String(this.adps)));
        if (!StringUtils.isBlank(this.notifyURL)) {
            this.addHeader(HttpHeaders.NotifyURL, HttpUtils.urlEncode(this.notifyURL, false));
        }
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.getBucketname())) {
            throw new Ks3ClientException("bucketname");
        }
        if (StringUtils.isBlank(this.getObjectkey())) {
            throw new Ks3ClientException("objectkey");
        }
        if (this.adps == null) {
            throw new Ks3ClientException("adps");
        }
        for (Adp adp : this.adps) {
            if (!StringUtils.isBlank(adp.getCommand())) continue;
            throw new Ks3ClientException("adps.command");
        }
        if (StringUtils.isBlank(this.notifyURL)) {
            throw new Ks3ClientException("notifyURL");
        }
    }

    public List<Adp> getAdps() {
        return this.adps;
    }

    public void setAdps(List<Adp> adps) {
        this.adps = adps;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }
}

