/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUSpiritOutFilter;

public class TXCGPUPhontomFilter
extends TXCGPUSpiritOutFilter {
    private static final int DURATION_PHANTOM_LVMIN = 120;
    private static final int DURATION_PHANTOM_LV1 = 240;
    private static final int DURATION_PHANTOM_LV2 = 360;
    private static final int DURATION_PHANTOM_LV3 = 480;
    private static final int DURATION_PHANTOM_LV4 = 600;
    private static final int DURATION_PHANTOM_LV5 = 720;
    private static final int DURATION_PHANTOM_LV6 = 840;
    private static final int DURATION_PHANTOM_LV7 = 960;
    private static final int DURATION_PHANTOM_LV8 = 1080;
    private static final int DURATION_PHANTOM_LV9 = 1200;
    private static final int DURATION_PHANTOM_LV10 = 1320;
    private static final int DURATION_PHANTOM_LV11 = 1440;
    private static final int DURATION_PHANTOM_LV12 = 1560;
    private static final int DURATION_PHANTOM_LV13 = 1680;
    private static final int DURATION_PHANTOM_LV14 = 1800;
    private PhantomParam mPhantomParam;

    @Override
    public void setNextFrameTimestamp(long pts) {
        super.setNextFrameTimestamp(pts);
        if (this.mPhantomParam == null) {
            this.mPhantomParam = new PhantomParam();
            this.mPhantomParam.fringeNumber = 1;
            this.mPhantomParam.alpahLevel = 0.3f;
        }
        this.mPhantomParam.offetRed = new float[]{0.0f, 0.0f};
        this.mPhantomParam.offsetGreen = new float[]{0.0f, 0.1f};
        long l2 = Math.abs(pts - this.mEffectStartTime);
        if (l2 < 120L) {
            this.mPhantomParam.zoomOutLevel = 0;
            this.mPhantomParam.offetRed = new float[]{0.0f, 0.0f};
            this.mPhantomParam.offsetGreen = new float[]{0.0f, 0.0f};
        } else if (l2 < 120L) {
            this.mPhantomParam.zoomOutLevel = 1;
        } else if (l2 < 240L) {
            this.mPhantomParam.zoomOutLevel = 2;
        } else if (l2 < 360L) {
            this.mPhantomParam.zoomOutLevel = 3;
        } else if (l2 < 480L) {
            this.mPhantomParam.zoomOutLevel = 4;
        } else if (l2 < 600L) {
            this.mPhantomParam.zoomOutLevel = 5;
        } else if (l2 < 720L) {
            this.mPhantomParam.zoomOutLevel = 6;
        } else if (l2 < 840L) {
            this.mPhantomParam.zoomOutLevel = 7;
        } else if (l2 < 960L) {
            this.mPhantomParam.zoomOutLevel = 8;
        } else if (l2 < 1080L) {
            this.mPhantomParam.zoomOutLevel = 9;
        } else if (l2 < 1200L) {
            this.mPhantomParam.zoomOutLevel = 10;
        } else if (l2 < 1320L) {
            this.mPhantomParam.zoomOutLevel = 11;
        } else if (l2 < 1440L) {
            this.mPhantomParam.zoomOutLevel = 12;
        } else if (l2 < 1560L) {
            this.mPhantomParam.zoomOutLevel = 13;
        } else if (l2 < 1680L) {
            this.mPhantomParam.zoomOutLevel = 14;
        } else if (l2 < 1800L) {
            this.mPhantomParam.zoomOutLevel = 15;
        } else {
            this.mEffectStartTime = -1L;
        }
        if (this.mPhantomParam != null && this.mZoomInOutFilter != null) {
            this.mZoomInOutFilter.setColorOffset(this.mPhantomParam.offetRed, this.mPhantomParam.offsetGreen, this.mPhantomParam.offsetBlue);
        }
    }

    public static class PhantomParam
    extends TXCGPUSpiritOutFilter.SpiritOutEffectParam {
        public float[] offetRed = new float[]{0.0f, 0.0f};
        public float[] offsetGreen = new float[]{0.0f, 0.1f};
        public float[] offsetBlue = new float[]{0.0f, 0.0f};
    }
}

