/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ksyun.ks3.auth.AuthEvent;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.model.acl.Authorization;
import com.ksyun.ks3.services.AsyncHttpClientFactory;
import com.ksyun.ks3.services.AuthListener;
import com.ksyun.ks3.services.Ks3AuthHandler;
import com.ksyun.ks3.services.Ks3ClientConfiguration;
import com.ksyun.ks3.services.SyncHttpClientFactory;
import com.ksyun.ks3.services.request.Ks3HttpRequest;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestHandle;
import com.loopj.android.http.ResponseHandlerInterface;
import cz.msebera.android.httpclient.Header;

public class Ks3HttpExector {
    private AsyncHttpClient client;

    public void invoke(Authorization auth, final Ks3HttpRequest request, final AsyncHttpResponseHandler resultHandler, Ks3ClientConfiguration clientConfiguration, final Context context, String endpoint, AuthListener authListener, Boolean isUseAsyncMode) {
        if (TextUtils.isEmpty((CharSequence)endpoint)) {
            Log.e((String)"ks3_android_sdk", (String)"The endpoint is empty,do you call setEndpoint() after you create Ks3Client?");
            return;
        }
        if (clientConfiguration != null && clientConfiguration.getProtocol() == Ks3ClientConfiguration.PROTOCOL.https && clientConfiguration.getSSLSocketFactory() == null) {
            Log.e((String)"ks3_android_sdk", (String)"Because of current request is https, please set crt file, or check your log wheather has error.");
            return;
        }
        this.client = clientConfiguration != null ? (isUseAsyncMode.booleanValue() ? AsyncHttpClientFactory.getInstance(clientConfiguration) : SyncHttpClientFactory.getInstance(clientConfiguration)) : (isUseAsyncMode != false ? AsyncHttpClientFactory.getInstance() : SyncHttpClientFactory.getInstance());
        request.setAuthorization(auth);
        if (request.getBucketname() == null || clientConfiguration.isPathStyleAccess()) {
            request.setEndpoint(endpoint);
        } else {
            request.setEndpoint(request.getBucketname() + "." + endpoint);
        }
        if (isUseAsyncMode.booleanValue()) {
            if (authListener != null) {
                request.setAuthListener(authListener);
                this.setUpRequsetInBackground(request, new Ks3AuthHandler(){

                    @Override
                    public void onSuccess(AuthEvent event) {
                        Ks3HttpExector.this.doRequset(request, context, resultHandler);
                    }

                    @Override
                    public void onFailure(AuthEvent event) {
                        resultHandler.onFailure(0, null, null, new Ks3ClientException(event.getContent()));
                    }
                }, resultHandler);
            } else {
                try {
                    request.completeRequset(null, resultHandler);
                }
                catch (Ks3ClientException e) {
                    resultHandler.onFailure(0, null, null, e);
                    return;
                }
                this.doRequset(request, context, resultHandler);
            }
        } else {
            if (authListener != null) {
                request.setAuthListener(authListener);
                Ks3AuthHandler ks3AuthHandler = new Ks3AuthHandler(){

                    @Override
                    public void onSuccess(AuthEvent event) {
                        Ks3HttpExector.this.doRequset(request, context, resultHandler);
                    }

                    @Override
                    public void onFailure(AuthEvent event) {
                        resultHandler.onFailure(0, null, null, new Ks3ClientException(event.getContent()));
                    }
                };
                try {
                    request.completeRequset(ks3AuthHandler, resultHandler);
                }
                catch (Ks3ClientException e) {
                    ks3AuthHandler.isNeedCalculateAuth = false;
                    resultHandler.onFailure(0, null, null, e);
                    return;
                }
            }
            try {
                request.completeRequset(null, resultHandler);
            }
            catch (Ks3ClientException e) {
                resultHandler.onFailure(0, null, null, e);
                return;
            }
            this.doRequset(request, context, resultHandler);
        }
    }

    protected void doRequset(Ks3HttpRequest request, Context context, AsyncHttpResponseHandler resultHandler) {
        this.LogShow(request);
        RequestHandle handler = null;
        Log.d((String)"ks3_android_sdk", (String)("requset url = " + request.getUrl()));
        switch (request.getHttpMethod()) {
            case GET: {
                handler = this.client.get(context, request.getAsyncHttpRequestParam().getUrl(), request.getAsyncHttpRequestParam().getHeader(), null, (ResponseHandlerInterface)resultHandler);
                break;
            }
            case POST: {
                handler = this.client.post(context, request.getAsyncHttpRequestParam().getUrl(), request.getAsyncHttpRequestParam().getHeader(), request.getEntity(), request.getContentType(), (ResponseHandlerInterface)resultHandler);
                break;
            }
            case PUT: {
                handler = this.client.put(context, request.getAsyncHttpRequestParam().getUrl(), request.getAsyncHttpRequestParam().getHeader(), request.getEntity(), request.getContentType(), resultHandler);
                break;
            }
            case DELETE: {
                handler = this.client.delete(context, request.getAsyncHttpRequestParam().getUrl(), request.getAsyncHttpRequestParam().getHeader(), resultHandler);
                break;
            }
            case HEAD: {
                handler = this.client.head(context, request.getAsyncHttpRequestParam().getUrl(), request.getAsyncHttpRequestParam().getHeader(), null, resultHandler);
                break;
            }
            default: {
                Log.e((String)"ks3_android_sdk", (String)"unsupport http method ! ");
            }
        }
        request.setRequestHandler(handler);
    }

    private void setUpRequsetInBackground(final Ks3HttpRequest request, final Ks3AuthHandler ks3AuthHandler, final AsyncHttpResponseHandler resultHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    request.completeRequset(ks3AuthHandler, resultHandler);
                }
                catch (Ks3ClientException e) {
                    ks3AuthHandler.isNeedCalculateAuth = false;
                    resultHandler.onFailure(0, null, null, e);
                }
            }
        }).start();
    }

    private void LogShow(Ks3HttpRequest request) {
        String url = request.getAsyncHttpRequestParam().getUrl();
        Header[] headers = request.getAsyncHttpRequestParam().getHeader();
        HttpMethod httpMethod = request.getHttpMethod();
        StringBuffer sb = new StringBuffer();
        sb.append("**url** " + url).append("\n");
        sb.append("**method** " + httpMethod.toString() + "\n");
        sb.append("**heads** ").append("\n");
        for (int i = 0; i < headers.length; ++i) {
            sb.append(headers[i].getName()).append("=>").append(headers[i].getValue()).append("\n");
        }
        Log.e((String)"ks3_android_sdk", (String)sb.toString());
    }

    public void cancel(Context context) {
        this.client.cancelRequests(context, true);
    }

    public void pause(Context context) {
        this.client.cancelRequests(context, true);
    }
}

