/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.preprocessor;

import android.content.Context;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.beauty.b.l;
import com.tencent.liteav.videobase.a.h;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videoproducer.preprocessor.b;
import com.tencent.liteav.videoproducer.preprocessor.c;
import com.tencent.liteav.videoproducer.preprocessor.d;
import com.tencent.liteav.videoproducer.preprocessor.e;
import com.tencent.liteav.videoproducer.preprocessor.f;
import com.tencent.liteav.videoproducer.preprocessor.g;
import java.util.HashMap;
import java.util.Map;

@JNINamespace(value="liteav::video")
public class BeautyProcessor
extends h {
    private static final String TAG = "TXCBeautyManager";
    @NonNull
    private final IVideoReporter mReporter;
    private final boolean mIsEnterPriseProEnabled;
    private final l mMotionFilter;
    private final SparseArray<com.tencent.liteav.videobase.a.b> mBeautyFilters;
    private com.tencent.liteav.videobase.a.b mCurrentBeautyFilter = null;
    private int mBeautyStyle = -1;
    private float mBeautyLevel = 0.0f;
    private float mWhitenessLevel = 0.0f;
    private float mRuddyLevel = 0.0f;
    private float mSharpnessLevel = 0.4f;
    private boolean mIsPerformanceMode = true;
    private float mUserSetSharpnessLevel = 0.0f;
    private final Map<String, String> mBeautyStats = new HashMap<String, String>();
    private a mBeautyManagerStatusListener;

    public BeautyProcessor(@NonNull Context context, boolean isEnterPriseProEnabled, @NonNull IVideoReporter videoReporter) {
        this.mReporter = videoReporter;
        this.mIsEnterPriseProEnabled = isEnterPriseProEnabled;
        this.mBeautyFilters = new SparseArray();
        this.mMotionFilter = new l(){

            @Override
            public final boolean canBeSkipped() {
                return true;
            }
        };
    }

    @Override
    public void onInit(com.tencent.liteav.videobase.frame.e texturePool) {
        super.onInit(texturePool);
        this.mMotionFilter.initialize(texturePool);
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle == -1 ? 0 : this.mBeautyStyle, this.mBeautyLevel, this.mWhitenessLevel, this.mRuddyLevel, this.mSharpnessLevel);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.mMotionFilter.onOutputSizeChanged(width, height);
        float f2 = this.getSharpnessLevel();
        for (int i2 = 0; i2 < this.mBeautyFilters.size(); ++i2) {
            com.tencent.liteav.videobase.a.b b2 = (com.tencent.liteav.videobase.a.b)this.mBeautyFilters.valueAt(i2);
            b2.onOutputSizeChanged(width, height);
            if (!(b2 instanceof com.tencent.liteav.beauty.b.b)) continue;
            ((com.tencent.liteav.beauty.b.b)((Object)b2)).d(f2);
        }
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle == -1 ? 0 : this.mBeautyStyle, this.mBeautyLevel, this.mWhitenessLevel, this.mRuddyLevel, f2);
    }

    @Override
    public void onUninit() {
        super.onUninit();
        this.mMotionFilter.uninitialize();
        for (int i2 = 0; i2 < this.mBeautyFilters.size(); ++i2) {
            ((com.tencent.liteav.videobase.a.b)this.mBeautyFilters.valueAt(i2)).uninitialize();
        }
    }

    public void setAIDetectListener(com.tencent.liteav.videobase.base.a listener) {
    }

    public void setBeautyManagerStatusListener(a listener) {
        this.mBeautyManagerStatusListener = listener;
    }

    public void setHomeOrientation(int homeOrientation) {
    }

    @CalledByNative
    public void setBeautyStyle(int beautyStyle) {
        LiteavLog.d(TAG, "setBeautyStyle beautyStyle:".concat(String.valueOf(beautyStyle)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(com.tencent.liteav.videoproducer.preprocessor.a.a(beautyProcessor, beautyStyle));
    }

    @CalledByNative
    public void setBeautyLevel(float beautyLevel) {
        float f2 = com.tencent.liteav.base.util.h.a(beautyLevel, 0.0f, 0.9f);
        LiteavLog.d(TAG, "setBeautyLevel beautyLevel:".concat(String.valueOf(beautyLevel)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(b.a(beautyProcessor, f2));
    }

    @CalledByNative
    public void setWhitenessLevel(float whitenessLevel) {
        float f2 = com.tencent.liteav.base.util.h.a(whitenessLevel, 0.0f, 0.9f);
        LiteavLog.d(TAG, "setWhitenessLevel whitenessLevel:".concat(String.valueOf(whitenessLevel)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(c.a(beautyProcessor, f2));
    }

    @CalledByNative
    public void setSharpenLevel(float sharpnessLevel) {
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(d.a(beautyProcessor, sharpnessLevel));
    }

    @CalledByNative
    public void setRuddyLevel(float ruddyLevel) {
        float f2 = com.tencent.liteav.base.util.h.a(ruddyLevel, 0.0f, 0.9f);
        LiteavLog.d(TAG, "setRuddyLevel ruddyLevel:".concat(String.valueOf(ruddyLevel)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(e.a(beautyProcessor, f2));
    }

    @CalledByNative
    public void setEyeScaleLevel(int eyeScaleLevel) {
        this.setScalableCosmeticTypeLevel(l.a.b, eyeScaleLevel);
        this.updateStatsOnDraw("eyeBigScale", eyeScaleLevel);
    }

    @CalledByNative
    public void setFaceSlimLevel(int faceSlimLevel) {
        this.setScalableCosmeticTypeLevel(l.a.a, faceSlimLevel);
        this.updateStatsOnDraw("faceSlimLevel", faceSlimLevel);
    }

    @CalledByNative
    public void setFaceVLevel(int faceVLevel) {
        this.setScalableCosmeticTypeLevel(l.a.c, faceVLevel);
        this.updateStatsOnDraw("faceVLevel", faceVLevel);
    }

    @CalledByNative
    public void setChinLevel(int chinLevel) {
        this.setScalableCosmeticTypeLevel(l.a.f, chinLevel);
        this.updateStatsOnDraw("chinLevel", chinLevel);
    }

    @CalledByNative
    public void setFaceShortLevel(int faceShortLevel) {
        this.setScalableCosmeticTypeLevel(l.a.d, faceShortLevel);
        this.updateStatsOnDraw("faceShortLevel", faceShortLevel);
    }

    @CalledByNative
    public void setFaceNarrowLevel(int faceNarrowLevel) {
        this.setScalableCosmeticTypeLevel(l.a.e, faceNarrowLevel);
        this.updateStatsOnDraw("faceNarrowLevel", faceNarrowLevel);
    }

    @CalledByNative
    public void setNoseSlimLevel(int noseSlimLevel) {
        this.setScalableCosmeticTypeLevel(l.a.g, noseSlimLevel);
        this.updateStatsOnDraw("noseSlimLevel", noseSlimLevel);
    }

    @CalledByNative
    public void setEyeLightenLevel(int eyeLightenLevel) {
        this.setScalableCosmeticTypeLevel(l.a.s, eyeLightenLevel);
        this.updateStatsOnDraw("eyeLightenLevel", eyeLightenLevel);
    }

    @CalledByNative
    public void setToothWhitenLevel(int toothWhitenLevel) {
        this.setScalableCosmeticTypeLevel(l.a.t, toothWhitenLevel);
        this.updateStatsOnDraw("toothWhitenLevel", toothWhitenLevel);
    }

    @CalledByNative
    public void setWrinkleRemoveLevel(int wrinkleRemoveLevel) {
        this.setScalableCosmeticTypeLevel(l.a.u, wrinkleRemoveLevel);
        this.updateStatsOnDraw("wrinkleRemoveLevel", wrinkleRemoveLevel);
    }

    @CalledByNative
    public void setPounchRemoveLevel(int pounchRemoveLevel) {
        this.setScalableCosmeticTypeLevel(l.a.v, pounchRemoveLevel);
        this.updateStatsOnDraw("pounchRemoveLevel", pounchRemoveLevel);
    }

    @CalledByNative
    public void setSmileLinesRemoveLevel(int smileLinesRemoveLevel) {
        this.setScalableCosmeticTypeLevel(l.a.w, smileLinesRemoveLevel);
        this.updateStatsOnDraw("smileLinesRemoveLevel", smileLinesRemoveLevel);
    }

    @CalledByNative
    public void setForeheadLevel(int foreheadLevel) {
        this.setScalableCosmeticTypeLevel(l.a.h, foreheadLevel);
        this.updateStatsOnDraw("foreheadLevel", foreheadLevel);
    }

    @CalledByNative
    public void setEyeDistanceLevel(int eyeDistanceLevel) {
        this.setScalableCosmeticTypeLevel(l.a.i, eyeDistanceLevel);
        this.updateStatsOnDraw("eyeDistanceLevel", eyeDistanceLevel);
    }

    @CalledByNative
    public void setEyeAngleLevel(int eyeAngleLevel) {
        this.setScalableCosmeticTypeLevel(l.a.j, eyeAngleLevel);
        this.updateStatsOnDraw("eyeAngleLevel", eyeAngleLevel);
    }

    @CalledByNative
    public void setMouthShapeLevel(int mouthShapeLevel) {
        this.setScalableCosmeticTypeLevel(l.a.k, mouthShapeLevel);
        this.updateStatsOnDraw("mouthShapeLevel", mouthShapeLevel);
    }

    @CalledByNative
    public void setNoseWingLevel(int noseWingLevel) {
        this.setScalableCosmeticTypeLevel(l.a.l, noseWingLevel);
        this.updateStatsOnDraw("noseWingLevel", noseWingLevel);
    }

    @CalledByNative
    public void setNosePositionLevel(int nosePositionLevel) {
        this.setScalableCosmeticTypeLevel(l.a.m, nosePositionLevel);
        this.updateStatsOnDraw("nosePositionLevel", nosePositionLevel);
    }

    @CalledByNative
    public void setLipsThicknessLevel(int lipsThicknessLevel) {
        this.setScalableCosmeticTypeLevel(l.a.n, lipsThicknessLevel);
        this.updateStatsOnDraw("lipsThicknessLevel", lipsThicknessLevel);
    }

    @CalledByNative
    public void setFaceBeautyLevel(int faceBeautyLevel) {
        this.setScalableCosmeticTypeLevel(l.a.r, faceBeautyLevel);
        this.updateStatsOnDraw("faceBeautyLevel", faceBeautyLevel);
    }

    @CalledByNative
    public void setMotionTmpl(String tmplPath) {
        LiteavLog.d(TAG, "setMotionTmpl tmplPath:".concat(String.valueOf(tmplPath)));
        if (!TextUtils.isEmpty((CharSequence)tmplPath)) {
            com.tencent.liteav.beauty.a.g(this.mReporter);
        }
    }

    @CalledByNative
    public void setMotionMute(boolean motionMute) {
        LiteavLog.d(TAG, "setMotionMute motionMute:".concat(String.valueOf(motionMute)));
    }

    @Override
    public boolean canBeSkipped() {
        BeautyProcessor beautyProcessor = this;
        return beautyProcessor.canBeSkipped(beautyProcessor.mCurrentBeautyFilter) && this.mMotionFilter.canBeSkipped();
    }

    private boolean canBeSkipped(com.tencent.liteav.videobase.a.b filter) {
        if (filter == null) {
            return true;
        }
        return filter.canBeSkipped();
    }

    public void updateStatsOnDraw(String key, int value) {
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(f.a(beautyProcessor, key, value));
    }

    private void setScalableCosmeticTypeLevel(l.a type, int level) {
        LiteavLog.d(TAG, "setScalableCosmeticTypeLevel %s %d", new Object[]{type, level});
        if (!this.mIsEnterPriseProEnabled) {
            LiteavLog.i(TAG, "need support EnterPrise above!!!");
            return;
        }
        if (level > 0) {
            com.tencent.liteav.beauty.a.a(this.mReporter, type);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateBeautyInternal(int beautyStyle, float beautyLevel, float whitenessLevel, float ruddyLevel, float sharpnessLevel) {
        block11: {
            if (this.mOutputSize.width == -1 || this.mOutputSize.height == -1) {
                return;
            }
            if (this.mBeautyStyle != beautyStyle) {
                this.updateStatsOnDraw("beautyStyle", beautyStyle);
            }
            if ((var6_6 = (com.tencent.liteav.videobase.a.b)this.mBeautyFilters.get(beautyStyle)) == null) {
                switch (beautyStyle) {
                    case 0: {
                        var6_6 = new com.tencent.liteav.beauty.b.b.a();
                        break;
                    }
                    case 1: {
                        var6_6 = new com.tencent.liteav.beauty.b.c.a();
                        break;
                    }
                    case 2: {
                        var6_6 = new com.tencent.liteav.beauty.b.a.a();
                        break;
                    }
                    default: {
                        var6_6 = new com.tencent.liteav.beauty.b.a();
                    }
                }
                var6_6.initialize(this.mTexturePool);
                var6_6.onOutputSizeChanged(this.mOutputSize.width, this.mOutputSize.height);
                this.mBeautyFilters.put(beautyStyle, (Object)var6_6);
            }
            var7_7 = (com.tencent.liteav.beauty.b.b)var6_6;
            var7_7.a(beautyLevel);
            var7_7.c(ruddyLevel);
            var7_7.b(whitenessLevel);
            var7_7.d(sharpnessLevel);
            if (this.mBeautyStyle == beautyStyle && com.tencent.liteav.videobase.utils.e.a(this.mBeautyLevel, beautyLevel) != false && com.tencent.liteav.videobase.utils.e.a(this.mWhitenessLevel, whitenessLevel) != false && com.tencent.liteav.videobase.utils.e.a(this.mRuddyLevel, ruddyLevel) != false && com.tencent.liteav.videobase.utils.e.a(this.mSharpnessLevel, sharpnessLevel) != false) break block11;
            this.mBeautyStyle = beautyStyle;
            this.mBeautyLevel = beautyLevel;
            this.mWhitenessLevel = whitenessLevel;
            this.mRuddyLevel = ruddyLevel;
            this.mSharpnessLevel = sharpnessLevel;
            this.removeAllFilterAndInterceptor();
            this.mCurrentBeautyFilter = null;
            v0 = this;
            if (!v0.isLessOrEqualZero(v0.mBeautyLevel)) ** GOTO lbl-1000
            v1 = this;
            if (!v1.isLessOrEqualZero(v1.mRuddyLevel)) ** GOTO lbl-1000
            v2 = this;
            if (v2.isLessOrEqualZero(v2.mWhitenessLevel)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) {
                this.addFilter(var6_6);
                this.mCurrentBeautyFilter = var6_6;
            }
            v4 = this;
            v4.addFilter(v4.mMotionFilter);
        }
    }

    private void updateStatsInternal(String key, float value) {
        this.mBeautyStats.put(key, String.valueOf(value));
        if (this.mBeautyManagerStatusListener == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mBeautyStats.entrySet()) {
            stringBuilder.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        String string = "{" + stringBuilder + "}";
        this.mBeautyManagerStatusListener.onBeautyStatsChanged(string);
    }

    private float getSharpnessLevel() {
        float f2 = this.mUserSetSharpnessLevel != 0.0f ? this.mUserSetSharpnessLevel : (!this.mIsPerformanceMode && Math.min(this.mOutputSize.width, this.mOutputSize.height) >= 540 ? 0.4f : 0.0f);
        return f2;
    }

    public void setPerformanceMode(boolean isPerformanceMode) {
        LiteavLog.d(TAG, "setPerformanceMode: ".concat(String.valueOf(isPerformanceMode)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(g.a(beautyProcessor, isPerformanceMode));
    }

    private void updateSharpenLevelInternal() {
        float f2 = this.getSharpnessLevel();
        LiteavLog.d(TAG, "sharpnessLevel: ".concat(String.valueOf(f2)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle, this.mBeautyLevel, this.mWhitenessLevel, this.mRuddyLevel, f2);
        if (f2 > 0.0f) {
            com.tencent.liteav.beauty.a.d(this.mReporter);
        }
    }

    static /* synthetic */ void lambda$setPerformanceMode$6(BeautyProcessor this_, boolean isPerformanceMode) {
        this_.mIsPerformanceMode = isPerformanceMode;
        this_.updateSharpenLevelInternal();
    }

    static /* synthetic */ void lambda$updateStatsOnDraw$5(BeautyProcessor this_, String key, int value) {
        this_.updateStatsInternal(key, value);
    }

    static /* synthetic */ void lambda$setRuddyLevel$4(BeautyProcessor this_, float clampedLevel) {
        BeautyProcessor beautyProcessor = this_;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle, this_.mBeautyLevel, this_.mWhitenessLevel, clampedLevel, this_.mSharpnessLevel);
        if (clampedLevel > 0.0f) {
            com.tencent.liteav.beauty.a.e(this_.mReporter);
        }
        this_.updateStatsInternal("ruddyLevel", clampedLevel);
    }

    static /* synthetic */ void lambda$setSharpenLevel$3(BeautyProcessor this_, float sharpnessLevel) {
        this_.mUserSetSharpnessLevel = com.tencent.liteav.base.util.h.a(sharpnessLevel, 0.0f, 0.9f);
        LiteavLog.d(TAG, "mUserSetSharpnessLevel: " + this_.mUserSetSharpnessLevel);
        this_.updateSharpenLevelInternal();
    }

    static /* synthetic */ void lambda$setWhitenessLevel$2(BeautyProcessor this_, float clampedLevel) {
        BeautyProcessor beautyProcessor = this_;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle, this_.mBeautyLevel, clampedLevel, this_.mRuddyLevel, this_.mSharpnessLevel);
        if (clampedLevel > 0.0f) {
            com.tencent.liteav.beauty.a.c(this_.mReporter);
        }
        this_.updateStatsInternal("whiteLevel", clampedLevel);
    }

    static /* synthetic */ void lambda$setBeautyLevel$1(BeautyProcessor this_, float clampedLevel) {
        BeautyProcessor beautyProcessor = this_;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle, clampedLevel, this_.mWhitenessLevel, this_.mRuddyLevel, this_.mSharpnessLevel);
        if (clampedLevel > 0.0f) {
            com.tencent.liteav.beauty.a.b(this_.mReporter);
        }
        this_.updateStatsInternal("beautyLevel", clampedLevel);
    }

    static /* synthetic */ void lambda$setBeautyStyle$0(BeautyProcessor this_, int beautyStyle) {
        this_.updateBeautyInternal(beautyStyle, this_.mBeautyLevel, this_.mWhitenessLevel, this_.mRuddyLevel, this_.mSharpnessLevel);
    }

    public static interface a {
        public void onBeautyStatsChanged(String var1);
    }
}

