/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.net.ProtocolException;

public class ConnectionProfile {
    static final int RANGE_INFINITE = -1;
    final long startOffset;
    final long currentOffset;
    final long endOffset;
    final long contentLength;
    private final boolean isForceNoRange;
    private final boolean isTrialConnect;

    private ConnectionProfile() {
        this.startOffset = 0L;
        this.currentOffset = 0L;
        this.endOffset = 0L;
        this.contentLength = 0L;
        this.isForceNoRange = false;
        this.isTrialConnect = true;
    }

    private ConnectionProfile(long startOffset, long currentOffset, long endOffset, long contentLength) {
        this(startOffset, currentOffset, endOffset, contentLength, false);
    }

    private ConnectionProfile(long startOffset, long currentOffset, long endOffset, long contentLength, boolean isForceNoRange) {
        if ((startOffset != 0L || endOffset != 0L) && isForceNoRange) {
            throw new IllegalArgumentException();
        }
        this.startOffset = startOffset;
        this.currentOffset = currentOffset;
        this.endOffset = endOffset;
        this.contentLength = contentLength;
        this.isForceNoRange = isForceNoRange;
        this.isTrialConnect = false;
    }

    public void processProfile(FileDownloadConnection connection) throws ProtocolException {
        if (this.isForceNoRange) {
            return;
        }
        if (this.isTrialConnect && FileDownloadProperties.getImpl().trialConnectionHeadMethod) {
            connection.setRequestMethod("HEAD");
        }
        String range = this.endOffset == -1L ? FileDownloadUtils.formatString("bytes=%d-", this.currentOffset) : FileDownloadUtils.formatString("bytes=%d-%d", this.currentOffset, this.endOffset);
        connection.addHeader("Range", range);
    }

    public String toString() {
        return FileDownloadUtils.formatString("range[%d, %d) current offset[%d]", this.startOffset, this.endOffset, this.currentOffset);
    }

    public static class ConnectionProfileBuild {
        public static ConnectionProfile buildTrialConnectionProfile() {
            return new ConnectionProfile();
        }

        public static ConnectionProfile buildTrialConnectionProfileNoRange() {
            return new ConnectionProfile(0L, 0L, 0L, 0L, true);
        }

        public static ConnectionProfile buildBeginToEndConnectionProfile(long contentLength) {
            return new ConnectionProfile(0L, 0L, -1L, contentLength);
        }

        public static ConnectionProfile buildToEndConnectionProfile(long startOffset, long currentOffset, long contentLength) {
            return new ConnectionProfile(startOffset, currentOffset, -1L, contentLength);
        }

        public static ConnectionProfile buildConnectionProfile(long startOffset, long currentOffset, long endOffset, long contentLength) {
            return new ConnectionProfile(startOffset, currentOffset, endOffset, contentLength);
        }
    }
}

