/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import androidx.annotation.UiThread;
import com.tencent.liteav.base.ThreadUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class JavaExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler mParent;
    private final boolean mCrashAfterReport;
    private boolean mHandlingException;

    private JavaExceptionReporter(Thread.UncaughtExceptionHandler parent, boolean crashAfterReport) {
        this.mParent = parent;
        this.mCrashAfterReport = crashAfterReport;
    }

    @Override
    public void uncaughtException(Thread t2, Throwable e2) {
        if (!this.mHandlingException) {
            this.mHandlingException = true;
        }
        if (this.mParent != null) {
            this.mParent.uncaughtException(t2, e2);
        }
    }

    @UiThread
    public static void reportStackTrace(String stackTrace) {
        assert (ThreadUtils.runningOnUiThread());
    }

    @CalledByNative
    private static void installHandler(boolean crashAfterReport) {
        Thread.setDefaultUncaughtExceptionHandler(new JavaExceptionReporter(Thread.getDefaultUncaughtExceptionHandler(), crashAfterReport));
    }
}

