/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.thirdparties;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Process;
import com.tencent.thumbplayer.core.utils.TPThreadPool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

public class LocalCache {
    public static final int TIME_HOUR = 3600;
    public static final int TIME_DAY = 86400;
    private static final int MAX_SIZE = 50000000;
    private static final int MAX_COUNT = Integer.MAX_VALUE;
    private static Map<String, LocalCache> mInstanceMap = new HashMap<String, LocalCache>();
    private ACacheManager mCache;

    public static LocalCache get(Context context) {
        return LocalCache.get(context, "LocalCache");
    }

    public static LocalCache get(Context context, String string) {
        return LocalCache.get(new File(context.getCacheDir(), string), 50000000L, Integer.MAX_VALUE);
    }

    public static LocalCache get(File file) {
        return LocalCache.get(file, 50000000L, Integer.MAX_VALUE);
    }

    public static LocalCache get(Context context, long l2, int n2) {
        return LocalCache.get(new File(context.getCacheDir(), "LocalCache"), l2, n2);
    }

    public static LocalCache get(File file, long l2, int n2) {
        LocalCache localCache = null;
        try {
            localCache = mInstanceMap.get(file.getAbsoluteFile() + LocalCache.myPid());
        }
        catch (Exception exception) {}
        if (localCache == null) {
            try {
                localCache = new LocalCache(file, l2, n2);
                mInstanceMap.put(file.getAbsolutePath() + LocalCache.myPid(), localCache);
            }
            catch (Throwable throwable) {}
        }
        return localCache;
    }

    private static String myPid() {
        return "_" + Process.myPid();
    }

    private LocalCache(File file, long l2, int n2) {
        if (!file.exists() && !file.mkdirs()) {
            this.mCache = null;
            return;
        }
        this.mCache = new ACacheManager(file, l2, n2);
    }

    /*
     * Loose catch block
     */
    public void put(String string, String string2) {
        if (this.mCache == null) {
            return;
        }
        File file = this.mCache.newFile(string);
        BufferedWriter bufferedWriter = null;
        bufferedWriter = new BufferedWriter(new FileWriter(file), 1024);
        bufferedWriter.write(string2);
        try {
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mCache.put(file);
        return;
        catch (IOException iOException) {
            block18: {
                try {
                    iOException.printStackTrace();
                    if (bufferedWriter == null) break block18;
                }
                catch (Throwable throwable) {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.flush();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException3) {
                            iOException3.printStackTrace();
                        }
                    }
                    this.mCache.put(file);
                    throw throwable;
                }
                try {
                    bufferedWriter.flush();
                }
                catch (IOException iOException4) {
                    iOException4.printStackTrace();
                }
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException5) {
                    iOException5.printStackTrace();
                }
            }
            this.mCache.put(file);
            return;
        }
    }

    public void put(String string, String string2, int n2) {
        this.put(string, Utils.newStringWithDateInfo(n2, string2));
    }

    /*
     * Loose catch block
     */
    public String getAsString(String string) {
        BufferedReader bufferedReader;
        block16: {
            String string2;
            if (this.mCache == null) {
                return null;
            }
            File file = this.mCache.get(string);
            if (!file.exists()) {
                return null;
            }
            bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = string3 + string2;
            }
            if (Utils.isDue(string3)) break block16;
            String string4 = Utils.clearDateInfo(string3);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return string4;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.remove(string);
        return null;
        catch (IOException iOException) {
            block17: {
                try {
                    iOException.printStackTrace();
                    if (bufferedReader == null) break block17;
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
            return null;
        }
    }

    public void put(String string, JSONObject jSONObject) {
        this.put(string, jSONObject.toString());
    }

    public void put(String string, JSONObject jSONObject, int n2) {
        this.put(string, jSONObject.toString(), n2);
    }

    public JSONObject getAsJSONObject(String string) {
        String string2 = this.getAsString(string);
        try {
            return new JSONObject(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void put(String string, JSONArray jSONArray) {
        this.put(string, jSONArray.toString());
    }

    public void put(String string, JSONArray jSONArray, int n2) {
        this.put(string, jSONArray.toString(), n2);
    }

    public JSONArray getAsJSONArray(String string) {
        String string2 = this.getAsString(string);
        try {
            return new JSONArray(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public void put(String string, byte[] byArray) {
        if (this.mCache == null) {
            return;
        }
        File file = this.mCache.newFile(string);
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        try {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mCache.put(file);
        return;
        catch (Exception exception) {
            block12: {
                try {
                    exception.printStackTrace();
                    if (fileOutputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.flush();
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    this.mCache.put(file);
                    throw throwable;
                }
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.mCache.put(file);
            return;
        }
    }

    public void put(String string, byte[] byArray, int n2) {
        this.put(string, Utils.newByteArrayWithDateInfo(n2, byArray));
    }

    /*
     * Loose catch block
     */
    public byte[] getAsBinary(String string) {
        RandomAccessFile randomAccessFile;
        block18: {
            block19: {
                File file;
                block17: {
                    if (this.mCache == null) {
                        return null;
                    }
                    randomAccessFile = null;
                    file = this.mCache.get(string);
                    if (file.exists()) break block17;
                    return null;
                }
                randomAccessFile = new RandomAccessFile(file, "r");
                byte[] byArray = new byte[(int)randomAccessFile.length()];
                if (randomAccessFile.read(byArray) <= 0) break block18;
                if (Utils.isDue(byArray)) break block19;
                byte[] byArray2 = Utils.clearDateInfo(byArray);
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return byArray2;
            }
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.remove(string);
            return null;
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
        catch (Exception exception) {
            block20: {
                try {
                    exception.printStackTrace();
                    if (randomAccessFile == null) break block20;
                }
                catch (Throwable throwable) {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return null;
        }
    }

    public void put(String string, Serializable serializable) {
        this.put(string, serializable, -1);
    }

    /*
     * Loose catch block
     */
    public void put(String string, Serializable serializable, int n2) {
        ObjectOutputStream objectOutputStream;
        block18: {
            objectOutputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (n2 != -1) {
                this.put(string, byArray, n2);
                break block18;
            }
            this.put(string, byArray);
        }
        try {
            objectOutputStream.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            {
                catch (Throwable throwable2) {
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                    }
                    catch (Throwable throwable3) {}
                    throw throwable2;
                }
            }
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                return;
            }
            catch (Throwable throwable4) {
                return;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Object getAsObject(String string) {
        byte[] byArray = this.getAsBinary(string);
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return object;
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    public void put(String string, Bitmap bitmap) {
        this.put(string, Utils.Bitmap2Bytes(bitmap));
    }

    public void put(String string, Bitmap bitmap, int n2) {
        this.put(string, Utils.Bitmap2Bytes(bitmap), n2);
    }

    public Bitmap getAsBitmap(String string) {
        if (this.getAsBinary(string) == null) {
            return null;
        }
        return Utils.Bytes2Bimap(this.getAsBinary(string));
    }

    public void put(String string, Drawable drawable) {
        this.put(string, Utils.drawable2Bitmap(drawable));
    }

    public void put(String string, Drawable drawable, int n2) {
        this.put(string, Utils.drawable2Bitmap(drawable), n2);
    }

    public Drawable getAsDrawable(String string) {
        if (this.getAsBinary(string) == null) {
            return null;
        }
        return Utils.bitmap2Drawable(Utils.Bytes2Bimap(this.getAsBinary(string)));
    }

    public File file(String string) {
        if (this.mCache == null) {
            return null;
        }
        File file = this.mCache.newFile(string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean remove(String string) {
        if (this.mCache == null) {
            return false;
        }
        return this.mCache.remove(string);
    }

    public void clear() {
        if (this.mCache == null) {
            return;
        }
        this.mCache.clear();
    }

    static class Utils {
        private static final char mSeparator = ' ';

        private Utils() {
        }

        private static boolean isDue(String string) {
            return Utils.isDue(string.getBytes());
        }

        private static boolean isDue(byte[] byArray) {
            String[] stringArray = Utils.getDateInfoFromDate(byArray);
            if (stringArray != null && stringArray.length == 2) {
                String string = stringArray[0];
                while (string.startsWith("0")) {
                    string = string.substring(1, string.length());
                }
                try {
                    long l2 = Long.valueOf(string);
                    long l3 = Long.valueOf(stringArray[1]);
                    if (System.currentTimeMillis() > l2 + l3 * 1000L) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }

        private static String newStringWithDateInfo(int n2, String string) {
            return Utils.createDateInfo(n2) + string;
        }

        private static byte[] newByteArrayWithDateInfo(int n2, byte[] byArray) {
            byte[] byArray2 = Utils.createDateInfo(n2).getBytes();
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            return byArray3;
        }

        private static String clearDateInfo(String string) {
            if (string != null && Utils.hasDateInfo(string.getBytes())) {
                String string2 = string;
                string = string2.substring(string2.indexOf(32) + 1, string.length());
            }
            return string;
        }

        private static byte[] clearDateInfo(byte[] byArray) {
            if (Utils.hasDateInfo(byArray)) {
                return Utils.copyOfRange(byArray, Utils.indexOf(byArray, ' ') + 1, byArray.length);
            }
            return byArray;
        }

        private static boolean hasDateInfo(byte[] byArray) {
            return byArray != null && byArray.length > 15 && byArray[13] == 45 && Utils.indexOf(byArray, ' ') > 14;
        }

        private static String[] getDateInfoFromDate(byte[] byArray) {
            if (Utils.hasDateInfo(byArray)) {
                String string = new String(Utils.copyOfRange(byArray, 0, 13));
                String string2 = new String(Utils.copyOfRange(byArray, 14, Utils.indexOf(byArray, ' ')));
                return new String[]{string, string2};
            }
            return null;
        }

        private static int indexOf(byte[] byArray, char c2) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] != c2) continue;
                return i2;
            }
            return -1;
        }

        private static byte[] copyOfRange(byte[] byArray, int n2, int n3) {
            int n4 = n3 - n2;
            if (n4 < 0) {
                throw new IllegalArgumentException(n2 + " > " + n3);
            }
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, Math.min(byArray.length - n2, n4));
            return byArray2;
        }

        private static String createDateInfo(int n2) {
            String string = "" + System.currentTimeMillis();
            while (string.length() < 13) {
                string = "0".concat(String.valueOf(string));
            }
            return string + "-" + n2 + ' ';
        }

        private static byte[] Bitmap2Bytes(Bitmap bitmap) {
            if (bitmap == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        private static Bitmap Bytes2Bimap(byte[] byArray) {
            if (byArray.length == 0) {
                return null;
            }
            return null;
        }

        private static Bitmap drawable2Bitmap(Drawable drawable) {
            if (drawable == null) {
                return null;
            }
            int n2 = drawable.getIntrinsicWidth();
            int n3 = drawable.getIntrinsicHeight();
            Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, n2, n3);
            drawable.draw(canvas);
            return bitmap;
        }

        private static Drawable bitmap2Drawable(Bitmap bitmap) {
            if (bitmap == null) {
                return null;
            }
            return new BitmapDrawable(bitmap);
        }
    }

    public class ACacheManager {
        private final AtomicLong cacheSize;
        private final AtomicInteger cacheCount;
        private final long sizeLimit;
        private final int countLimit;
        private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());
        protected File cacheDir;

        private ACacheManager(File file, long l2, int n2) {
            this.cacheDir = file;
            this.sizeLimit = l2;
            this.countLimit = n2;
            this.cacheSize = new AtomicLong();
            this.cacheCount = new AtomicInteger();
            this.calculateCacheSizeAndCacheCount();
        }

        private void calculateCacheSizeAndCacheCount() {
            TPThreadPool.getInstance().obtainThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    int n2 = 0;
                    int n3 = 0;
                    File[] fileArray = ACacheManager.this.cacheDir.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n4 = fileArray.length;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            File file = fileArray2[i2];
                            n2 = (int)((long)n2 + ACacheManager.this.calculateSize(file));
                            ++n3;
                            File file2 = file;
                            ACacheManager.this.lastUsageDates.put(file2, file2.lastModified());
                        }
                        ACacheManager.this.cacheSize.set(n2);
                        ACacheManager.this.cacheCount.set(n3);
                    }
                }
            });
        }

        private void put(File file) {
            long l2;
            int n2 = this.cacheCount.get();
            while (n2 + 1 > this.countLimit) {
                l2 = this.removeNext();
                this.cacheSize.addAndGet(-l2);
                n2 = this.cacheCount.addAndGet(-1);
            }
            this.cacheCount.addAndGet(1);
            l2 = this.calculateSize(file);
            long l3 = this.cacheSize.get();
            while (l3 + l2 > this.sizeLimit) {
                long l4 = this.removeNext();
                l3 = this.cacheSize.addAndGet(-l4);
            }
            this.cacheSize.addAndGet(l2);
            Long l5 = System.currentTimeMillis();
            file.setLastModified(l5);
            this.lastUsageDates.put(file, l5);
        }

        private File get(String string) {
            File file = this.newFile(string);
            Long l2 = System.currentTimeMillis();
            file.setLastModified(l2);
            this.lastUsageDates.put(file, l2);
            return file;
        }

        private File newFile(String string) {
            return new File(this.cacheDir, "" + string.hashCode());
        }

        private boolean remove(String string) {
            return this.get(string).delete();
        }

        private void clear() {
            this.lastUsageDates.clear();
            this.cacheSize.set(0L);
            File[] fileArray = this.cacheDir.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    fileArray2[i2].delete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long removeNext() {
            if (this.lastUsageDates.isEmpty()) {
                return 0L;
            }
            Long l2 = null;
            File file = null;
            Set<Map.Entry<File, Long>> set = this.lastUsageDates.entrySet();
            Map<File, Long> map = this.lastUsageDates;
            synchronized (map) {
                for (Map.Entry<File, Long> entry : set) {
                    if (file == null) {
                        file = entry.getKey();
                        l2 = entry.getValue();
                        continue;
                    }
                    Long l3 = entry.getValue();
                    if (l3 >= l2) continue;
                    l2 = l3;
                    file = entry.getKey();
                }
            }
            if (file == null) {
                return 0L;
            }
            long l4 = this.calculateSize(file);
            if (file != null && file.delete()) {
                this.lastUsageDates.remove(file);
            }
            return l4;
        }

        private long calculateSize(File file) {
            if (file == null) {
                return 0L;
            }
            return file.length();
        }
    }
}

