/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.RoundingParams;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeHierarchy;
import io.dcloud.feature.weex.adapter.FrescoImageView;
import java.util.Map;

public class FrescoImageComponent
extends WXImage {
    private String mResizeMode = "scaleToFill";
    private int mBitmapWidth = 0;
    private int mBitmapHeight = 0;

    public FrescoImageComponent(WXSDKInstance instance, WXVContainer parent, final BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.setContentBoxMeasurement(new ContentBoxMeasurement(){

            @Override
            public void measureInternal(float width, float height, int widthMeasureMode, int heightMeasureMode) {
                float s;
                boolean isFlex = basicComponentData.getStyles().containsKey("flex");
                this.mMeasureExactly = false;
                if (widthMeasureMode == 0) {
                    if (FrescoImageComponent.this.mResizeMode.equals("heightFix") && FrescoImageComponent.this.mBitmapHeight > 0 && FrescoImageComponent.this.mBitmapWidth > 0 && !Float.isNaN(height)) {
                        s = height / (float)FrescoImageComponent.this.mBitmapHeight;
                        this.mMeasureWidth = (float)FrescoImageComponent.this.mBitmapWidth * s;
                        this.mMeasureExactly = true;
                    } else if (!isFlex) {
                        this.mMeasureWidth = (int)WXViewUtils.getRealPxByWidth(320.0f, FrescoImageComponent.this.getInstance().getInstanceViewPortWidthWithFloat());
                    }
                }
                if (heightMeasureMode == 0) {
                    if (FrescoImageComponent.this.mResizeMode.equals("widthFix") && FrescoImageComponent.this.mBitmapHeight > 0 && FrescoImageComponent.this.mBitmapWidth > 0 && !Float.isNaN(width)) {
                        s = width / (float)FrescoImageComponent.this.mBitmapWidth;
                        this.mMeasureHeight = (float)FrescoImageComponent.this.mBitmapHeight * s;
                        this.mMeasureExactly = true;
                    } else if (!isFlex) {
                        this.mMeasureHeight = (int)WXViewUtils.getRealPxByWidth(240.0f, FrescoImageComponent.this.getInstance().getInstanceViewPortWidthWithFloat());
                    }
                }
            }

            @Override
            public void layoutBefore() {
            }

            @Override
            public void layoutAfter(float computedWidth, float computedHeight) {
            }
        });
    }

    @Override
    protected ImageView initComponentHostView(@NonNull Context context) {
        FrescoImageView view = new FrescoImageView(context);
        ((DCGenericDraweeHierarchy)view.getHierarchy()).setActualImageScaleType(ScalingUtils.ScaleType.FIT_XY);
        return view;
    }

    @WXComponentProp(name="fadeShow")
    public void setFadeAnim(String v) {
        if (!TextUtils.isEmpty((CharSequence)v) && this.getHostView() != null) {
            FrescoImageView view = (FrescoImageView)this.getHostView();
            view.setFadeShow(Boolean.valueOf(v));
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "resizeMode": {
                String resizeMode = WXUtils.getString(param, null);
                if (resizeMode != null) {
                    this.setResizeMode(resizeMode);
                }
                return true;
            }
            case "resize": {
                String resize = WXUtils.getString(param, null);
                if (resize != null) {
                    this.setResizeMode(resize);
                }
                return true;
            }
            case "mode": {
                String mode = WXUtils.getString(param, null);
                if (mode != null) {
                    this.setResizeMode(mode);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    public void setResizeMode(String resizeMode) {
        FrescoImageView frescoImageView = (FrescoImageView)this.getHostView();
        ScalingUtils.ScaleType scaleType = ScalingUtils.ScaleType.FIT_XY;
        this.mResizeMode = resizeMode;
        if (!TextUtils.isEmpty((CharSequence)resizeMode)) {
            switch (resizeMode) {
                case "cover": {
                    scaleType = ScalingUtils.ScaleType.CENTER_CROP;
                    break;
                }
                case "contain": {
                    scaleType = ScalingUtils.ScaleType.FIT_CENTER;
                    break;
                }
                case "stretch": {
                    scaleType = ScalingUtils.ScaleType.FIT_XY;
                    break;
                }
                case "scaleToFill": {
                    scaleType = ScalingUtils.ScaleType.FIT_XY;
                    break;
                }
                case "aspectFit": {
                    scaleType = ScalingUtils.ScaleType.FIT_CENTER;
                    break;
                }
                case "aspectFill": {
                    scaleType = ScalingUtils.ScaleType.CENTER_CROP;
                    break;
                }
                case "top": {
                    scaleType = new CustomScaleType(0.5f, 0.0f);
                    break;
                }
                case "bottom": {
                    scaleType = new CustomScaleType(0.5f, 1.0f);
                    break;
                }
                case "center": {
                    scaleType = new CustomScaleType(0.5f, 0.5f);
                    break;
                }
                case "left": {
                    scaleType = new CustomScaleType(0.0f, 0.5f);
                    break;
                }
                case "right": {
                    scaleType = new CustomScaleType(1.0f, 0.5f);
                    break;
                }
                case "top left": {
                    scaleType = new CustomScaleType(0.0f, 0.0f);
                    break;
                }
                case "top right": {
                    scaleType = new CustomScaleType(1.0f, 0.0f);
                    break;
                }
                case "bottom left": {
                    scaleType = new CustomScaleType(0.0f, 1.0f);
                    break;
                }
                case "bottom right": {
                    scaleType = new CustomScaleType(1.0f, 1.0f);
                    break;
                }
                case "widthFix": 
                case "heightFix": {
                    scaleType = ScalingUtils.ScaleType.FIT_CENTER;
                    break;
                }
            }
        }
        ((DCGenericDraweeHierarchy)frescoImageView.getHierarchy()).setActualImageScaleType(scaleType);
    }

    @Override
    public void onImageFinish(boolean result, Map extra) {
        super.onImageFinish(result, extra);
        if (extra != null) {
            switch (this.mResizeMode) {
                case "widthFix": {
                    this.mBitmapWidth = Integer.parseInt(extra.get("width").toString());
                    this.mBitmapHeight = Integer.parseInt(extra.get("height").toString());
                    float s = this.getLayoutWidth() / (float)this.mBitmapWidth;
                    float h = (float)this.mBitmapHeight * s;
                    if (this.getLayoutHeight() == h) break;
                    this.setStyleHeight(h);
                    break;
                }
                case "heightFix": {
                    this.mBitmapWidth = Integer.parseInt(extra.get("width").toString());
                    this.mBitmapHeight = Integer.parseInt(extra.get("height").toString());
                    float s = this.getLayoutHeight() / (float)this.mBitmapHeight;
                    float w = (float)this.mBitmapWidth * s;
                    if (this.getLayoutWidth() == w) break;
                    this.setStyleWidth(w);
                    break;
                }
            }
        }
    }

    private void setStyleHeight(final float height) {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (FrescoImageComponent.this.getInstance() != null) {
                    WXBridgeManager.getInstance().setStyleHeight(FrescoImageComponent.this.getInstanceId(), FrescoImageComponent.this.getRef(), height);
                }
            }
        });
    }

    private void setStyleWidth(final float width) {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (FrescoImageComponent.this.getInstance() != null) {
                    WXBridgeManager.getInstance().setStyleWidth(FrescoImageComponent.this.getInstanceId(), FrescoImageComponent.this.getRef(), width);
                }
            }
        });
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        if (this.getHostView() != null) {
            super.updateProperties(props);
            this.updateBorderRadius();
        }
    }

    private void updateBorderRadius() {
        float[] borderRadius;
        BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(this.getHostView());
        RoundingParams roundingParams = new RoundingParams();
        if (borderDrawable != null) {
            RectF borderBox = new RectF(0.0f, 0.0f, WXDomUtils.getContentWidth(this), WXDomUtils.getContentHeight(this));
            borderRadius = borderDrawable.getBorderInnerRadius(borderBox);
        } else {
            borderRadius = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        }
        roundingParams.setCornersRadii(borderRadius);
        ((DCGenericDraweeHierarchy)((FrescoImageView)this.getHostView()).getHierarchy()).setRoundingParams(roundingParams);
    }

    public class CustomScaleType
    implements ScalingUtils.ScaleType {
        private float dxf;
        private float dyf;

        public CustomScaleType(float dxf, float dyf) {
            this.dxf = dxf;
            this.dyf = dyf;
        }

        public Matrix getTransform(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY) {
            float scale = WXViewUtils.getRealPxByWidth((float)childWidth, FrescoImageComponent.this.getInstance().getInstanceViewPortWidthWithFloat()) / (float)childWidth;
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * this.dxf;
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * this.dyf;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate(dx, dy);
            return outTransform;
        }
    }
}

