/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_text;

import android.content.Context;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.richtext.WXRichTextView;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import io.dcloud.feature.weex_text.DCTextContentBoxMeasurement;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class DCWXRichText
extends WXText {
    public DCWXRichText(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.setContentBoxMeasurement(new RichTextContentBoxMeasurement(this));
    }

    @Override
    protected WXRichTextView initComponentHostView(@NonNull Context context) {
        return new WXRichTextView(context);
    }

    @Override
    public void updateAttrs(Map<String, Object> attrs) {
        super.updateAttrs(attrs);
        if (attrs.containsKey("value")) {
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    if (DCWXRichText.this.contentBoxMeasurement instanceof RichTextContentBoxMeasurement) {
                        ((RichTextContentBoxMeasurement)DCWXRichText.this.contentBoxMeasurement).forceRelayout();
                    }
                }
            });
        }
    }

    @Override
    public void updateExtra(Object extra) {
        super.updateExtra(extra);
        if (extra instanceof Layout) {
            Layout layout2 = (Layout)extra;
            if (!this.getStyles().containsKey("height")) {
                WXBridgeManager.getInstance().setStyleHeight(this.getInstanceId(), this.getRef(), layout2.getHeight());
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new DCWXRichText(instance, parent, basicComponentData);
        }
    }

    static class RichTextContentBoxMeasurement
    extends DCTextContentBoxMeasurement {
        public RichTextContentBoxMeasurement(WXComponent component) {
            super(component);
        }

        @Override
        @NonNull
        protected Spanned createSpanned(String text) {
            if (this.mComponent.getInstance() != null & this.mComponent.getInstance().getUIContext() != null && !TextUtils.isEmpty((CharSequence)this.mComponent.getInstanceId())) {
                Spannable spannable = RichTextNode.parse(this.mComponent.getInstance().getUIContext(), this.mComponent.getInstanceId(), this.mComponent.getRef(), text);
                this.updateSpannable(spannable, RichTextNode.createSpanFlag(0));
                return spannable;
            }
            return new SpannedString((CharSequence)"");
        }
    }
}

