/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.annotation.SuppressLint;
import android.opengl.EGL14;
import android.os.Looper;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.nio.ByteBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

@JNINamespace(value="liteav")
public class NativePixelFrameToLiveObjectConverter {
    @CalledByNative
    public static ByteBuffer createByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static Object getCurrentContext() {
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 17) {
            return EGL14.eglGetCurrentContext();
        }
        return ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
    }

    @CalledByNative
    public static boolean isInUIThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }
}

