/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.richmedia.async;

import android.content.Context;
import com.tencent.thumbplayer.core.common.TPFieldCalledByNative;
import com.tencent.thumbplayer.core.common.TPNativeLibraryLoader;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.richmedia.TPNativeRichMediaFeature;
import com.tencent.thumbplayer.core.richmedia.TPNativeTimeRange;
import com.tencent.thumbplayer.core.richmedia.async.ITPNativeRichMediaAsyncRequester;
import com.tencent.thumbplayer.core.richmedia.async.ITPNativeRichMediaAsyncRequesterListener;

public class TPNativeRichMediaAsyncRequester
implements ITPNativeRichMediaAsyncRequester {
    private static final int REQUEST_ID_NATIVE_EXCEPTION_THROW = -100;
    @TPFieldCalledByNative
    private long mNativeContext = 0L;

    private native int _nativeSetup();

    private native void _setRequesterListener(ITPNativeRichMediaAsyncRequesterListener var1);

    private native int _setRichMediaSource(String var1);

    private native int _prepareAsync();

    private native TPNativeRichMediaFeature[] _getFeatures();

    private native int _requestFeatureDataAsyncAtTimeMs(int var1, long var2);

    private native int _requestFeatureDataAsyncAtTimeMsArray(int var1, long[] var2);

    private native int _requestFeatureDataAsyncAtTimeRange(int var1, TPNativeTimeRange var2);

    private native int _requestFeatureDataAsyncAtTimeRanges(int var1, TPNativeTimeRange[] var2);

    private native void _cancelRequest(int var1);

    private native void _release();

    public TPNativeRichMediaAsyncRequester(Context context) {
        TPNativeLibraryLoader.loadLibIfNeeded(context);
        try {
            if (this._nativeSetup() != 0) {
                throw new UnsupportedOperationException("failed to setup rich media");
            }
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, "Failed to create native rich media:" + throwable.getMessage());
            throw new UnsupportedOperationException("failed to create rich media");
        }
    }

    @Override
    public void setRequesterListener(ITPNativeRichMediaAsyncRequesterListener iTPNativeRichMediaAsyncRequesterListener) {
        try {
            this._setRequesterListener(iTPNativeRichMediaAsyncRequesterListener);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return;
        }
    }

    @Override
    public void setRichMediaSource(String string) {
        int n2;
        try {
            n2 = this._setRichMediaSource(string);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            n2 = 1000001;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 == 1000012) {
            throw new IllegalArgumentException("setRichMediaSource\uff0cinvalid argument, url=".concat(String.valueOf(string)));
        }
        throw new IllegalStateException("setRichMediaSource:".concat(String.valueOf(n2)));
    }

    @Override
    public void prepareAsync() {
        int n2;
        try {
            n2 = this._prepareAsync();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            n2 = 1000001;
        }
        if (n2 != 0) {
            throw new IllegalStateException("prepareAsync, ret=".concat(String.valueOf(n2)));
        }
    }

    @Override
    public TPNativeRichMediaFeature[] getFeatures() {
        try {
            return this._getFeatures();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return new TPNativeRichMediaFeature[0];
        }
    }

    @Override
    public int requestFeatureDataAsyncAtTimeMs(int n2, long l2) {
        int n3;
        try {
            n3 = this._requestFeatureDataAsyncAtTimeMs(n2, l2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return -100;
        }
        return n3;
    }

    @Override
    public int requestFeatureDataAsyncAtTimeMsArray(int n2, long[] lArray) {
        int n3;
        try {
            n3 = this._requestFeatureDataAsyncAtTimeMsArray(n2, lArray);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return -100;
        }
        return n3;
    }

    @Override
    public int requestFeatureDataAsyncAtTimeRange(int n2, TPNativeTimeRange tPNativeTimeRange) {
        int n3;
        try {
            n3 = this._requestFeatureDataAsyncAtTimeRange(n2, tPNativeTimeRange);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            n3 = -100;
        }
        return n3;
    }

    @Override
    public int requestFeatureDataAsyncAtTimeRanges(int n2, TPNativeTimeRange[] tPNativeTimeRangeArray) {
        int n3;
        try {
            n3 = this._requestFeatureDataAsyncAtTimeRanges(n2, tPNativeTimeRangeArray);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return -100;
        }
        return n3;
    }

    @Override
    public void cancelRequest(int n2) {
        try {
            this._cancelRequest(n2);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return;
        }
    }

    @Override
    public void release() {
        try {
            this._release();
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return;
        }
    }
}

