/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.opengl.GLES20;
import com.tencent.liteav.beauty.b.n;
import com.tencent.liteav.videobase.frame.e;

public class UGCWatermarkFilter
extends n {
    private static final String WATERMARK_ALPHA_FRAG = "  varying highp vec2 textureCoordinate;\n  uniform sampler2D inputImageTexture;\n  uniform highp float alphaBlend;\n  \n  void main()\n  {\n      highp vec4 color = texture2D(inputImageTexture, textureCoordinate);\n      highp float alpha = color.a * alphaBlend;\n      gl_FragColor = vec4(color.rgb * alphaBlend,alpha);\n  }\n";
    private int mAlphaUniform = 1;
    private float mWaterMarkAlpha = 1.0f;

    public UGCWatermarkFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", WATERMARK_ALPHA_FRAG);
    }

    @Override
    public void onInit(e texturePool) {
        this.mAlphaUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"alphaBlend");
        this.mSrcBlendMode = 1;
    }

    public void setAlpha(float alpha) {
        this.mWaterMarkAlpha = alpha;
    }

    @Override
    public void beforeDrawArrays(int textureId) {
        super.beforeDrawArrays(textureId);
        GLES20.glUniform1f((int)this.mAlphaUniform, (float)1.0f);
    }

    @Override
    public void afterDrawArrays() {
        GLES20.glUniform1f((int)this.mAlphaUniform, (float)this.mWaterMarkAlpha);
        super.afterDrawArrays();
    }
}

