/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.PeerConnection;
import cn.rongcloud.rtc.core.SdpObserver;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.utils.ReportUtil;

public class RTCRemoteSdpObserver
implements SdpObserver {
    private SdpSetRemoteListener listener;
    private PeerConnection rongRTCConnection;
    private SessionDescription sessionDescription;

    public RTCRemoteSdpObserver(SessionDescription sessionDescription, SdpSetRemoteListener listener) {
        this.listener = listener;
        this.sessionDescription = sessionDescription;
    }

    @Override
    public void onCreateSuccess(SessionDescription sdp) {
    }

    @Override
    public void onSetSuccess() {
        ReportUtil.libRes(ReportUtil.TAG.SETREMOTESDP, "code", 0);
        if (this.listener != null) {
            this.listener.onRemoteSdpSetSuccess();
        }
    }

    @Override
    public void onCreateFailure(String error) {
    }

    @Override
    public void onSetFailure(String error) {
        ReportUtil.libError(ReportUtil.TAG.SETREMOTESDP, "code|errorMsg|sdp", RTCErrorCode.RongRTCCodeSessionNegotiateSetRemoteError.getValue(), error, this.sessionDescription.toJsonString());
        if (this.listener != null) {
            this.listener.onRemoteSetError(error);
        }
    }

    public static interface SdpSetRemoteListener {
        public void onRemoteSdpSetSuccess();

        public void onRemoteSetError(String var1);
    }
}

