/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.DraweeView;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.WXImageQuality;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeHierarchy;
import io.dcloud.feature.weex.adapter.FrescoImageView;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Executor;

public class FrescoImageAdapter
implements IWXImgLoaderAdapter {
    @Override
    public void setImage(final String url, final ImageView view, final WXImageQuality quality, final WXImageStrategy strategy) {
        if (PdrUtil.isEmpty((Object)url)) {
            if (view != null) {
                view.setImageBitmap(null);
            }
            return;
        }
        if (strategy != null && strategy.placeHolder != null) {
            ThreadPool.self().addThreadTask(new Runnable(){

                @Override
                public void run() {
                    Logger.d((String)"FrescoImage", (String)("Thread_setImage--" + url));
                    Bitmap x = null;
                    try {
                        if (strategy.placeHolder.startsWith("file")) {
                            x = BitmapFactory.decodeFile((String)strategy.placeHolder.replaceFirst("file://", ""));
                        } else {
                            HttpURLConnection connection = (HttpURLConnection)new URL(strategy.placeHolder).openConnection();
                            connection.connect();
                            InputStream input = connection.getInputStream();
                            x = BitmapFactory.decodeStream((InputStream)input);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    BitmapDrawable placeholderDrawable = new BitmapDrawable(x);
                    WXSDKManager.getInstance().postOnUiThread(new Runnable((Drawable)placeholderDrawable){
                        final /* synthetic */ Drawable val$placeholderDrawable;
                        {
                            this.val$placeholderDrawable = drawable2;
                        }

                        @Override
                        public void run() {
                            FrescoImageAdapter.setImage(url, view, quality, strategy, this.val$placeholderDrawable);
                        }
                    }, 0L);
                }
            }, true);
        } else {
            WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FrescoImageAdapter.setImage(url, view, quality, strategy, null);
                }
            }, 0L);
        }
    }

    private static void setImage(final String url, final ImageView view, WXImageQuality quality, final WXImageStrategy strategy, Drawable placeholderDrawable) {
        if (view == null || view.getLayoutParams() == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            view.setImageBitmap(null);
            return;
        }
        String temp = url;
        if (url.startsWith("//")) {
            temp = "http:" + url;
        }
        Uri uri = Uri.parse((String)temp);
        ImageDecodeOptions decodeOptions = ImageDecodeOptions.newBuilder().build();
        ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setImageDecodeOptions(decodeOptions).setAutoRotateEnabled(true).setLocalThumbnailPreviewsEnabled(true).setLowestPermittedRequestLevel(ImageRequest.RequestLevel.FULL_FETCH).setProgressiveRenderingEnabled(false);
        if (!strategy.isAutoCompression()) {
            builder.setResizeOptions(new ResizeOptions(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }
        ImageRequest request = builder.build();
        if (view instanceof DraweeView) {
            BaseControllerListener<ImageInfo> controllerListener = new BaseControllerListener<ImageInfo>(){

                public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
                    if (imageInfo == null) {
                        return;
                    }
                    if (strategy != null && strategy.getImageListener() != null) {
                        HashMap<String, Integer> sizeMap = new HashMap<String, Integer>();
                        sizeMap.put("width", imageInfo.getWidth());
                        sizeMap.put("height", imageInfo.getHeight());
                        if (imageInfo.getWidth() > 0) {
                            strategy.getImageListener().onImageFinish(url, view, true, sizeMap);
                        } else {
                            strategy.getImageListener().onImageFinish(url, view, false, sizeMap);
                        }
                    }
                }

                public void onIntermediateImageSet(String id2, @Nullable ImageInfo imageInfo) {
                    FLog.d((String)"", (String)"Intermediate image received");
                }

                public void onFailure(String id2, Throwable throwable) {
                    FLog.e(((Object)((Object)this)).getClass(), (Throwable)throwable, (String)"Error loading %s", (Object[])new Object[]{id2});
                    if (strategy != null && strategy.getImageListener() != null) {
                        strategy.getImageListener().onImageFinish(url, view, false, null);
                    }
                }
            };
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setAutoPlayAnimations(true)).setControllerListener((ControllerListener)controllerListener)).setImageRequest((Object)request)).build();
            if (placeholderDrawable != null) {
                ((DCGenericDraweeHierarchy)((FrescoImageView)view).getHierarchy()).setPlaceholderImage(placeholderDrawable);
            }
            ((DraweeView)view).setController((DraweeController)controller);
        } else {
            ImagePipeline imagePipeline = Fresco.getImagePipeline();
            DataSource dataSource = imagePipeline.fetchDecodedImage(request, new Object());
            BaseDataSubscriber<CloseableReference<CloseableImage>> dataSubscriber = new BaseDataSubscriber<CloseableReference<CloseableImage>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNewResultImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                    CloseableReference imageReference = (CloseableReference)dataSource.getResult();
                    if (imageReference != null) {
                        try {
                            Preconditions.checkState((boolean)CloseableReference.isValid((CloseableReference)imageReference));
                            CloseableImage closeableImage = (CloseableImage)imageReference.get();
                            if (closeableImage instanceof CloseableStaticBitmap) {
                                CloseableStaticBitmap closeableStaticBitmap = (CloseableStaticBitmap)closeableImage;
                                view.setImageBitmap(closeableStaticBitmap.getUnderlyingBitmap());
                            }
                            if (strategy != null && strategy.getImageListener() != null) {
                                strategy.getImageListener().onImageFinish(url, view, true, null);
                            }
                        }
                        finally {
                            imageReference.close();
                        }
                    }
                }

                public void onFailureImpl(DataSource dataSource) {
                    if (strategy != null && strategy.getImageListener() != null) {
                        strategy.getImageListener().onImageFinish(url, view, false, null);
                    }
                }
            };
            dataSource.subscribe((DataSubscriber)dataSubscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
        }
    }
}

