/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;

public class SqliteDatabaseOpenHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "filedownloader.db";
    private static final int DATABASE_VERSION = 4;

    public SqliteDatabaseOpenHelper(Context context) {
        super(context, DATABASE_NAME, null, 4);
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setWriteAheadLoggingEnabled(true);
        } else if (Build.VERSION.SDK_INT >= 11) {
            db.enableWriteAheadLogging();
        }
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS filedownloader( _id INTEGER PRIMARY KEY, url VARCHAR, path VARCHAR, status TINYINT(7), sofar INTEGER, total INTEGER, errMsg VARCHAR, etag VARCHAR, pathAsDirectory TINYINT(1) DEFAULT 0, filename VARCHAR, connectionCount INTEGER DEFAULT 1)");
        db.execSQL("CREATE TABLE IF NOT EXISTS filedownloaderConnection( id INTEGER, connectionIndex INTEGER, startOffset INTEGER, currentOffset INTEGER, endOffset INTEGER, PRIMARY KEY ( id, connectionIndex ))");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 2) {
            String addAsDirectoryColumn = "ALTER TABLE filedownloader ADD COLUMN pathAsDirectory TINYINT(1) DEFAULT 0";
            db.execSQL(addAsDirectoryColumn);
            String addFilenameColumn = "ALTER TABLE filedownloader ADD COLUMN filename VARCHAR";
            db.execSQL(addFilenameColumn);
        }
        if (oldVersion < 3) {
            String addConnectionCount = "ALTER TABLE filedownloader ADD COLUMN connectionCount INTEGER DEFAULT 1";
            db.execSQL("ALTER TABLE filedownloader ADD COLUMN connectionCount INTEGER DEFAULT 1");
            db.execSQL("CREATE TABLE IF NOT EXISTS filedownloaderConnection( id INTEGER, connectionIndex INTEGER, startOffset INTEGER, currentOffset INTEGER, endOffset INTEGER, PRIMARY KEY ( id, connectionIndex ))");
        }
        if (oldVersion < 4) {
            ContentValues values = new ContentValues();
            values.put("endOffset", Integer.valueOf(-1));
            String whereClause = "endOffset = ? AND startOffset > ?";
            db.update("filedownloaderConnection", values, whereClause, new String[]{"0", "0"});
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.delete("filedownloader", null, null);
        db.delete("filedownloaderConnection", null, null);
    }
}

