/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.feature.uniapp.adapter.UniImageLoadAdapter;
import io.dcloud.feature.uniapp.utils.bitmap.BitmapLoadCallback;
import java.lang.ref.SoftReference;
import java.util.concurrent.Executor;

public class FrescoLoadUtil
implements UniImageLoadAdapter {
    private static FrescoLoadUtil inst;
    Handler mHandler = new Handler(Looper.getMainLooper());

    public static UniImageLoadAdapter getInstance() {
        if (inst == null) {
            inst = new FrescoLoadUtil();
        }
        return inst;
    }

    @Override
    public final void loadImageBitmap(Context context, String url, BitmapLoadCallback<Bitmap> call) {
        this.loadImageBitmap(context, url, 0, 0, call);
    }

    @Override
    public final void loadImageBitmap(Context context, String url, int width, int height, BitmapLoadCallback<Bitmap> call) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        String temp = url;
        if (url.startsWith("//")) {
            temp = "http:" + url;
        }
        try {
            this.fetch(context, Uri.parse((String)temp), width, height, call);
        }
        catch (Exception e) {
            e.printStackTrace();
            call.onFailure(url, e);
        }
    }

    private void fetch(final Context context, final Uri uri, final int newWidth, final int newHeight, final BitmapLoadCallback<Bitmap> callback) {
        ThreadPool.self().addThreadTask(new Runnable(){

            @Override
            public void run() {
                ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setProgressiveRenderingEnabled(false);
                builder.setPostprocessor(new Postprocessor(){

                    public CloseableReference<Bitmap> process(Bitmap sourceBitmap, PlatformBitmapFactory bitmapFactory) {
                        if (newHeight > 0 && newHeight > 0) {
                            int sw = sourceBitmap.getWidth();
                            int sh = sourceBitmap.getHeight();
                            Matrix matrix = new Matrix();
                            float scaleWidth = (float)newWidth / (float)sw;
                            float scaleHeight = (float)newHeight / (float)sh;
                            matrix.postScale(scaleWidth, scaleHeight);
                            return bitmapFactory.createBitmap(sourceBitmap, 0, 0, sw, sh, matrix, true);
                        }
                        return bitmapFactory.createBitmap(sourceBitmap);
                    }

                    public String getName() {
                        return null;
                    }

                    public CacheKey getPostprocessorCacheKey() {
                        return null;
                    }
                });
                ImageRequest imageRequest = builder.build();
                ImagePipeline imagePipeline = Fresco.getImagePipeline();
                DataSource dataSource = imagePipeline.fetchDecodedImage(imageRequest, (Object)context);
                BaseDataSubscriber<CloseableReference<CloseableImage>> dataSubscriber = new BaseDataSubscriber<CloseableReference<CloseableImage>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void onNewResultImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                        if (!dataSource.isFinished()) {
                            return;
                        }
                        CloseableReference closeableReference = (CloseableReference)dataSource.getResult();
                        if (closeableReference == null) {
                            return;
                        }
                        try {
                            Bitmap bitmap = null;
                            if (closeableReference.get() instanceof CloseableBitmap) {
                                CloseableBitmap closeableBitmap = (CloseableBitmap)closeableReference.get();
                                bitmap = closeableBitmap.getUnderlyingBitmap();
                            }
                            if (bitmap != null && !bitmap.isRecycled()) {
                                SoftReference<Bitmap> copyBitmap = new SoftReference<Bitmap>(Bitmap.createBitmap((Bitmap)bitmap));
                                if (callback != null) {
                                    callback.onSuccess(uri.toString(), copyBitmap.get());
                                }
                            }
                        }
                        finally {
                            closeableReference.close();
                            dataSource.close();
                        }
                    }

                    protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                        if (callback != null) {
                            callback.onSuccess(uri.toString(), null);
                        }
                    }
                };
                dataSource.subscribe((DataSubscriber)dataSubscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
            }
        }, true);
    }
}

