/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.probe;

import cn.rongcloud.rtc.base.RCRTCParamsType;

public class RTCProbeConfig {
    private int maxRate = -1;
    private int minRate = -1;
    private RCRTCParamsType.RCRTCVideoResolution videoResolution = RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_480_640;
    private RCRTCParamsType.RCRTCVideoFps videoFps = RCRTCParamsType.RCRTCVideoFps.Fps_15;

    public RTCProbeConfig() {
        this.maxRate = this.videoResolution.getMaxBitRate();
        this.minRate = this.videoResolution.getMinBitRate();
    }

    public RTCProbeConfig(RCRTCParamsType.RCRTCVideoResolution videoResolution, RCRTCParamsType.RCRTCVideoFps videoFps, int minRate, int maxRate) {
        this.videoResolution = videoResolution;
        this.maxRate = maxRate;
        this.minRate = minRate;
        this.videoFps = videoFps;
    }

    public int getWidth() {
        return this.videoResolution.getWidth();
    }

    public int getHeight() {
        return this.videoResolution.getHeight();
    }

    public int getMaxBitRate() {
        return (int)((float)this.maxRate * this.videoFps.getMultiplier());
    }

    public int getMinBitRate() {
        return (int)((float)this.minRate * this.videoFps.getMultiplier());
    }

    public String toString() {
        return "{maxRate=" + this.maxRate + ", minRate=" + this.minRate + ", videoResolution=" + (Object)((Object)this.videoResolution) + ", videoFps=" + (Object)((Object)this.videoFps) + '}';
    }

    public RCRTCParamsType.RCRTCVideoFps getVideoFps() {
        return this.videoFps;
    }
}

