/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.daasuu.mp4compose.FillMode;
import com.daasuu.mp4compose.FillModeCustomItem;
import com.daasuu.mp4compose.Rotation;
import com.daasuu.mp4compose.filter.GlFilter;
import com.daasuu.mp4compose.gl.GlFramebufferObject;
import com.daasuu.mp4compose.gl.GlPreviewFilter;
import com.daasuu.mp4compose.gl.GlSurfaceTexture;
import com.daasuu.mp4compose.logger.Logger;
import com.daasuu.mp4compose.utils.EglUtil;

class DecoderSurface
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "DecoderSurface";
    private static final boolean VERBOSE = false;
    private EGLDisplay eglDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext eglContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;
    private Surface surface;
    private Object frameSyncObject = new Object();
    private boolean frameAvailable;
    private GlFilter filter;
    private int texName;
    private GlSurfaceTexture previewTexture;
    private GlFramebufferObject filterFramebufferObject;
    private GlPreviewFilter previewShader;
    private GlFilter normalShader;
    private GlFramebufferObject framebufferObject;
    private float[] MVPMatrix = new float[16];
    private float[] ProjMatrix = new float[16];
    private float[] MMatrix = new float[16];
    private float[] VMatrix = new float[16];
    private float[] STMatrix = new float[16];
    private Rotation rotation = Rotation.NORMAL;
    private Size outputResolution;
    private Size inputResolution;
    private FillMode fillMode = FillMode.PRESERVE_ASPECT_FIT;
    private FillModeCustomItem fillModeCustomItem;
    private boolean flipVertical = false;
    private boolean flipHorizontal = false;
    private final Logger logger;

    DecoderSurface(@NonNull GlFilter filter, @NonNull Logger logger) {
        this.filter = filter;
        this.logger = logger;
        this.setup();
    }

    private void setup() {
        this.filter.setup();
        this.framebufferObject = new GlFramebufferObject();
        this.normalShader = new GlFilter();
        this.normalShader.setup();
        int[] args = new int[1];
        GLES20.glGenTextures((int)args.length, (int[])args, (int)0);
        this.texName = args[0];
        this.previewTexture = new GlSurfaceTexture(this.texName);
        this.previewTexture.setOnFrameAvailableListener(this);
        this.surface = new Surface(this.previewTexture.getSurfaceTexture());
        GLES20.glBindTexture((int)this.previewTexture.getTextureTarget(), (int)this.texName);
        EglUtil.setupSampler(this.previewTexture.getTextureTarget(), 9729, 9728);
        GLES20.glBindTexture((int)3553, (int)0);
        this.previewShader = new GlPreviewFilter(this.previewTexture.getTextureTarget());
        this.previewShader.setup();
        this.filterFramebufferObject = new GlFramebufferObject();
        Matrix.setLookAtM((float[])this.VMatrix, (int)0, (float)0.0f, (float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GLES20.glGetIntegerv((int)3379, (int[])args, (int)0);
    }

    void release() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
        }
        this.surface.release();
        this.previewTexture.release();
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglSurface = EGL14.EGL_NO_SURFACE;
        this.filter.release();
        this.filter = null;
        this.surface = null;
        this.previewTexture = null;
    }

    Surface getSurface() {
        return this.surface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitNewImage() {
        int TIMEOUT_MS = 10000;
        Object object = this.frameSyncObject;
        synchronized (object) {
            while (!this.frameAvailable) {
                try {
                    this.frameSyncObject.wait(10000L);
                    if (this.frameAvailable) continue;
                    throw new RuntimeException("Surface frame wait timed out");
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
            this.frameAvailable = false;
        }
        this.previewTexture.updateTexImage();
        this.previewTexture.getTransformMatrix(this.STMatrix);
    }

    void drawImage() {
        this.framebufferObject.enable();
        GLES20.glViewport((int)0, (int)0, (int)this.framebufferObject.getWidth(), (int)this.framebufferObject.getHeight());
        if (this.filter != null) {
            this.filterFramebufferObject.enable();
            GLES20.glViewport((int)0, (int)0, (int)this.filterFramebufferObject.getWidth(), (int)this.filterFramebufferObject.getHeight());
            GLES20.glClearColor((float)this.filter.getClearColor()[0], (float)this.filter.getClearColor()[1], (float)this.filter.getClearColor()[2], (float)this.filter.getClearColor()[3]);
        }
        GLES20.glClear((int)16384);
        Matrix.multiplyMM((float[])this.MVPMatrix, (int)0, (float[])this.VMatrix, (int)0, (float[])this.MMatrix, (int)0);
        Matrix.multiplyMM((float[])this.MVPMatrix, (int)0, (float[])this.ProjMatrix, (int)0, (float[])this.MVPMatrix, (int)0);
        float scaleDirectionX = this.flipHorizontal ? -1.0f : 1.0f;
        float scaleDirectionY = this.flipVertical ? -1.0f : 1.0f;
        switch (this.fillMode) {
            case PRESERVE_ASPECT_FIT: {
                float[] scale = FillMode.getScaleAspectFit(this.rotation.getRotation(), this.inputResolution.getWidth(), this.inputResolution.getHeight(), this.outputResolution.getWidth(), this.outputResolution.getHeight());
                Matrix.scaleM((float[])this.MVPMatrix, (int)0, (float)(scale[0] * scaleDirectionX), (float)(scale[1] * scaleDirectionY), (float)1.0f);
                if (this.rotation == Rotation.NORMAL) break;
                Matrix.rotateM((float[])this.MVPMatrix, (int)0, (float)(-this.rotation.getRotation()), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case PRESERVE_ASPECT_CROP: {
                float[] scale = FillMode.getScaleAspectCrop(this.rotation.getRotation(), this.inputResolution.getWidth(), this.inputResolution.getHeight(), this.outputResolution.getWidth(), this.outputResolution.getHeight());
                Matrix.scaleM((float[])this.MVPMatrix, (int)0, (float)(scale[0] * scaleDirectionX), (float)(scale[1] * scaleDirectionY), (float)1.0f);
                if (this.rotation == Rotation.NORMAL) break;
                Matrix.rotateM((float[])this.MVPMatrix, (int)0, (float)(-this.rotation.getRotation()), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case CUSTOM: {
                if (this.fillModeCustomItem == null) break;
                Matrix.translateM((float[])this.MVPMatrix, (int)0, (float)this.fillModeCustomItem.getTranslateX(), (float)(-this.fillModeCustomItem.getTranslateY()), (float)0.0f);
                float[] scale = FillMode.getScaleAspectCrop(this.rotation.getRotation(), this.inputResolution.getWidth(), this.inputResolution.getHeight(), this.outputResolution.getWidth(), this.outputResolution.getHeight());
                if (this.fillModeCustomItem.getRotate() == 0.0f || this.fillModeCustomItem.getRotate() == 180.0f) {
                    Matrix.scaleM((float[])this.MVPMatrix, (int)0, (float)(this.fillModeCustomItem.getScale() * scale[0] * scaleDirectionX), (float)(this.fillModeCustomItem.getScale() * scale[1] * scaleDirectionY), (float)1.0f);
                } else {
                    Matrix.scaleM((float[])this.MVPMatrix, (int)0, (float)(this.fillModeCustomItem.getScale() * scale[0] * (1.0f / this.fillModeCustomItem.getVideoWidth() * this.fillModeCustomItem.getVideoHeight()) * scaleDirectionX), (float)(this.fillModeCustomItem.getScale() * scale[1] * (this.fillModeCustomItem.getVideoWidth() / this.fillModeCustomItem.getVideoHeight()) * scaleDirectionY), (float)1.0f);
                }
                Matrix.rotateM((float[])this.MVPMatrix, (int)0, (float)(-((float)this.rotation.getRotation() + this.fillModeCustomItem.getRotate())), (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        this.previewShader.draw(this.texName, this.MVPMatrix, this.STMatrix, 1.0f);
        if (this.filter != null) {
            this.framebufferObject.enable();
            GLES20.glClear((int)16384);
            this.filter.draw(this.filterFramebufferObject.getTexName(), this.framebufferObject);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.framebufferObject.getWidth(), (int)this.framebufferObject.getHeight());
        GLES20.glClear((int)16640);
        this.normalShader.draw(this.framebufferObject.getTexName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture st) {
        Object object = this.frameSyncObject;
        synchronized (object) {
            if (this.frameAvailable) {
                throw new RuntimeException("frameAvailable already set, frame could be dropped");
            }
            this.frameAvailable = true;
            this.frameSyncObject.notifyAll();
        }
    }

    void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    void setOutputResolution(Size resolution) {
        this.outputResolution = resolution;
    }

    void setFillMode(FillMode fillMode) {
        this.fillMode = fillMode;
    }

    void setInputResolution(Size resolution) {
        this.inputResolution = resolution;
    }

    void setFillModeCustomItem(FillModeCustomItem fillModeCustomItem) {
        this.fillModeCustomItem = fillModeCustomItem;
    }

    void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
    }

    void completeParams() {
        int width = this.outputResolution.getWidth();
        int height = this.outputResolution.getHeight();
        this.framebufferObject.setup(width, height);
        this.normalShader.setFrameSize(width, height);
        this.filterFramebufferObject.setup(width, height);
        this.previewShader.setFrameSize(width, height);
        Matrix.frustumM((float[])this.ProjMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)5.0f, (float)7.0f);
        Matrix.setIdentityM((float[])this.MMatrix, (int)0);
        if (this.filter != null) {
            this.filter.setFrameSize(width, height);
        }
    }
}

