/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.util;

import java.util.ArrayList;
import java.util.List;

public class XmlWriter {
    private List<String> tag = new ArrayList<String>();
    private StringBuffer buffer = new StringBuffer();

    public XmlWriter start(String nodeName) {
        this.buffer.append("<" + nodeName + ">");
        this.tag.add(nodeName);
        return this;
    }

    public XmlWriter start(String nodeName, String param, String value) {
        this.buffer.append("<" + nodeName + " " + param + "=\"" + value + "\">");
        this.tag.add(nodeName);
        return this;
    }

    public XmlWriter start(String nodeName, String[] params, String[] values) {
        if (params.length != values.length) {
            throw new IllegalArgumentException("params.length should be equals with values.length");
        }
        this.buffer.append("<" + nodeName + " ");
        for (int i = 0; i < params.length; ++i) {
            this.buffer.append(params[i] + "=\"" + values[i] + "\" ");
        }
        this.buffer.append(">");
        this.tag.add(nodeName);
        return this;
    }

    public XmlWriter startWithNs(String nodeName) {
        return this.start(nodeName, "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
    }

    public XmlWriter end() {
        this.buffer.append("</" + this.tag.get(this.tag.size() - 1) + ">");
        this.tag.remove(this.tag.size() - 1);
        return this;
    }

    public XmlWriter value(String value) {
        this.appendEscapedString(value, this.buffer);
        return this;
    }

    public XmlWriter value(int value) {
        this.appendEscapedString(String.valueOf(value), this.buffer);
        return this;
    }

    public String toString() {
        String xml = this.buffer.toString();
        return xml;
    }

    private void appendEscapedString(String s, StringBuffer builder) {
        int pos;
        if (s == null) {
            s = "";
        }
        int start = 0;
        int len = s.length();
        for (pos = 0; pos < len; ++pos) {
            String escape;
            char ch = s.charAt(pos);
            switch (ch) {
                case '\t': {
                    escape = "&#9;";
                    break;
                }
                case '\n': {
                    escape = "&#10;";
                    break;
                }
                case '\r': {
                    escape = "&#13;";
                    break;
                }
                case '&': {
                    escape = "&amp;";
                    break;
                }
                case '\"': {
                    escape = "&quot;";
                    break;
                }
                case '<': {
                    escape = "&lt;";
                    break;
                }
                case '>': {
                    escape = "&gt;";
                    break;
                }
                default: {
                    escape = null;
                }
            }
            if (escape == null) continue;
            if (start < pos) {
                builder.append(s, start, pos);
            }
            this.buffer.append(escape);
            start = pos + 1;
        }
        if (start < pos) {
            this.buffer.append(s, start, pos);
        }
    }
}

