/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request.common;

import com.ksyun.ks3.auth.ValidateUtil;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.services.request.Ks3HttpRequest;
import com.ksyun.ks3.services.request.tag.ObjectTag;
import com.ksyun.ks3.services.request.tag.ObjectTagging;
import com.ksyun.ks3.util.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.util.StringUtils;
import com.ksyun.ks3.util.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Ks3HttpObjectRequest
extends Ks3HttpRequest {
    private ObjectTagging tagging;
    public Pattern TAG_PATTERN = Pattern.compile("^[\\w\\-+=.:/][\\w\\-+=.:/\\s]*(?<!\\s)$");

    public ObjectTagging getTagging() {
        return this.tagging;
    }

    public void setTagging(ObjectTagging tagging) {
        this.tagging = tagging;
    }

    @Override
    protected void setupRequest() throws Ks3ClientException {
    }

    protected void setTagHeader() {
        if (this.getTagging() != null && this.getTagging().getTagSet() != null && this.getTagging().getTagSet().size() > 0) {
            XmlWriter writer = new XmlWriter();
            writer.start("Tagging");
            writer.start("TagSet");
            List<ObjectTag> tags = this.getTagging().getTagSet();
            StringBuffer stringBuffer = new StringBuffer();
            for (ObjectTag tag : tags) {
                writer.start("Tag");
                writer.start("Key").value(tag.getKey()).end();
                if (tag.getValue() == null) continue;
                writer.start("Value").value(tag.getValue()).end();
                stringBuffer.append(tag.getKey() + "=" + tag.getValue() + "&");
            }
            if (stringBuffer.length() > 0) {
                String xKssObjectTagStr = stringBuffer.toString().substring(0, stringBuffer.toString().length() - 1);
                this.addHeader(HttpHeaders.XKssObjectTag, xKssObjectTagStr);
            }
        }
    }

    @Override
    protected void validateParams() throws Ks3ClientException {
        if (ValidateUtil.validateBucketName(this.getBucketname()) == null) {
            throw new Ks3ClientException("bucket name is not correct");
        }
        if (StringUtils.isBlank(this.getObjectkey())) {
            throw new Ks3ClientException("object can not be null");
        }
        if (this.getTagging() != null) {
            if (this.getTagging().getTagSet() == null || this.getTagging().getTagSet().size() == 0) {
                throw ClientIllegalArgumentExceptionGenerator.between("tagset", "0", "1", "10");
            }
            if (this.getTagging().getTagSet().size() > 10) {
                throw ClientIllegalArgumentExceptionGenerator.between("tagset", "" + this.getTagging().getTagSet().size(), "1", "10");
            }
            ArrayList<String> tagKeys = new ArrayList<String>();
            for (ObjectTag tag : this.getTagging().getTagSet()) {
                if (!this.TAG_PATTERN.matcher(tag.getKey()).matches()) {
                    throw ClientIllegalArgumentExceptionGenerator.notCorrect("key", tag.getKey(), "invalid key format");
                }
                if (tag.getValue() != null && !this.TAG_PATTERN.matcher(tag.getValue()).matches()) {
                    throw ClientIllegalArgumentExceptionGenerator.notCorrect("value", tag.getValue(), "invalid value format");
                }
                if (tag.getKey().getBytes().length > 128) {
                    throw ClientIllegalArgumentExceptionGenerator.notCorrect("key", tag.getKey(), "invalid length");
                }
                if (tag.getValue() != null && tag.getValue().getBytes().length > 256) {
                    throw ClientIllegalArgumentExceptionGenerator.notCorrect("value", tag.getValue(), "invalid length");
                }
                if (!tagKeys.contains(tag.getKey())) {
                    tagKeys.add(tag.getKey());
                    continue;
                }
                throw ClientIllegalArgumentExceptionGenerator.notCorrect("key", tag.getKey(), "duplicated tagging key");
            }
        }
    }
}

