/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.Fresco;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import androidx.annotation.DrawableRes;
import com.dcloud.android.annotation.Nullable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.util.UriUtil;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeView;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeHierarchy;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeHierarchyBuilder;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeHierarchyInflater;

public class DCGenericDraweeView
extends DraweeView<DCGenericDraweeHierarchy> {
    private static Supplier<? extends AbstractDraweeControllerBuilder> sDraweecontrollerbuildersupplier;
    private AbstractDraweeControllerBuilder mControllerBuilder;

    public static void initialize(Supplier<? extends AbstractDraweeControllerBuilder> draweeControllerBuilderSupplier) {
        sDraweecontrollerbuildersupplier = draweeControllerBuilderSupplier;
    }

    public static void shutDown() {
        sDraweecontrollerbuildersupplier = null;
    }

    public DCGenericDraweeView(Context context, DCGenericDraweeHierarchy hierarchy) {
        super(context);
        this.setHierarchy((DraweeHierarchy)hierarchy);
        this.init();
    }

    public DCGenericDraweeView(Context context) {
        super(context);
        this.inflateHierarchy(context, null);
        this.init();
    }

    public DCGenericDraweeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.inflateHierarchy(context, attrs);
        this.init();
    }

    public DCGenericDraweeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.inflateHierarchy(context, attrs);
        this.init();
    }

    @TargetApi(value=21)
    public DCGenericDraweeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.inflateHierarchy(context, attrs);
        this.init();
    }

    private void init() {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"SimpleDraweeView#init");
            }
            if (this.isInEditMode()) {
                this.getTopLevelDrawable().setVisible(true, false);
                this.getTopLevelDrawable().invalidateSelf();
            } else {
                Preconditions.checkNotNull(sDraweecontrollerbuildersupplier, (Object)"SimpleDraweeView was not initialized!");
                this.mControllerBuilder = (AbstractDraweeControllerBuilder)sDraweecontrollerbuildersupplier.get();
            }
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    protected void inflateHierarchy(Context context, @Nullable AttributeSet attrs) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"GenericDraweeView#inflateHierarchy");
        }
        DCGenericDraweeHierarchyBuilder builder = DCGenericDraweeHierarchyInflater.inflateBuilder(context, attrs);
        this.setAspectRatio(builder.getDesiredAspectRatio());
        this.setHierarchy((DraweeHierarchy)builder.build());
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    protected AbstractDraweeControllerBuilder getControllerBuilder() {
        return this.mControllerBuilder;
    }

    public void setImageRequest(ImageRequest request) {
        AbstractDraweeControllerBuilder controllerBuilder = this.mControllerBuilder;
        AbstractDraweeController controller = controllerBuilder.setImageRequest((Object)request).setOldController(this.getController()).build();
        this.setController((DraweeController)controller);
    }

    public void setImageURI(Uri uri) {
        this.setImageURI(uri, null);
    }

    public void setImageURI(@Nullable String uriString) {
        this.setImageURI(uriString, null);
    }

    public void setImageURI(Uri uri, @Nullable Object callerContext) {
        DraweeController controller = this.mControllerBuilder.setCallerContext(callerContext).setUri(uri).setOldController(this.getController()).build();
        this.setController(controller);
    }

    public void setImageURI(@Nullable String uriString, @Nullable Object callerContext) {
        Uri uri = uriString != null ? Uri.parse((String)uriString) : null;
        this.setImageURI(uri, callerContext);
    }

    public void setActualImageResource(@DrawableRes int resourceId) {
        this.setActualImageResource(resourceId, null);
    }

    public void setActualImageResource(@DrawableRes int resourceId, @Nullable Object callerContext) {
        this.setImageURI(UriUtil.getUriForResourceId((int)resourceId), callerContext);
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
    }
}

