/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module.ping;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCJoinType;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.IRoomIdChangeListener;
import cn.rongcloud.rtc.module.ping.CounterHeartBeat;
import cn.rongcloud.rtc.module.ping.IHeartBeatProcess;
import cn.rongcloud.rtc.module.ping.TimerHeartBeat;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.IRongCoreRTCCallback;
import io.rong.imlib.RongCoreClient;
import io.rong.imlib.model.RTCUser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class RTCPingManager
implements IRoomIdChangeListener {
    private static final String TAG = "RTCPingManager";
    protected static final String mImHeartbeatCallMethodName = "SetRTCHeartbeatListenerEx";
    private static final int MIN_FAILURE_NUMBER = 1;
    private static final int PING_PERIOD = 5000;
    protected int maxFailureNumber = 1;
    protected int maxForceConnectNumber = 1;
    protected int mOfflineKickTime = -1;
    private Timer pingTimer;
    private Context mContext;
    protected boolean mEnableAutoReconnect;
    protected String mMainRoomId;
    private Map<String, HeartbeatInfo> mRoomIdConcurrentHashMap = new ConcurrentHashMap<String, HeartbeatInfo>();
    private StringBuffer stringBuffer_PING = new StringBuffer();
    private String[] roomIdArray = null;
    private int roomIdArrayCount = 0;
    IHeartBeatProcess mHeartBeatProcess;

    public RTCPingManager(String roomId, Context context, boolean enableAutoReconnect, int offlineKickTime) {
        FinLog.d(TAG, "RTCPingManager :  roomId : " + roomId + " , enableAutoReconnect :" + enableAutoReconnect + " , offlineKickTime :" + offlineKickTime);
        this.mMainRoomId = roomId;
        this.mContext = context;
        this.mEnableAutoReconnect = enableAutoReconnect;
        this.mRoomIdConcurrentHashMap.clear();
        this.mRoomIdConcurrentHashMap.put(this.mMainRoomId, new HeartbeatInfo(0, 0));
        this.calculateMaxFailureNumber(offlineKickTime);
        this.startPing();
    }

    protected void forceConnect() {
        Class<?> clazz = RongCoreClient.getInstance().getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("forceReconnect", IRongCoreCallback.ConnectCallback.class);
            if (null != method) {
                method.setAccessible(true);
                method.invoke((Object)RongCoreClient.getInstance(), new IRongCoreCallback.ConnectCallback(){

                    public void onSuccess(String t) {
                    }

                    public void onError(IRongCoreEnum.ConnectionErrorCode e) {
                    }

                    public void onDatabaseOpened(IRongCoreEnum.DatabaseOpenStatus code) {
                    }
                });
                Logging.d(TAG, "forceReconnect");
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void calculateMaxFailureNumber(int offlineKickTime) {
        if (offlineKickTime == -1) {
            this.maxFailureNumber = 11;
            this.maxForceConnectNumber = 9;
            this.mOfflineKickTime = 60000;
        } else {
            this.maxFailureNumber = Math.max(offlineKickTime / 5 - 1, 1);
            this.maxForceConnectNumber = Math.max(offlineKickTime / 5 - 3, 1);
            this.mOfflineKickTime = offlineKickTime * 1000;
        }
    }

    private void startPing() {
        if (this.pingTimer == null) {
            this.pingTimer = new Timer();
        } else {
            this.pingTimer.cancel();
            this.pingTimer = new Timer();
        }
        Class<?> clazz = IMLibRTCClient.getInstance().getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(mImHeartbeatCallMethodName, Object.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.mHeartBeatProcess = null == method ? new CounterHeartBeat(this) : new TimerHeartBeat(this);
        this.pingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RTCPingManager.access$002(RTCPingManager.this, RTCPingManager.this.mRoomIdConcurrentHashMap.keySet().toArray(new String[RTCPingManager.this.mRoomIdConcurrentHashMap.keySet().size()]));
                RTCPingManager.this.roomIdArrayCount = RTCPingManager.this.roomIdArray.length;
                if (RTCPingManager.this.roomIdArray == null || RTCPingManager.this.roomIdArrayCount == 0) {
                    FinLog.e(RTCPingManager.TAG, "Room number is empty.");
                    return;
                }
                RTCPingManager.this.stringBuffer_PING.setLength(0);
                RTCPingManager.this.stringBuffer_PING.append("[");
                for (int i = 0; i < RTCPingManager.this.roomIdArrayCount; ++i) {
                    RTCPingManager.this.stringBuffer_PING.append(RTCPingManager.this.roomIdArray[i]);
                    if (i == RTCPingManager.this.roomIdArrayCount - 1) continue;
                    RTCPingManager.this.stringBuffer_PING.append(", ");
                }
                RTCPingManager.this.stringBuffer_PING.append(']');
                FinLog.d(RTCPingManager.TAG, "sendRTCPing : " + RTCPingManager.this.stringBuffer_PING.toString());
                IMLibRTCClient.getInstance().SendRTCHeartbeat(RTCPingManager.this.roomIdArray);
            }
        }, 0L, 5000L);
    }

    protected void otherRoomConnectedError(String roomId, int pingErrorCode) {
        FinLog.v(TAG, "sendRTCPing.otherRoomConnectedError : " + roomId);
        ReportUtil.libError(ReportUtil.TAG.PINGFAILED4TIMESLEAVEOTHERROOM, "roomId", roomId);
        RTCEngineImpl.getInstance().sendMessage(2078, roomId, pingErrorCode);
        if (this.mRoomIdConcurrentHashMap != null) {
            this.mRoomIdConcurrentHashMap.remove(roomId);
        }
    }

    public void reJoinRoom(RCRTCRoomType roomType, Map<String, String> localUserDatas, RCRTCJoinType joinType) {
        ReportUtil.libTask(ReportUtil.TAG.REJOINROOM, "roomId|uid|roomType|joinType", new Object[]{this.mMainRoomId, RongCoreClient.getInstance().getCurrentUserId(), roomType.getRoomType(), joinType});
        SignalManager.getInstance().joinRoom(this.mMainRoomId, roomType, true, localUserDatas, joinType, new IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>>(){

            public void onSuccess(List<RTCUser> rtcUsers, Map<String, Object> exarams) {
                ReportUtil.libRes(ReportUtil.TAG.REJOINROOM, "roomId|code", RTCPingManager.this.mMainRoomId, 0);
                RTCEngineImpl.getInstance().sendMessage(8102, rtcUsers, exarams);
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.RECONNECT_ERROR);
                ReportUtil.libError(ReportUtil.TAG.REJOINROOM, 2, "roomId|code|desc", RTCPingManager.this.mMainRoomId, errorCode.getValue(), errorCode.getMessage());
            }
        });
    }

    protected boolean isNetWorkAvailable() {
        ConnectivityManager manager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo info = manager.getActiveNetworkInfo();
        if (info != null) {
            return info.isConnected();
        }
        return false;
    }

    public void stopPing() {
        if (this.pingTimer != null) {
            try {
                this.pingTimer.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pingTimer = null;
        }
        if (null != this.mHeartBeatProcess) {
            this.mHeartBeatProcess.release();
        }
    }

    public void diffUsers(RCRoomImpl room, List<RTCUser> list) {
        RCRTCRemoteUser oldUser2;
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        List<RCRTCRemoteUser> oldRemoteUsers = room.getRemoteUsers();
        int newUserSize = RongRTCUtils.isEmpty(list) ? 0 : list.size();
        ReportUtil.libStatus(ReportUtil.TAG.DIFFDATA, "roomId|oldUsers|newUsers", room.getRoomId(), oldRemoteUsers.size() + 1, newUserSize);
        if (newUserSize == 0) {
            this.onUserLeft(room, oldRemoteUsers);
            return;
        }
        ArrayList<RCRTCRemoteUser> userLefts = new ArrayList<RCRTCRemoteUser>();
        for (RCRTCRemoteUser oldUser2 : oldRemoteUsers) {
            boolean left = true;
            for (RTCUser rtcUser : list) {
                if (!rtcUser.getUid().equals(oldUser2.getUserId())) continue;
                left = false;
                break;
            }
            if (!left) continue;
            userLefts.add(oldUser2);
        }
        ArrayList<RCRTCRemoteUser> newUsers = new ArrayList<RCRTCRemoteUser>();
        oldUser2 = null;
        String localUserId = room.getLocalUser().getUserId();
        for (RTCUser rtcUser : list) {
            if (rtcUser.getData() == null) continue;
            RCRemoteUserImpl tmp = RCRemoteUserImpl.parseRemoteUsers(rtcUser.getUid(), (String)rtcUser.getData().get("uris"));
            oldUser2 = room.getRemoteUser(rtcUser.getUid());
            if (oldUser2 != null) {
                this.differStream((RCRemoteUserImpl)oldUser2, tmp.getStreams(), oldUser2.getStreams(), room.getEventsListener());
                continue;
            }
            if (TextUtils.equals((CharSequence)rtcUser.getUid(), (CharSequence)localUserId)) continue;
            newUsers.add(tmp);
        }
        this.onUserLeft(room, userLefts);
        this.onAddNewUser(room, newUsers);
    }

    private void onAddNewUser(RCRoomImpl room, ArrayList<RCRTCRemoteUser> newUsers) {
        if (RongRTCUtils.isEmpty(newUsers)) {
            return;
        }
        for (RCRTCRemoteUser user : newUsers) {
            room.addRemoteUser(user);
            if (room.getEventsListener() == null) continue;
            room.getEventsListener().onRemoteUserPublishResource(user, user.getStreams());
        }
    }

    private void onUserLeft(RCRoomImpl room, List<RCRTCRemoteUser> users) {
        if (RongRTCUtils.isEmpty(users)) {
            return;
        }
        for (RCRTCRemoteUser user : users) {
            room.removeRemoteUser(user.getUserId());
            ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERLEFT, "uid", user.getUserId());
            if (room.getEventsListener() == null) continue;
            room.getEventsListener().onUserLeft(user);
        }
    }

    private void differStream(RCRemoteUserImpl remoteUser, List<RCRTCInputStream> streams, List<RCRTCInputStream> oldStreams, IRCRTCRoomEventsListener eventsListener) {
        int newStreamSize = RongRTCUtils.isEmpty(streams) ? 0 : streams.size();
        int oldStreamSize = RongRTCUtils.isEmpty(oldStreams) ? 0 : oldStreams.size();
        ReportUtil.libStatus(ReportUtil.TAG.DIFFSTREAM, "roomId|userId|oldStreams|newStreams", this.mMainRoomId, remoteUser.getUserId(), oldStreamSize, newStreamSize);
        if (RongRTCUtils.isEmpty(streams)) {
            if (eventsListener != null) {
                eventsListener.onRemoteUserUnpublishResource(remoteUser, oldStreams);
            }
            remoteUser.clearStream();
        } else if (RongRTCUtils.isEmpty(oldStreams)) {
            for (RCRTCInputStream stream : streams) {
                remoteUser.addStream(stream);
            }
            if (eventsListener != null) {
                eventsListener.onRemoteUserPublishResource(remoteUser, streams);
            }
        } else {
            RCStreamImpl oldStream = null;
            ArrayList<RCRTCInputStream> newStreams = new ArrayList<RCRTCInputStream>();
            for (RCRTCInputStream stream : streams) {
                oldStream = null;
                for (RCRTCInputStream inputStream : oldStreams) {
                    if (!TextUtils.equals((CharSequence)inputStream.getTag(), (CharSequence)stream.getTag()) || inputStream.getMediaType() != stream.getMediaType()) continue;
                    oldStream = (RCInputStreamImpl)inputStream;
                    break;
                }
                if (oldStream == null) {
                    remoteUser.addStream(stream);
                    newStreams.add(stream);
                    continue;
                }
                if (stream.getResourceState() != oldStream.getResourceState()) {
                    oldStream.setResourceState(stream.getResourceState());
                    if (eventsListener != null) {
                        if (oldStream.getMediaType().equals((Object)RCRTCMediaType.AUDIO)) {
                            eventsListener.onRemoteUserMuteAudio(remoteUser, (RCRTCInputStream)((Object)oldStream), !oldStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
                        } else if (oldStream.getMediaType().equals((Object)RCRTCMediaType.VIDEO)) {
                            eventsListener.onRemoteUserMuteVideo(remoteUser, (RCRTCInputStream)((Object)oldStream), !oldStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
                        }
                    }
                }
                if (TextUtils.equals((CharSequence)stream.getUri(), (CharSequence)oldStream.getUri())) continue;
                oldStream.setUri(stream.getUri());
            }
            if (!RongRTCUtils.isEmpty(newStreams) && eventsListener != null) {
                eventsListener.onRemoteUserPublishResource(remoteUser, newStreams);
            }
        }
    }

    @Override
    public void onNotify(String[] roomIds) {
        if (this.mRoomIdConcurrentHashMap != null && roomIds != null && roomIds.length > 0) {
            HashMap<String, HeartbeatInfo> map = new HashMap<String, HeartbeatInfo>(this.mRoomIdConcurrentHashMap.size());
            for (Map.Entry<String, HeartbeatInfo> entry : this.mRoomIdConcurrentHashMap.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            this.mRoomIdConcurrentHashMap.clear();
            for (String id : roomIds) {
                HeartbeatInfo info = null;
                if (map.containsKey(id)) {
                    info = (HeartbeatInfo)map.get(id);
                }
                this.mRoomIdConcurrentHashMap.put(id, info == null ? new HeartbeatInfo(0, 0) : info);
            }
            map.clear();
            Object var2_2 = null;
        }
    }

    protected int getPINGErrorCode(String roomId) {
        int code = 0;
        HeartbeatInfo heartbeatInfo = this.mRoomIdConcurrentHashMap.get(roomId);
        if (heartbeatInfo != null) {
            code = heartbeatInfo.getPingErrorCode();
        }
        return code;
    }

    protected int getPingFailedCount(String roomId) {
        int count = 0;
        HeartbeatInfo heartbeatInfo = this.mRoomIdConcurrentHashMap.get(roomId);
        if (heartbeatInfo != null) {
            count = heartbeatInfo.getPingFailedCount();
        }
        return count;
    }

    protected void updateHeartbeatInfo(String roomId, int errorCode) {
        HeartbeatInfo heartbeatInfo = this.mRoomIdConcurrentHashMap.get(roomId);
        if (heartbeatInfo != null) {
            heartbeatInfo.setPingErrorCode(errorCode);
            int count = heartbeatInfo.getPingFailedCount();
            heartbeatInfo.setPingFailedCount(++count);
        } else {
            this.mRoomIdConcurrentHashMap.put(roomId, new HeartbeatInfo(errorCode, 0));
        }
    }

    public void clearHearbeatInfo(String roomid) {
        this.mRoomIdConcurrentHashMap.put(roomid, new HeartbeatInfo(0, 0));
    }

    static /* synthetic */ String[] access$002(RTCPingManager x0, String[] x1) {
        x0.roomIdArray = x1;
        return x1;
    }

    private class HeartbeatInfo {
        private int pingErrorCode = 0;
        private int pingFailedCount = 0;

        public HeartbeatInfo(int pingErrorCode, int pingFailedCount) {
            this.pingErrorCode = pingErrorCode;
            this.pingFailedCount = pingFailedCount;
        }

        public int getPingErrorCode() {
            return this.pingErrorCode;
        }

        public int getPingFailedCount() {
            return this.pingFailedCount;
        }

        public void setPingErrorCode(int pingErrorCode) {
            this.pingErrorCode = pingErrorCode;
        }

        public void setPingFailedCount(int pingFailedCount) {
            this.pingFailedCount = pingFailedCount;
        }
    }
}

