/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.http;

import android.text.TextUtils;
import cn.rongcloud.rtc.media.http.Request;
import cn.rongcloud.rtc.media.http.Response;
import cn.rongcloud.rtc.media.http.TlsSniSocketFactory;
import cn.rongcloud.rtc.sniffer.SnifferManager;
import io.rong.common.RLog;
import io.rong.common.utils.SSLUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

public class HttpClient {
    public int CONNECT_TIME_OUT = 8000;
    private static final String TAG = "HttpClient";

    private HttpClient() {
    }

    public static HttpClient getDefault() {
        return SingletonHolder.sDefaultHttpClient;
    }

    public void request(final Request request, final ResultCallback callback) {
        HttpClient.executorService().execute(new Runnable(){

            @Override
            public void run() {
                Response response = HttpClient.this.doRequest(request);
                if (callback == null) {
                    return;
                }
                if (response.isSuccess()) {
                    callback.onResponse((String)response.getData());
                } else {
                    callback.onFailure(response.getResponseCode());
                }
            }
        });
    }

    public Response<String> syncRequest(Request request) {
        return this.doRequest(request);
    }

    /*
     * Exception decompiling
     */
    private Response<String> doRequest(Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ExecutorService executorService() {
        return SingletonHolderExecutorService.executorService;
    }

    private void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            RLog.e((String)TAG, (String)"closeStream exception ", (Throwable)e);
        }
    }

    private HttpURLConnection createConnection(Request request) throws IOException {
        HttpURLConnection conn;
        URL url;
        String host;
        RLog.i((String)TAG, (String)("request url : " + request.url()));
        String myHost = HttpClient.getNavHost(request.url());
        String string = host = TextUtils.isEmpty((CharSequence)SnifferManager.getInstance().getOriginHost(myHost)) ? myHost : SnifferManager.getInstance().getOriginHost(myHost);
        if (request.url().toLowerCase().startsWith("https")) {
            url = new URL(request.url());
            if (SSLUtils.getSSLContext() != null) {
                SSLContext sslContext = SSLUtils.getSSLContext();
                HttpsURLConnection c = (HttpsURLConnection)url.openConnection();
                c.setSSLSocketFactory(sslContext.getSocketFactory());
                if (SSLUtils.getHostVerifier() != null) {
                    c.setHostnameVerifier(SSLUtils.getHostVerifier());
                }
                conn = c;
            } else {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
                httpsConnection.setSSLSocketFactory(new TlsSniSocketFactory(httpsConnection));
                httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return HttpsURLConnection.getDefaultHostnameVerifier().verify(host, session);
                    }
                });
                conn = httpsConnection;
            }
        } else {
            url = new URL(request.url());
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(request.method());
        conn.setConnectTimeout(this.CONNECT_TIME_OUT);
        conn.setReadTimeout(this.CONNECT_TIME_OUT);
        conn.setUseCaches(false);
        if (!TextUtils.isEmpty((CharSequence)host)) {
            conn.setRequestProperty("Host", host);
        }
        conn.setRequestProperty("Accept", "application/json;charset=UTF-8");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (request.getHeaders() != null && request.getHeaders().getHeaders() != null) {
            Set setKey = request.getHeaders().getHeaders().keySet();
            for (String key : setKey) {
                String value = (String)request.getHeaders().getHeaders().get((Object)key);
                conn.setRequestProperty(key, value);
            }
        }
        conn.setDoInput(true);
        if (TextUtils.equals((CharSequence)request.method(), (CharSequence)"POST")) {
            conn.setDoOutput(true);
            String body = request.body();
            if (body == null) {
                throw new NullPointerException("Request.body == null");
            }
            OutputStream outputStream = conn.getOutputStream();
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.write(request.body());
            printWriter.flush();
        }
        return conn;
    }

    private static String getNavHost(String navi) {
        try {
            URL url = new URL(navi);
            String host = url.getHost();
            int port = url.getPort();
            if (port != -1 && url.getDefaultPort() != url.getPort()) {
                host = host + ":" + port;
            }
            return host;
        }
        catch (MalformedURLException e) {
            RLog.e((String)TAG, (String)"MalformedURLException ", (Throwable)e);
            return null;
        }
    }

    public static interface ResultCallback {
        public void onResponse(String var1);

        public void onFailure(int var1);
    }

    private static class SingletonHolderExecutorService {
        static ExecutorService executorService = Executors.newCachedThreadPool();

        private SingletonHolderExecutorService() {
        }
    }

    private static class SingletonHolder {
        static HttpClient sDefaultHttpClient = new HttpClient();

        private SingletonHolder() {
        }
    }
}

