/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.commonaudio.codec;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public class AacMediaCodecWrapper {
    private final String b;
    private final int c;
    private MediaCodec d;
    private final MediaCodec.BufferInfo e;
    MediaFormat a;

    public AacMediaCodecWrapper(int type) {
        this.c = type;
        this.b = type == com.tencent.liteav.commonaudio.codec.AacMediaCodecWrapper$a.a ? "HardwareAacEncoder" : "HardwareAacDecoder";
        this.e = new MediaCodec.BufferInfo();
    }

    public final boolean a(MediaFormat mediaFormat) {
        if (this.d != null || mediaFormat == null) {
            return false;
        }
        try {
            boolean bl2 = this.c == com.tencent.liteav.commonaudio.codec.AacMediaCodecWrapper$a.a;
            this.d = bl2 ? MediaCodec.createEncoderByType((String)"audio/mp4a-latm") : MediaCodec.createDecoderByType((String)"audio/mp4a-latm");
            this.d.configure(mediaFormat, null, null, bl2 ? 1 : 0);
        }
        catch (IOException iOException) {
            Log.e(this.b, "create codec failed. ".concat(String.valueOf(iOException)), new Object[0]);
            this.a();
            return false;
        }
        this.d.start();
        return true;
    }

    @CalledByNative
    public ByteBuffer processFrame(ByteBuffer inputBuffer) {
        if (this.d == null || inputBuffer == null) {
            return null;
        }
        ByteBuffer byteBuffer = inputBuffer;
        AacMediaCodecWrapper aacMediaCodecWrapper = this;
        try {
            ByteBuffer[] byteBufferArray = aacMediaCodecWrapper.d.getInputBuffers();
            if (byteBufferArray == null || byteBufferArray.length <= 0) {
                Log.e(aacMediaCodecWrapper.b, "get invalid input buffers.", new Object[0]);
            } else {
                int n2 = aacMediaCodecWrapper.d.dequeueInputBuffer(TimeUnit.MILLISECONDS.toMicros(2L));
                if (n2 >= 0) {
                    int n3 = byteBuffer.remaining();
                    byteBufferArray[n2].put(byteBuffer);
                    aacMediaCodecWrapper.d.queueInputBuffer(n2, 0, n3, 0L, 0);
                }
            }
        }
        catch (Exception exception) {
            Log.e(aacMediaCodecWrapper.b, "feedData failed. ".concat(String.valueOf(exception)), new Object[0]);
        }
        AacMediaCodecWrapper aacMediaCodecWrapper2 = this;
        for (int i2 = 0; i2 < 3; ++i2) {
            ByteBuffer byteBuffer2 = aacMediaCodecWrapper2.b();
            if (byteBuffer2 == null) continue;
            return byteBuffer2;
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private ByteBuffer b() {
        try {
            int n2 = this.d.dequeueOutputBuffer(this.e, TimeUnit.MILLISECONDS.toMicros(2L));
            if (n2 == -1) {
                return null;
            }
            if (n2 == -3) {
                Log.i(this.b, "codec output buffers changed.", new Object[0]);
                return null;
            }
            if (n2 == -2) {
                this.a = this.d.getOutputFormat();
                Log.i(this.b, "codec output format changed: " + this.a, new Object[0]);
                return null;
            }
            if (n2 < 0) {
                Log.e(this.b, "unexpected result from dequeueOutputBuffer: ".concat(String.valueOf(n2)), new Object[0]);
                return null;
            }
            ByteBuffer byteBuffer = LiteavSystemInfo.getSystemOSVersionInt() >= 21 ? this.d.getOutputBuffer(n2) : this.d.getOutputBuffers()[n2];
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.e.size);
            byteBuffer2.put(byteBuffer);
            this.d.releaseOutputBuffer(n2, false);
            return byteBuffer2;
        }
        catch (Exception exception) {
            Log.e(this.b, "dequeueOutputBuffer failed. ".concat(String.valueOf(exception)), new Object[0]);
            return null;
        }
    }

    public final void a() {
        if (this.d == null) {
            return;
        }
        try {
            this.d.stop();
        }
        catch (Exception exception) {
            Log.e(this.b, "codec stop failed.".concat(String.valueOf(exception)), new Object[0]);
        }
        try {
            this.d.release();
        }
        catch (Exception exception) {
            Log.e(this.b, "codec release failed.".concat(String.valueOf(exception)), new Object[0]);
        }
        this.d = null;
    }

    public static final class a
    extends Enum<a> {
        public static final int a = 1;
        public static final int b = 2;
        private static final /* synthetic */ int[] c;

        static {
            c = new int[]{a, b};
        }
    }
}

