/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.Utils;
import cz.msebera.android.httpclient.Header;
import cz.msebera.android.httpclient.HttpEntity;
import cz.msebera.android.httpclient.HttpResponse;
import cz.msebera.android.httpclient.StatusLine;
import cz.msebera.android.httpclient.client.HttpResponseException;
import cz.msebera.android.httpclient.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Locale;

public abstract class AsyncHttpResponseHandler
implements ResponseHandlerInterface {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String UTF8_BOM = "\ufeff";
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    protected static final int PROGRESS_MESSAGE = 4;
    protected static final int RETRY_MESSAGE = 5;
    protected static final int CANCEL_MESSAGE = 6;
    protected static final int BUFFER_SIZE = 4096;
    private static final String LOG_TAG = "AsyncHttpRH";
    private String responseCharset = "UTF-8";
    private Handler handler;
    private boolean useSynchronousMode;
    private boolean usePoolThread;
    private URI requestURI = null;
    private Header[] requestHeaders = null;
    private Looper looper = null;
    private WeakReference<Object> TAG = new WeakReference<Object>(null);

    public AsyncHttpResponseHandler() {
        this(null);
    }

    public AsyncHttpResponseHandler(Looper looper) {
        this(looper == null ? Looper.myLooper() : looper, false);
    }

    public AsyncHttpResponseHandler(boolean usePoolThread) {
        this(usePoolThread ? null : Looper.myLooper(), usePoolThread);
    }

    private AsyncHttpResponseHandler(Looper looper, boolean usePoolThread) {
        if (!usePoolThread) {
            Utils.asserts(looper != null, "use looper thread, must call Looper.prepare() first!");
            this.looper = looper;
            this.handler = new ResponderHandler(this, looper);
        } else {
            Utils.asserts(looper == null, "use pool thread, looper should be null!");
            this.looper = null;
            this.handler = null;
        }
        this.usePoolThread = usePoolThread;
    }

    @Override
    public Object getTag() {
        return this.TAG.get();
    }

    @Override
    public void setTag(Object TAG) {
        this.TAG = new WeakReference<Object>(TAG);
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public void setRequestURI(URI requestURI) {
        this.requestURI = requestURI;
    }

    @Override
    public Header[] getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public void setRequestHeaders(Header[] requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Override
    public boolean getUseSynchronousMode() {
        return this.useSynchronousMode;
    }

    @Override
    public void setUseSynchronousMode(boolean sync) {
        if (!sync && this.looper == null) {
            sync = true;
            AsyncHttpClient.log.w(LOG_TAG, "Current thread has not called Looper.prepare(). Forcing synchronous mode.");
        }
        if (!sync && this.handler == null) {
            this.handler = new ResponderHandler(this, this.looper);
        } else if (sync && this.handler != null) {
            this.handler = null;
        }
        this.useSynchronousMode = sync;
    }

    @Override
    public boolean getUsePoolThread() {
        return this.usePoolThread;
    }

    @Override
    public void setUsePoolThread(boolean pool) {
        if (pool) {
            this.looper = null;
            this.handler = null;
        }
        this.usePoolThread = pool;
    }

    public String getCharset() {
        return this.responseCharset == null ? DEFAULT_CHARSET : this.responseCharset;
    }

    public void setCharset(String charset) {
        this.responseCharset = charset;
    }

    public void onProgress(long bytesWritten, long totalSize) {
        AsyncHttpClient.log.v(LOG_TAG, String.format(Locale.US, "Progress %d from %d (%2.0f%%)", bytesWritten, totalSize, totalSize > 0L ? (double)bytesWritten * 1.0 / (double)totalSize * 100.0 : -1.0));
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    @Override
    public void onPreProcessResponse(ResponseHandlerInterface instance, HttpResponse response) {
    }

    @Override
    public void onPostProcessResponse(ResponseHandlerInterface instance, HttpResponse response) {
    }

    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);

    public abstract void onFailure(int var1, Header[] var2, byte[] var3, Throwable var4);

    public void onRetry(int retryNo) {
        AsyncHttpClient.log.d(LOG_TAG, String.format(Locale.US, "Request retry no. %d", retryNo));
    }

    public void onCancel() {
        AsyncHttpClient.log.d(LOG_TAG, "Request got cancelled");
    }

    public void onUserException(Throwable error) {
        AsyncHttpClient.log.e(LOG_TAG, "User-space exception detected!", error);
        throw new RuntimeException(error);
    }

    @Override
    public final void sendProgressMessage(long bytesWritten, long bytesTotal) {
        this.sendMessage(this.obtainMessage(4, new Object[]{bytesWritten, bytesTotal}));
    }

    @Override
    public final void sendSuccessMessage(int statusCode, Header[] headers, byte[] responseBytes) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, headers, responseBytes}));
    }

    @Override
    public final void sendFailureMessage(int statusCode, Header[] headers, byte[] responseBody, Throwable throwable) {
        this.sendMessage(this.obtainMessage(1, new Object[]{statusCode, headers, responseBody, throwable}));
    }

    @Override
    public final void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    @Override
    public final void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    @Override
    public final void sendRetryMessage(int retryNo) {
        this.sendMessage(this.obtainMessage(5, new Object[]{retryNo}));
    }

    @Override
    public final void sendCancelMessage() {
        this.sendMessage(this.obtainMessage(6, null));
    }

    protected void handleMessage(Message message) {
        try {
            switch (message.what) {
                case 0: {
                    Object[] response = (Object[])message.obj;
                    if (response != null && response.length >= 3) {
                        this.onSuccess((Integer)response[0], (Header[])response[1], (byte[])response[2]);
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "SUCCESS_MESSAGE didn't got enough params");
                    break;
                }
                case 1: {
                    Object[] response = (Object[])message.obj;
                    if (response != null && response.length >= 4) {
                        this.onFailure((Integer)response[0], (Header[])response[1], (byte[])response[2], (Throwable)response[3]);
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "FAILURE_MESSAGE didn't got enough params");
                    break;
                }
                case 2: {
                    this.onStart();
                    break;
                }
                case 3: {
                    this.onFinish();
                    break;
                }
                case 4: {
                    Object[] response = (Object[])message.obj;
                    if (response != null && response.length >= 2) {
                        try {
                            this.onProgress((Long)response[0], (Long)response[1]);
                        }
                        catch (Throwable t) {
                            AsyncHttpClient.log.e(LOG_TAG, "custom onProgress contains an error", t);
                        }
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "PROGRESS_MESSAGE didn't got enough params");
                    break;
                }
                case 5: {
                    Object[] response = (Object[])message.obj;
                    if (response != null && response.length == 1) {
                        this.onRetry((Integer)response[0]);
                        break;
                    }
                    AsyncHttpClient.log.e(LOG_TAG, "RETRY_MESSAGE didn't get enough params");
                    break;
                }
                case 6: {
                    this.onCancel();
                }
            }
        }
        catch (Throwable error) {
            this.onUserException(error);
        }
    }

    protected void sendMessage(Message msg) {
        if (this.getUseSynchronousMode() || this.handler == null) {
            this.handleMessage(msg);
        } else if (!Thread.currentThread().isInterrupted()) {
            Utils.asserts(this.handler != null, "handler should not be null!");
            this.handler.sendMessage(msg);
        }
    }

    protected void postRunnable(Runnable runnable) {
        if (runnable != null) {
            if (this.getUseSynchronousMode() || this.handler == null) {
                runnable.run();
            } else {
                this.handler.post(runnable);
            }
        }
    }

    protected Message obtainMessage(int responseMessageId, Object responseMessageData) {
        return Message.obtain((Handler)this.handler, (int)responseMessageId, (Object)responseMessageData);
    }

    @Override
    public void sendResponseMessage(HttpResponse response) throws IOException {
        if (!Thread.currentThread().isInterrupted()) {
            StatusLine status = response.getStatusLine();
            byte[] responseBody = this.getResponseData(response.getEntity());
            if (!Thread.currentThread().isInterrupted()) {
                if (status.getStatusCode() >= 300) {
                    this.sendFailureMessage(status.getStatusCode(), response.getAllHeaders(), responseBody, new HttpResponseException(status.getStatusCode(), status.getReasonPhrase()));
                } else {
                    this.sendSuccessMessage(status.getStatusCode(), response.getAllHeaders(), responseBody);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getResponseData(HttpEntity entity) throws IOException {
        InputStream instream;
        byte[] responseBody = null;
        if (entity != null && (instream = entity.getContent()) != null) {
            long contentLength = entity.getContentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int buffersize = contentLength <= 0L ? 4096 : (int)contentLength;
            try {
                ByteArrayBuffer buffer = new ByteArrayBuffer(buffersize);
                try {
                    int l;
                    byte[] tmp = new byte[4096];
                    long count = 0L;
                    while ((l = instream.read(tmp)) != -1 && !Thread.currentThread().isInterrupted()) {
                        buffer.append(tmp, 0, l);
                        this.sendProgressMessage(count += (long)l, contentLength <= 0L ? 1L : contentLength);
                    }
                }
                finally {
                    AsyncHttpClient.silentCloseInputStream(instream);
                    AsyncHttpClient.endEntityViaReflection(entity);
                }
                responseBody = buffer.toByteArray();
            }
            catch (OutOfMemoryError e) {
                System.gc();
                throw new IOException("File too large to fit into available memory");
            }
        }
        return responseBody;
    }

    private static class ResponderHandler
    extends Handler {
        private final AsyncHttpResponseHandler mResponder;

        ResponderHandler(AsyncHttpResponseHandler mResponder, Looper looper) {
            super(looper);
            this.mResponder = mResponder;
        }

        public void handleMessage(Message msg) {
            this.mResponder.handleMessage(msg);
        }
    }
}

