/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.tools.multiroom;

import cn.rongcloud.rtc.engine.tools.multiroom.AbstractMultipleRoom;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class InviteTimerElement
extends AbstractMultipleRoom {
    public static final String TAG = "InviteTimerElement";
    private Map<String, InviteTimerTask> concurrentHashMap = new ConcurrentHashMap<String, InviteTimerTask>(16);
    private Timer mTimer;
    private static final int FIVE_SECONDS = 5;
    private static final int ONE_THOUSAND = 1000;

    public InviteInfo cancelTimer1(String inviteeUserId) {
        InviteInfo info = null;
        if (this.concurrentHashMap != null && this.concurrentHashMap.size() > 0) {
            InviteTimerTask task = this.concurrentHashMap.remove(inviteeUserId);
            info = task.getInviteInfo();
            FinLog.d(TAG, "cancelTimerTask->userId : " + inviteeUserId + " , InviteSessionId : " + info.getInviteSessionId());
            if (task != null) {
                task.cancel();
            }
        }
        if (info == null) {
            FinLog.d(TAG, "cancelTimerTask->repeat->userId : " + inviteeUserId);
        }
        return info;
    }

    public boolean startTimer1(InviteInfo info) {
        if (this.mTimer == null) {
            this.mTimer = new Timer();
        }
        if (this.concurrentHashMap.containsKey(info.getInviteeUserId())) {
            FinLog.e(TAG, "startTimer->containsKey->InviteeUserId : " + info.getInviteeUserId() + " , InviteSessionId : " + info.getInviteSessionId());
            return true;
        }
        InviteTimerTask task = new InviteTimerTask(info);
        this.concurrentHashMap.put(info.getInviteeUserId(), task);
        FinLog.d(TAG, "startTimer->inviterRoomId :" + info.getInviterRoomId() + " , inviterUserId :" + info.getInviterUserId() + " , inviteeRoomId : " + info.getInviteeRoomId() + " , inviteeUserId : " + info.getInviteeUserId() + " , timeout : " + info.getInviteeTimeoutTime() + " , InviteSessionId : " + info.getInviteSessionId());
        this.mTimer.schedule((TimerTask)task, (info.getInviteeTimeoutTime() + 5) * 1000);
        return false;
    }

    @Override
    public void release() {
        super.release();
        if (this.concurrentHashMap != null && this.concurrentHashMap.size() > 0) {
            for (TimerTask timerTask : this.concurrentHashMap.values()) {
                if (timerTask == null) continue;
                timerTask.cancel();
            }
            this.concurrentHashMap.clear();
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    public class InviteTimerTask
    extends TimerTask {
        private InviteInfo mInviteInfo = null;

        public InviteTimerTask(InviteInfo info) {
            this.mInviteInfo = info;
        }

        public InviteInfo getInviteInfo() {
            return this.mInviteInfo;
        }

        @Override
        public void run() {
        }
    }
}

