/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module;

import android.media.AudioTrack;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.utils.AudioRecordUtil;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

public class HardwareTestManager {
    private final String TAG = "HardwareTestManager";
    private final int MSG_WHAT_INIT_AUDIO_ENV = 1000;
    private final int MSG_WHAT_PROCESS = 1001;
    private final int MSG_WHAT_STOP = 1002;
    private final int MSG_WHAT_PLAY = 1003;
    private final int MSG_WHAT_UNINIT = 1004;
    private AudioRecordUtil audioRecordUtil;
    private Queue<byte[]> mQueue;
    private HandlerThread mProThread;
    private ProcessHandler mHandler;
    private AudioTrack mAudioTrack;
    private int mInternalInSeconds = 0;
    private AtomicBoolean mPlaying = new AtomicBoolean(false);
    private AtomicBoolean mStarting = new AtomicBoolean(false);
    private int mAudioSource;
    private int mSampleRate;
    private boolean mIsStereo;
    private int mAudioFormat;

    public void init(int audioSource, int sampleRate, boolean isStereo, int audioFormat) {
        Logging.d("HardwareTestManager", String.format("- init audioSource:%d, sampleRate:%d, isStereo:%b, audioFormat:%d", audioSource, sampleRate, isStereo, audioFormat));
        this.mAudioSource = audioSource;
        this.mSampleRate = sampleRate;
        this.mIsStereo = isStereo;
        this.mAudioFormat = audioFormat;
    }

    public void unInit() {
        if (this.mHandler != null && this.mProThread != null) {
            this.mHandler.sendEmptyMessage(1004);
        }
    }

    public void startEchoTest(int internalInSeconds) {
        if (internalInSeconds < 2 || internalInSeconds > 10) {
            String msg = String.format("internalInSeconds must be between 2 and 10 ! errorCode:%s", new Object[]{RTCErrorCode.START_PRETEST_HARDWARE_FAILED});
            Logging.e("HardwareTestManager", msg);
            return;
        }
        if (this.mStarting.get()) {
            String msg = String.format("echo pretest is in progressing ! errorCode:%s", new Object[]{RTCErrorCode.START_PRETEST_HARDWARE_FAILED});
            Logging.e("HardwareTestManager", msg);
            return;
        }
        this.mInternalInSeconds = internalInSeconds;
        this.mProThread = new HandlerThread("ProcessThread");
        this.mProThread.start();
        this.mHandler = new ProcessHandler(this.mProThread.getLooper());
        this.mHandler.sendEmptyMessage(1000);
    }

    public void stopEchoTest() {
        this.mPlaying.set(false);
        if (this.mHandler != null && this.mProThread != null) {
            this.mHandler.sendEmptyMessage(1004);
        }
    }

    private class ProcessHandler
    extends Handler {
        public ProcessHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1000: {
                    final long prev = System.currentTimeMillis();
                    int channel = HardwareTestManager.this.mIsStereo ? 12 : 4;
                    HardwareTestManager.this.mAudioTrack = new AudioTrack(DevicesUtils.getAudioMode(), HardwareTestManager.this.mSampleRate, channel, HardwareTestManager.this.mAudioFormat, 4096, 1);
                    HardwareTestManager.this.mAudioTrack.play();
                    if (HardwareTestManager.this.mQueue == null) {
                        HardwareTestManager.this.mQueue = new LinkedList();
                    }
                    if (HardwareTestManager.this.audioRecordUtil == null) {
                        channel = HardwareTestManager.this.mIsStereo ? 12 : 16;
                        HardwareTestManager.this.audioRecordUtil = new AudioRecordUtil(HardwareTestManager.this.mAudioSource, HardwareTestManager.this.mSampleRate, channel, HardwareTestManager.this.mAudioFormat);
                    }
                    HardwareTestManager.this.audioRecordUtil.setOnRecordListener(new AudioRecordUtil.OnRecordListener(){

                        @Override
                        public void recordBytes(byte[] pcmBuffer, int bufferSize) {
                            long cur = System.currentTimeMillis();
                            long sub = cur - prev;
                            if (sub <= (long)(HardwareTestManager.this.mInternalInSeconds * 1000)) {
                                Message msg = HardwareTestManager.this.mHandler.obtainMessage();
                                msg.what = 1001;
                                msg.obj = pcmBuffer;
                                HardwareTestManager.this.mHandler.sendMessage(msg);
                            } else if (HardwareTestManager.this.mHandler != null) {
                                HardwareTestManager.this.mHandler.sendEmptyMessage(1002);
                            }
                        }
                    });
                    HardwareTestManager.this.audioRecordUtil.startRecord();
                    HardwareTestManager.this.mStarting.set(true);
                    break;
                }
                case 1001: {
                    byte[] buffer = (byte[])msg.obj;
                    try {
                        HardwareTestManager.this.mQueue.offer(buffer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1002: {
                    if (HardwareTestManager.this.audioRecordUtil != null) {
                        HardwareTestManager.this.audioRecordUtil.stopRecord();
                        HardwareTestManager.this.audioRecordUtil = null;
                    }
                    HardwareTestManager.this.mPlaying.set(true);
                    HardwareTestManager.this.mHandler.sendEmptyMessage(1003);
                    break;
                }
                case 1003: {
                    try {
                        while (HardwareTestManager.this.mPlaying.get() && !HardwareTestManager.this.mQueue.isEmpty()) {
                            byte[] buffer1 = (byte[])HardwareTestManager.this.mQueue.poll();
                            if (HardwareTestManager.this.mAudioTrack == null) continue;
                            HardwareTestManager.this.mAudioTrack.write(buffer1, 0, buffer1.length);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    HardwareTestManager.this.mStarting.set(false);
                    break;
                }
                case 1004: {
                    if (HardwareTestManager.this.audioRecordUtil != null) {
                        HardwareTestManager.this.audioRecordUtil.stopRecord();
                        HardwareTestManager.this.audioRecordUtil = null;
                    }
                    if (HardwareTestManager.this.mAudioTrack != null) {
                        HardwareTestManager.this.mAudioTrack.stop();
                        HardwareTestManager.this.mAudioTrack.release();
                        HardwareTestManager.this.mAudioTrack = null;
                    }
                    if (HardwareTestManager.this.mQueue != null) {
                        HardwareTestManager.this.mQueue.clear();
                        HardwareTestManager.this.mQueue = null;
                    }
                    HardwareTestManager.this.mStarting.set(false);
                    HardwareTestManager.this.mHandler.removeCallbacksAndMessages(null);
                    HardwareTestManager.this.mProThread.quitSafely();
                    HardwareTestManager.this.mHandler.getLooper().quitSafely();
                    HardwareTestManager.this.mProThread = null;
                }
            }
        }
    }
}

