/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.monitor;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.NetState;
import io.rong.common.RLog;

public class NetworkConnectChangedReceiver
extends BroadcastReceiver {
    private String TAG = "NetworkConnectChangedReceiver";
    private NetState state = NetState.NONE;

    public void onReceive(Context context, Intent intent) {
        boolean networkAvailable;
        if (intent == null || intent.getAction() == null) {
            return;
        }
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            RLog.d((String)this.TAG, (String)("intent : " + intent.toString()));
            networkInfo = connectivity.getActiveNetworkInfo();
            RLog.d((String)this.TAG, (String)("network : " + (networkInfo != null ? networkInfo.isAvailable() + " " + networkInfo.isConnected() : "null")));
        }
        catch (Exception e) {
            RLog.e((String)this.TAG, (String)"getActiveNetworkInfo Exception", (Throwable)e);
        }
        boolean bl = networkAvailable = networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
        if (!networkAvailable) {
            FinLog.v(this.TAG, "network unAvailable");
            return;
        }
        FinLog.v(this.TAG, "networkInfo = " + networkInfo);
        if (networkInfo.getType() == 1) {
            this.state = NetState.WIFI;
        } else if (networkInfo.getType() == 0) {
            this.state = NetState.MOBILE;
        }
        RTCEngineImpl.getInstance().onNetStateChanged(this.state);
    }
}

