/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCJoinType;
import cn.rongcloud.rtc.base.RCRTCJoinedRoomInfo;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.proto.APIType;
import cn.rongcloud.rtc.proto.RcRtcPbConfig;
import cn.rongcloud.rtc.proto.RcRtcPbIdentityChange;
import cn.rongcloud.rtc.proto.RcRtcPbJoinRoom;
import cn.rongcloud.rtc.proto.RcRtcPbLiveAnswer;
import cn.rongcloud.rtc.proto.RcRtcPbLiveCancel;
import cn.rongcloud.rtc.proto.RcRtcPbLiveHangup;
import cn.rongcloud.rtc.proto.RcRtcPbLiveInvite;
import cn.rongcloud.rtc.proto.RcRtcPbPullKv;
import cn.rongcloud.rtc.proto.RcRtcPbQueryData;
import cn.rongcloud.rtc.proto.RcRtcPbQueryJoined;
import cn.rongcloud.rtc.proto.RcRtcPbQuitRoom;
import cn.rongcloud.rtc.proto.RcRtcPbSetData;
import cn.rongcloud.rtc.proto.RcRtcPbSetUserResource;
import cn.rongcloud.rtc.proto.RcRtcPbSetUserState;
import cn.rongcloud.rtc.proto.RcRtcPbToken;
import cn.rongcloud.rtc.proto.RcRtcPbUlistData;
import cn.rongcloud.rtc.proto.RcRtcPbViewerJoinRoom;
import cn.rongcloud.rtc.protobuf.InvalidProtocolBufferException;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.signal.IRTCSwitchRoleCallback;
import cn.rongcloud.rtc.signal.SignalEventListener;
import cn.rongcloud.rtc.signal.SyncIMResultCallback;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IRTCRoomEventListener;
import io.rong.imlib.IRongCoreCallback;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.IRongCoreRTCCallback;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongCoreClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.RTCStatusDate;
import io.rong.imlib.model.RTCUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IMSignalWrapper {
    private static final String TAG = "IMSignalWrapper";
    private static final byte[] EMPTY_ELEMENT_DATA = null;
    private static final String RTC_TOKEN = "rtcToken";
    private static final String PROBE_RTC_TOKEN = "rtcSimpleToken";
    private static final String RTC_SET_DATA = "rtcSetData";
    private static final String RTC_JOIN_DATA = "rtcRJoin_data";
    private static final String QRY_SPEC_RTC_CONF = "qrySpecRtcConf";
    private static final String USER_SET_DATA = "userSetData";
    private static final String RTC_EXIT = "rtcRExit";
    private static final String RTC_DEL_DATA = "rtcDelData";
    private static final String RTC_QRY_DATA = "rtcQryData";
    private static final String RTC_INVITE = "rtcInvite";
    private static final String RTC_CANCEL_INVITE = "rtcCancelInvite";
    private static final String RTC_INVITE_ANSWER = "rtcInviteAnswer";
    private static final String RTC_END_INVITE = "rtcEndInvite";
    private static final String VIEWER_JOIN = "viewerJoinR";
    private static final String RTC_PULL_KV = "rtcPullKv";
    private static final String VIEWER_EXIT = "viewerExitR";
    private static final String RTC_USER_STATE = "rtcUserState";
    private static final String RTC_IDENTITY_CHANGE = "rtcIdentityChange";
    private static final String RTC_U_DATA = "rtcUData";
    private static final String RTC_QUERY_IN_ROOM_STATE = "rtcQueryJoined";

    public AsyncResult<String> syncGetRTCToken(String roomId, int roomType, int mediaType) {
        ReportUtil.libTask(ReportUtil.TAG.GETRTCTOKEN, "roomId|roomType|mediaType", roomId, roomType, mediaType);
        final AsyncResult.TemporaryResult<Thread> res = AsyncResult.create(Thread.currentThread());
        this.getToken(roomId, roomType, mediaType, new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String data) {
                ReportUtil.libRes(ReportUtil.TAG.GETRTCTOKEN, "code|token", 0, data);
                res.setAndNotify(data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.GETRTCTOKEN, "code|desc", errorCode.getValue(), errorCode.getReason());
                res.setAndNotify(RTCErrorCode.valueOf(errorCode.getValue()));
            }
        });
        return res.waitForGetResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getToken(final String roomId, int roomType, int mediaType, final IRCRTCResultDataCallback<String> callback) {
        byte[] pbBuffer;
        block5: {
            pbBuffer = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbToken.RCRTCPBTokenRequest tokenRequest = RcRtcPbToken.RCRTCPBTokenRequest.newBuilder().setRoomType(roomType).setLiveType(mediaType).build();
                pbBuffer = tokenRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_TOKEN, pbBuffer, callback)) break block5;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_TOKEN, true, pbBuffer, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbToken.RCRTCPBTokenResponse tokenResponse = ((RcRtcPbToken.RCRTCPBTokenResponse.Builder)RcRtcPbToken.RCRTCPBTokenResponse.newBuilder().mergeFrom(bytes)).build();
                    String token = tokenResponse.getToken();
                    if (callback != null) {
                        callback.onSuccess(token);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_TOKEN, e.getMessage(), callback);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode e) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(e.getValue()));
                }
            }
        });
    }

    public void rtcPutInnerData(String roomId, int type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        this.rtcSetData(roomId, type, APIType.INNER_DATA, key, value, message, callback);
    }

    public String getVoIPInfo() {
        return IMLibRTCClient.getInstance().getVoIPInfo();
    }

    public void joinRoom(final String roomId, RCRTCRoomType roomType, boolean isReJoin, Map<String, String> localUserDatas, RCRTCJoinType joinType, final IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.JOINRTCROOMANDGETDATA, "roomId|uid|roomType|joinType", new Object[]{roomId, RongCoreClient.getInstance().getCurrentUserId(), roomType, joinType});
        this.joinRTCRoom(roomId, roomType, localUserDatas, joinType, "", "", new IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>>(){

            public void onSuccess(List<RTCUser> rtcUsers, Map<String, Object> exParams) {
                if (callBack != null) {
                    callBack.onSuccess(rtcUsers, exParams);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.JOINRTCROOMANDGETDATA, "roomId|code|desc", roomId, errorCode.getValue(), errorCode.getMessage());
                if (callBack != null) {
                    callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinRTCRoom(final String roomId, RCRTCRoomType roomType, Map<String, String> localUserDatas, RCRTCJoinType joinType, String key, String value, final IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>> callBack) {
        byte[] pbBuffer;
        block8: {
            pbBuffer = EMPTY_ELEMENT_DATA;
            try {
                ArrayList<RcRtcPbJoinRoom.RCRTCPBKV> localUserDatasList = new ArrayList<RcRtcPbJoinRoom.RCRTCPBKV>();
                if (localUserDatas != null && !localUserDatas.isEmpty()) {
                    for (String dataKey : localUserDatas.keySet()) {
                        String userDataValue = localUserDatas.get(dataKey);
                        ReportUtil.libTask(ReportUtil.TAG.JOINRTCROOMANDGETDATA, "localUserData", dataKey + ":" + userDataValue);
                        localUserDatasList.add(RcRtcPbJoinRoom.RCRTCPBKV.newBuilder().setKey(dataKey).setValue(userDataValue).build());
                    }
                }
                RcRtcPbJoinRoom.RCRTCPBKV join_rtcKV = RcRtcPbJoinRoom.RCRTCPBKV.newBuilder().setKey(key).setValue(value).build();
                RcRtcPbJoinRoom.RCRTCPBJoinRequest.Builder builder = RcRtcPbJoinRoom.RCRTCPBJoinRequest.newBuilder().setRoomType(roomType.getRoomType()).setLiveType(roomType.getMediaType()).setUserData(join_rtcKV).setJoinType(joinType == null ? RCRTCJoinType.KICK.getValue() : joinType.getValue()).setSyncData(roomType.getRoomType() == 2);
                if (!localUserDatasList.isEmpty()) {
                    builder.addAllOuterDatas(localUserDatasList);
                }
                RcRtcPbJoinRoom.RCRTCPBJoinRequest joinRequest = builder.build();
                pbBuffer = joinRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_JOIN_DATA, pbBuffer, new IRCRTCFailedCallback(callBack){
                    final /* synthetic */ IRongCoreRTCCallback.IRTCJoinRoomCallbackEx val$callBack;
                    {
                        this.val$callBack = iRTCJoinRoomCallbackEx;
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        if (this.val$callBack != null) {
                            this.val$callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                        }
                    }
                })) break block8;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_JOIN_DATA, true, pbBuffer, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.SyncCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbJoinRoom.RCRTCPBJoinResponse joinResponse = ((RcRtcPbJoinRoom.RCRTCPBJoinResponse.Builder)RcRtcPbJoinRoom.RCRTCPBJoinResponse.newBuilder().mergeFrom(bytes)).build();
                    ReportUtil.libRes(ReportUtil.TAG.JOINRTCROOMANDGETDATA, "roomId|response", roomId, joinResponse.toString());
                    HashMap<String, Object> exParams = new HashMap<String, Object>();
                    String token = joinResponse.getToken();
                    String sessionId = joinResponse.getSessionId();
                    HashMap<String, String> roomDataMap = null;
                    if (joinResponse.getRoomDataList().size() > 0) {
                        roomDataMap = new HashMap<String, String>();
                        for (RcRtcPbJoinRoom.RCRTCPBKV roomData : joinResponse.getRoomDataList()) {
                            roomDataMap.put(roomData.getKey(), roomData.getValue());
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        exParams.put("joinRoomToken", token);
                    }
                    if (!TextUtils.isEmpty((CharSequence)sessionId)) {
                        exParams.put("joinRoomSessionId", sessionId);
                    }
                    if (roomDataMap != null && roomDataMap.size() > 0) {
                        exParams.put("joinRoomData", roomDataMap);
                    }
                    if (joinResponse.hasOfflineKickTime()) {
                        exParams.put("offlineKickTime", joinResponse.getOfflineKickTime());
                    }
                    ArrayList<RTCUser> rtcUserList = new ArrayList<RTCUser>();
                    RTCUser rtcUser = null;
                    HashMap<String, String> data = null;
                    for (RcRtcPbJoinRoom.RCRTCPBUserInfo userInfo : joinResponse.getUserDataList()) {
                        rtcUser = new RTCUser();
                        rtcUser.setUid(userInfo.getUserId());
                        data = new HashMap<String, String>();
                        for (RcRtcPbJoinRoom.RCRTCPBKV rtcKV : userInfo.getUserDataList()) {
                            if (rtcKV != null && !TextUtils.isEmpty((CharSequence)rtcKV.getKey()) && !TextUtils.isEmpty((CharSequence)rtcKV.getValue())) {
                                data.put(rtcKV.getKey(), rtcKV.getValue());
                            }
                            rtcUser.setData(data);
                        }
                        rtcUserList.add(rtcUser);
                    }
                    if (callBack != null) {
                        callBack.onSuccess(rtcUserList, exParams);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.leaveRoom(roomId, null);
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_JOIN_DATA, e.getMessage(), new IRCRTCFailedCallback(){

                        @Override
                        public void onFailed(RTCErrorCode errorCode) {
                            if (callBack != null) {
                                callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)RTCErrorCode.InvalidProtocolMessageError.getValue()));
                            }
                        }
                    });
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                if (callBack != null) {
                    callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                }
            }
        });
    }

    public void joinOtherRoom(final String roomId, RCRTCRoomType roomType, RCRTCJoinType joinType, String key, String value, final IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|uid|roomType|liveType|key|value", roomId, RongCoreClient.getInstance().getCurrentUserId(), roomType.getRoomType(), roomType.getMediaType());
        this.joinRTCRoom(roomId, roomType, null, joinType, key, value, new IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Map<String, Object>>(){

            public void onSuccess(List<RTCUser> rtcUsers, Map<String, Object> exParams) {
                ReportUtil.libRes(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|exParams|code", roomId, exParams == null ? "null" : "length : " + exParams.values().size(), 0);
                if (callBack != null) {
                    callBack.onSuccess(rtcUsers, exParams);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|code|desc", roomId, errorCode.getValue(), errorCode.getMessage());
                if (callBack != null) {
                    callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRTCConfig(String model, String osVersion, long timestamp, String sdkVersion, final IRCRTCResultDataCallback<String> callback) {
        byte[] bytes;
        block7: {
            ReportUtil.libTask(ReportUtil.TAG.RTCCONFIG, "model|osVersion|timestamp|sdkVersion", model, osVersion, timestamp, sdkVersion);
            if (TextUtils.isEmpty((CharSequence)model) || TextUtils.isEmpty((CharSequence)osVersion) || TextUtils.isEmpty((CharSequence)sdkVersion)) {
                ReportUtil.libError(ReportUtil.TAG.RTCCONFIG, "errorCode", RTCErrorCode.RongRTCCodeParameterError.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbConfig.RCRTCPBConfigRequest configRequest = RcRtcPbConfig.RCRTCPBConfigRequest.newBuilder().setDeviceModel(model).setOsVersion(osVersion).setTimestamp(timestamp).setSdkVersion(sdkVersion).build();
                bytes = configRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException("", QRY_SPEC_RTC_CONF, bytes, callback)) break block7;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(null, QRY_SPEC_RTC_CONF, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbConfig.RCRTCPBConfigResponse configResponse = ((RcRtcPbConfig.RCRTCPBConfigResponse.Builder)RcRtcPbConfig.RCRTCPBConfigResponse.newBuilder().mergeFrom(bytes)).build();
                    String config = configResponse.getConfig();
                    ReportUtil.libRes(ReportUtil.TAG.RTCCONFIG, "config", config);
                    if (callback != null) {
                        callback.onSuccess(config);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException("", IMSignalWrapper.QRY_SPEC_RTC_CONF, e.getMessage(), callback);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.RTCCONFIG, "errorCode", errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public String getUserId() {
        return RongCoreClient.getInstance().getCurrentUserId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult rtcSetUserResource(String roomId, RTCStatusDate[] kv, String objNameTotalContent, RTCStatusDate[] content, boolean isSync, IRCRTCResultCallback callback) {
        byte[] bytes;
        SyncIMResultCallback result;
        block7: {
            result = new SyncIMResultCallback(callback, isSync);
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbSetUserResource.RCRTCPBSetUserResource.Builder userResourceBuilder = RcRtcPbSetUserResource.RCRTCPBSetUserResource.newBuilder();
                userResourceBuilder.setObjectName(objNameTotalContent);
                RcRtcPbSetUserResource.RCRTCPBValueInfo valueInfo = null;
                RcRtcPbSetUserResource.RCRTCPBValueInfo contentInfo = null;
                for (RTCStatusDate date : kv) {
                    valueInfo = RcRtcPbSetUserResource.RCRTCPBValueInfo.newBuilder().setKey(date.getKey()).setValue(date.getValue()).build();
                    userResourceBuilder.addValueInfo(valueInfo);
                }
                for (RTCStatusDate statusDate : content) {
                    contentInfo = RcRtcPbSetUserResource.RCRTCPBValueInfo.newBuilder().setKey(statusDate.getKey()).setValue(statusDate.getValue()).build();
                    userResourceBuilder.addContent(contentInfo);
                }
                bytes = userResourceBuilder.build().toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, USER_SET_DATA, bytes, callback)) break block7;
                return result.getResult();
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, USER_SET_DATA, true, bytes, result);
        return result.getResult();
    }

    public void leaveRoom(String roomId, final IRCRTCResultCallback callBack) {
        this.quitRoom(roomId, new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                FinLog.d(IMSignalWrapper.TAG, "exitRTCRoom success ");
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                FinLog.e(IMSignalWrapper.TAG, "exitRTCRoom error = " + errorCode);
                if (callBack != null) {
                    callBack.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public void sendleaveOtherRoomMessage(final String roomId, final IRCRTCResultCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId", roomId);
        this.quitRoom(roomId, new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                ReportUtil.libRes(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|code", roomId, 0);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|code|desc", roomId, errorCode.getValue(), errorCode.getMessage());
                if (callBack != null) {
                    callBack.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quitRoom(String roomId, IRongCoreCallback.ResultCallback<byte[]> callBack) {
        byte[] bytes;
        block5: {
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbQuitRoom.RCRTCPBQuitRoom quitRoom = RcRtcPbQuitRoom.RCRTCPBQuitRoom.newBuilder().setRoomId(roomId).build();
                bytes = quitRoom.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_EXIT, bytes, new IRCRTCFailedCallback(callBack){
                    final /* synthetic */ IRongCoreCallback.ResultCallback val$callBack;
                    {
                        this.val$callBack = resultCallback;
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        if (this.val$callBack != null) {
                            this.val$callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                        }
                    }
                })) break block5;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_EXIT, true, bytes, callBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rtcSetData(String roomId, int type, APIType apiType, String key, String value, MessageContent message, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block7: {
            if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            Pair<String, String> res = this.parseMessageContent(message);
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbSetData.RCRTCPBSetData rtcSetData = RcRtcPbSetData.RCRTCPBSetData.newBuilder().setDataType(type).setApiType(apiType.getValue()).setKeys(key).setValue(value).setObjectName(res.first == null ? "" : (String)res.first).setContent(res.second == null ? "" : (String)res.second).build();
                bytes = rtcSetData.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_SET_DATA, bytes, callback)) break block7;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_SET_DATA, false, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public void setAttributeValue(String roomId, RCAttributeType type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        this.rtcSetData(roomId, type.getValue(), APIType.OUTER_DATA, key, value, message, callback);
    }

    private Pair<String, String> parseMessageContent(MessageContent message) {
        String objectName = "";
        String messageContent = "";
        if (message != null) {
            MessageTag annotation = message.getClass().getAnnotation(MessageTag.class);
            objectName = annotation.value();
            messageContent = new String(message.encode());
        }
        return Pair.create((Object)objectName, (Object)messageContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, MessageContent message, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block7: {
            String[] keys = null;
            if (attributeKeys != null && attributeKeys.size() > 0) {
                keys = new String[attributeKeys.size()];
                attributeKeys.toArray(keys);
            } else {
                keys = new String[]{};
            }
            Pair<String, String> res = this.parseMessageContent(message);
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbQueryData.RCRTCPBQueryDataRequest rtcQueryDataRequest = RcRtcPbQueryData.RCRTCPBQueryDataRequest.newBuilder().setApiType(APIType.OUTER_DATA.getValue()).setDataType(type.getValue()).addAllKeys(Arrays.asList(keys)).setObjectName(res.first == null ? "" : (String)res.first).setContent(res.second == null ? "" : (String)res.second).build();
                bytes = rtcQueryDataRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_DEL_DATA, bytes, callback)) break block7;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_DEL_DATA, false, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAttributes(final String roomId, RCAttributeType type, List<String> attributeKeys, APIType apiType, final IRCRTCResultDataCallback<Map<String, String>> callback) {
        byte[] bytes;
        block7: {
            ReportUtil.libTask(ReportUtil.TAG.GETATTRIBUTE, "roomId|RCAttributeType|apiType", roomId, type.getValue(), apiType.getValue());
            String[] keys = null;
            if (attributeKeys != null && attributeKeys.size() > 0) {
                keys = new String[attributeKeys.size()];
                attributeKeys.toArray(keys);
            } else {
                keys = new String[]{};
            }
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbQueryData.RCRTCPBQueryDataRequest rtcQueryDataRequest = RcRtcPbQueryData.RCRTCPBQueryDataRequest.newBuilder().setApiType(apiType.getValue()).setDataType(type.getValue()).addAllKeys(Arrays.asList(keys)).build();
                bytes = rtcQueryDataRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_QRY_DATA, bytes, callback)) break block7;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_QRY_DATA, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbQueryData.RCRTCPBQueryDataResponse queryDataResponse = ((RcRtcPbQueryData.RCRTCPBQueryDataResponse.Builder)RcRtcPbQueryData.RCRTCPBQueryDataResponse.newBuilder().mergeFrom(bytes)).build();
                    int size = queryDataResponse.getMapList().size();
                    HashMap<String, String> hashMap = new HashMap<String, String>(size);
                    for (RcRtcPbQueryData.RCRTCPBQueryDataResponse.RCRTCPBQryDataMap rtcQryDataMap : queryDataResponse.getMapList()) {
                        hashMap.put(rtcQryDataMap.getKey(), rtcQryDataMap.getValue());
                    }
                    ReportUtil.libRes(ReportUtil.TAG.GETATTRIBUTE, "queryDataResponse", ((Object)hashMap).toString());
                    if (callback != null) {
                        callback.onSuccess(hashMap);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_QRY_DATA, e.getMessage(), callback);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.GETATTRIBUTE, "code", errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    private String attributeListToString(List<String> attributeKeys) {
        String keyStr = "";
        if (!RongRTCUtils.isEmpty(attributeKeys)) {
            JSONArray jsonArray = new JSONArray();
            for (String attributeKey : attributeKeys) {
                jsonArray.put((Object)attributeKey);
            }
            keyStr = jsonArray.toString();
        }
        return keyStr;
    }

    public void sendIMSignal(String roomId, MessageContent messageContent, IRongCoreCallback.ISendMessageCallback callback) {
        RongCoreClient.getInstance().sendMessage(Conversation.ConversationType.RTC_ROOM, roomId, messageContent, "", "", callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, int timeoutTime, final String inviteSessionId, String inviteInfo, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block5: {
            ReportUtil.libTask(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "inviteInfo"), inviteSessionId, inviteInfo);
            bytes = new byte[]{};
            try {
                RcRtcPbLiveInvite.RCRTCPBLiveInvite liveInvite = RcRtcPbLiveInvite.RCRTCPBLiveInvite.newBuilder().setInviteeRoomId(inviteeRoomId).setInviteeUserId(inviteeUserId).setTimeoutTime(timeoutTime).setInviteSessionId(inviteSessionId).setInviteInfo(inviteInfo).build();
                bytes = liveInvite.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(mainRoomId, RTC_INVITE, bytes, callback)) break block5;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(mainRoomId, RTC_INVITE, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                ReportUtil.libRes(ReportUtil.TAG.REQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "code"), inviteSessionId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, String localUserId, final String inviteSessionId, String extra, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block10: {
            String inviteInfo = "";
            JSONObject obj = new JSONObject();
            try {
                obj.putOpt("inviterRoomId", (Object)mainRoomId);
                obj.putOpt("inviterUserId", (Object)localUserId);
                obj.putOpt("inviteeRoomId", (Object)inviteeRoomId);
                obj.putOpt("inviteeUserId", (Object)inviteeUserId);
                if (!TextUtils.isEmpty((CharSequence)extra)) {
                    obj.putOpt("extra", (Object)extra);
                }
                inviteInfo = obj.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (TextUtils.isEmpty((CharSequence)inviteInfo)) {
                ReportUtil.libError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "code"), new Object[]{inviteSessionId, RTCErrorCode.RongRTCCodeParameterError});
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            ReportUtil.libTask(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "inviteInfo"), inviteSessionId, inviteInfo);
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbLiveCancel.RCRTCPBLiveCancel liveCancel = RcRtcPbLiveCancel.RCRTCPBLiveCancel.newBuilder().setInviteeUserId(inviteeUserId).setInviteeRoomId(inviteeRoomId).setInviteInfo(inviteInfo).setInviteSessionId(inviteSessionId).build();
                bytes = liveCancel.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(mainRoomId, RTC_CANCEL_INVITE, bytes, callback)) break block10;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(mainRoomId, RTC_CANCEL_INVITE, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                ReportUtil.libRes(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "code"), inviteSessionId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseJoinOtherRoom(String inviterRoomId, String inviterUserId, boolean agree, String extra, boolean inviteeUserAutoMix, String mainRoomId, InviteInfo inviteInfo, String key, final String inviteSessionId, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block12: {
            int answerCode = agree ? 1 : 0;
            String value = "";
            String content = "";
            if (agree) {
                PKInfo info = new PKInfo(inviterUserId, inviterRoomId, inviteInfo.getInviterUserAutoMix(), inviteInfo.getInviteeUserId(), mainRoomId, inviteeUserAutoMix, inviteSessionId);
                value = info.getJSON();
            }
            JSONObject obj_content = new JSONObject();
            try {
                obj_content.putOpt("inviteeUserId", (Object)inviteInfo.getInviteeUserId());
                obj_content.putOpt("inviteeRoomId", (Object)mainRoomId);
                obj_content.putOpt("inviterRoomId", (Object)inviterRoomId);
                obj_content.putOpt("inviterUserId", (Object)inviterUserId);
                obj_content.putOpt("inviteeUserAutoMix", (Object)inviteeUserAutoMix);
                if (!TextUtils.isEmpty((CharSequence)extra)) {
                    obj_content.putOpt("extra", (Object)extra);
                }
                if (agree) {
                    obj_content.putOpt("MultiRoomKey", (Object)key);
                    obj_content.putOpt("MultiRoomValue", (Object)value);
                }
                content = obj_content.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ReportUtil.libTask(ReportUtil.TAG.RESPONSEJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "key", "value", "content"), inviteSessionId, key, value, content);
            if (TextUtils.isEmpty((CharSequence)content)) {
                ReportUtil.libError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId|code", inviteSessionId, RTCErrorCode.RongRTCCodeParameterError.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbLiveAnswer.RCRTCPBLiveAnswer liveAnswer = RcRtcPbLiveAnswer.RCRTCPBLiveAnswer.newBuilder().setAnswerCode(answerCode).setInviterUserId(inviterUserId).setInviterRoomId(inviterRoomId).setInviteSessionId(inviteSessionId).setContent(content).setKey(key).setValue(value).build();
                bytes = liveAnswer.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(mainRoomId, RTC_INVITE_ANSWER, bytes, callback)) break block12;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(mainRoomId, RTC_INVITE_ANSWER, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                ReportUtil.libRes(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId|code", inviteSessionId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishOtherRoom(final String otherRoomId, String extra, final String mainRoomId, String inviteSessionId, String localUserId, String[] keys, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block10: {
            String content = "";
            JSONObject obj_content = new JSONObject();
            try {
                obj_content.putOpt("inviteeRoomId", (Object)mainRoomId);
                obj_content.putOpt("inviterRoomId", (Object)otherRoomId);
                obj_content.putOpt("userId", (Object)localUserId);
                if (!TextUtils.isEmpty((CharSequence)extra)) {
                    obj_content.putOpt("extra", (Object)extra);
                }
                content = obj_content.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ReportUtil.libTask(ReportUtil.TAG.FINISHOTHERROOM, "roomId|mainRoomId|keys", otherRoomId, mainRoomId, Arrays.toString(keys));
            if (TextUtils.isEmpty((CharSequence)content)) {
                ReportUtil.libError(ReportUtil.TAG.FINISHOTHERROOM, "roomId|mainRoomId|code", otherRoomId, mainRoomId, RTCErrorCode.RongRTCCodeParameterError.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbLiveHangup.RCRTCPBLiveHangup hangup = RcRtcPbLiveHangup.RCRTCPBLiveHangup.newBuilder().setOtherRoomId(otherRoomId).setInviteSessionId(inviteSessionId).setContent(content).addAllKey(Arrays.asList(keys)).build();
                bytes = hangup.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(mainRoomId, RTC_END_INVITE, bytes, callback)) break block10;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(mainRoomId, RTC_END_INVITE, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                ReportUtil.libRes(ReportUtil.TAG.FINISHOTHERROOM, mainRoomId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.FINISHOTHERROOM, "roomId|mainRoomId|code", otherRoomId, mainRoomId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewerJoinRoom(final String roomId, RCRTCRoomType roomType, final IRCRTCResultDataCallback<Object[]> callback) {
        byte[] bytes;
        block10: {
            ReportUtil.libTask(ReportUtil.TAG.VIEWERJOINROOM, "roomId|uid|roomType", new Object[]{roomId, this.getUserId(), roomType});
            if (roomType == RCRTCRoomType.MEETING) {
                ReportUtil.libError(ReportUtil.TAG.VIEWERJOINROOM, "roomId|code|desc", new Object[]{roomId, RTCErrorCode.RongRTCCodeParameterError, "Wrong room type"});
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            RcRtcPbViewerJoinRoom.RCRTCPBBroadcastType broadcastType = RcRtcPbViewerJoinRoom.RCRTCPBBroadcastType.VIDEO;
            RcRtcPbViewerJoinRoom.RCRTCPBRoomType rcrtcpbRoomType = RcRtcPbViewerJoinRoom.RCRTCPBRoomType.LIVE_BROADCAST;
            if (roomType == RCRTCRoomType.LIVE_AUDIO) {
                broadcastType = RcRtcPbViewerJoinRoom.RCRTCPBBroadcastType.AUDIO;
            } else if (roomType == RCRTCRoomType.LIVE_AUDIO_VIDEO) {
                broadcastType = RcRtcPbViewerJoinRoom.RCRTCPBBroadcastType.VIDEO;
            }
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbViewerJoinRoom.RCRTCPBViewerJoinRoomRequest joinRoomRequest = RcRtcPbViewerJoinRoom.RCRTCPBViewerJoinRoomRequest.newBuilder().setRoomType(rcrtcpbRoomType).setBroadcastType(broadcastType).build();
                bytes = joinRoomRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, VIEWER_JOIN, bytes, callback)) break block10;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, VIEWER_JOIN, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbViewerJoinRoom.RCRTCPBViewerJoinRoomResponse joinRoomResponse = ((RcRtcPbViewerJoinRoom.RCRTCPBViewerJoinRoomResponse.Builder)RcRtcPbViewerJoinRoom.RCRTCPBViewerJoinRoomResponse.newBuilder().mergeFrom(bytes)).build();
                    String token = joinRoomResponse.getToken();
                    if (TextUtils.isEmpty((CharSequence)token)) {
                        IMSignalWrapper.this.viewerQuitRoom(roomId, null);
                        ReportUtil.libError(ReportUtil.TAG.VIEWERJOINROOM, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue(), "The token received is empty.");
                        if (callback != null) {
                            callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                        }
                        return;
                    }
                    HashMap<String, String> roomKVMap = new HashMap<String, String>(joinRoomResponse.getEntriesCount());
                    for (RcRtcPbPullKv.RCRTCPBKVEntity entity : joinRoomResponse.getEntriesList()) {
                        roomKVMap.put(entity.getKey(), entity.getValue());
                    }
                    Object[] objects = new Object[]{token, roomKVMap};
                    ReportUtil.libRes(ReportUtil.TAG.VIEWERJOINROOM, "roomId|response", roomId, joinRoomResponse.toString());
                    if (callback != null) {
                        callback.onSuccess(objects);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.VIEWER_JOIN, e.getMessage(), callback);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                ReportUtil.libError(ReportUtil.TAG.VIEWERJOINROOM, "roomId|code|desc", roomId, coreErrorCode.getValue(), coreErrorCode.getMessage());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(coreErrorCode.code));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewerQuitRoom(final String roomId, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block5: {
            ReportUtil.libTask(ReportUtil.TAG.VIEWERQUITROOM, "roomId|uid", roomId, this.getUserId());
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbQuitRoom.RCRTCPBQuitRoom quitRoom = RcRtcPbQuitRoom.RCRTCPBQuitRoom.newBuilder().setRoomId(roomId).build();
                bytes = quitRoom.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, VIEWER_EXIT, bytes, callback)) break block5;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, VIEWER_EXIT, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                ReportUtil.libRes(ReportUtil.TAG.VIEWERQUITROOM, "roomId|code", roomId, 0);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                ReportUtil.libError(ReportUtil.TAG.VIEWERQUITROOM, "roomId|code|desc", roomId, coreErrorCode.getValue(), coreErrorCode.getMessage());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(coreErrorCode.code));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullKV(final String roomId, final IRCRTCResultDataCallback<Map<String, String>> callback) {
        byte[] bytes;
        block7: {
            ReportUtil.libTask(ReportUtil.TAG.PULL_KV, "roomId|uid", roomId, this.getUserId());
            if (TextUtils.isEmpty((CharSequence)roomId)) {
                ReportUtil.libError(ReportUtil.TAG.PULL_KV, "roomId|code|desc", new Object[]{roomId, RTCErrorCode.RongRTCCodeParameterError, "roomId is empty."});
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbPullKv.RCRTCPBPullKVRequest pullKVRequest = RcRtcPbPullKv.RCRTCPBPullKVRequest.newBuilder().setRoomId(roomId).setTimestamp(0L).build();
                bytes = pullKVRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(null, RTC_PULL_KV, bytes, callback)) break block7;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(null, RTC_PULL_KV, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbPullKv.RCRTCPBPullKVResponse pullKVResponse = ((RcRtcPbPullKv.RCRTCPBPullKVResponse.Builder)RcRtcPbPullKv.RCRTCPBPullKVResponse.newBuilder().mergeFrom(bytes)).build();
                    if (pullKVResponse != null) {
                        ReportUtil.libRes(ReportUtil.TAG.PULL_KV, "roomId|response", roomId, pullKVResponse.toString());
                        if (callback != null) {
                            HashMap<String, String> roomKVMap = new HashMap<String, String>(pullKVResponse.getEntriesCount());
                            for (RcRtcPbPullKv.RCRTCPBKVEntity entity : pullKVResponse.getEntriesList()) {
                                roomKVMap.put(entity.getKey(), entity.getValue());
                            }
                            callback.onSuccess(roomKVMap);
                        }
                    } else {
                        ReportUtil.libError(ReportUtil.TAG.PULL_KV, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue(), "The return value of pull kV is null.");
                        if (callback != null) {
                            callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                        }
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_PULL_KV, e.getMessage(), callback);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                ReportUtil.libError(ReportUtil.TAG.PULL_KV, "roomId|code|desc", roomId, coreErrorCode.getValue(), coreErrorCode.getMessage());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(coreErrorCode.code));
                }
            }
        });
    }

    public void setRTCRoomEventListener(final SignalEventListener signalEventListener) {
        IMLibRTCClient.getInstance().SetRTCRoomEventListener(new IRTCRoomEventListener.Stub(){

            public void OnEventReceived(byte[] pbBuffer) {
                if (signalEventListener != null) {
                    signalEventListener.OnEventReceived(pbBuffer);
                }
            }
        });
    }

    private void invalidProtocolException(String roomId, String signalingName, String desc, IRCRTCFailedCallback callback) {
        ReportUtil.libError(ReportUtil.TAG.INVALID_PROTOCOL, "roomId|signalingName|desc", roomId, signalingName, desc);
        if (callback != null) {
            callback.onFailed(RTCErrorCode.InvalidProtocolMessageError);
        }
    }

    private boolean protocolIllegalStateException(String roomId, String signalingName, byte[] bytes, IRCRTCFailedCallback callback) {
        if (bytes == null || bytes.length == 0) {
            ReportUtil.libError(ReportUtil.TAG.INVALID_PROTOCOL, "roomId|signalingName|desc", roomId, signalingName, "Did not write as much data as expected.");
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRTCUserState(String roomId, String state, final IRCRTCResultCallback callback) {
        byte[] bytes;
        block7: {
            if (TextUtils.isEmpty((CharSequence)state)) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                }
                return;
            }
            bytes = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbSetUserState.RCRTCPBSetUserState setUserState = RcRtcPbSetUserState.RCRTCPBSetUserState.newBuilder().setState(state).build();
                bytes = setUserState.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_USER_STATE, bytes, callback)) break block7;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_USER_STATE, true, bytes, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode coreErrorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(coreErrorCode.code));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchRole(final String roomId, int role, RCRTCRoomType roomType, String key, String value, final IRTCSwitchRoleCallback callBack) {
        byte[] pbBuffer;
        block5: {
            pbBuffer = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbJoinRoom.RCRTCPBKV join_rtcKV = RcRtcPbJoinRoom.RCRTCPBKV.newBuilder().setKey(key).setValue(value).build();
                RcRtcPbJoinRoom.RCRTCPBJoinRequest joinRequest = RcRtcPbJoinRoom.RCRTCPBJoinRequest.newBuilder().setRoomType(roomType.getRoomType()).setLiveType(roomType.getMediaType()).setUserData(join_rtcKV).setSyncData(roomType.getRoomType() == 2).setIdentitychangeType(role).build();
                pbBuffer = joinRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_IDENTITY_CHANGE, pbBuffer, new IRCRTCFailedCallback(callBack){
                    final /* synthetic */ IRTCSwitchRoleCallback val$callBack;
                    {
                        this.val$callBack = iRTCSwitchRoleCallback;
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        if (this.val$callBack != null) {
                            this.val$callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                        }
                    }
                })) break block5;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_IDENTITY_CHANGE, true, pbBuffer, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.SyncCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbIdentityChange.RCRTCPBIdentityChangeResponse response = ((RcRtcPbIdentityChange.RCRTCPBIdentityChangeResponse.Builder)RcRtcPbIdentityChange.RCRTCPBIdentityChangeResponse.newBuilder().mergeFrom(bytes)).build();
                    HashMap<String, Object> exParams = new HashMap<String, Object>();
                    String token = response.getToken();
                    String sessionId = response.getSessionId();
                    HashMap<String, String> roomDataMap = null;
                    if (response.getRoomDataList().size() > 0) {
                        roomDataMap = new HashMap<String, String>();
                        for (RcRtcPbJoinRoom.RCRTCPBKV roomData : response.getRoomDataList()) {
                            roomDataMap.put(roomData.getKey(), roomData.getValue());
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        exParams.put("joinRoomToken", token);
                    }
                    if (!TextUtils.isEmpty((CharSequence)sessionId)) {
                        exParams.put("joinRoomSessionId", sessionId);
                    }
                    if (roomDataMap != null && roomDataMap.size() > 0) {
                        exParams.put("joinRoomData", roomDataMap);
                    }
                    if (response.hasOfflineKickTime()) {
                        exParams.put("offlineKickTime", response.getOfflineKickTime());
                    }
                    ArrayList<RTCUser> rtcUserList = new ArrayList<RTCUser>();
                    RTCUser rtcUser = null;
                    HashMap<String, String> data = null;
                    for (RcRtcPbJoinRoom.RCRTCPBUserInfo userInfo : response.getUserDataList()) {
                        rtcUser = new RTCUser();
                        rtcUser.setUid(userInfo.getUserId());
                        data = new HashMap<String, String>();
                        for (RcRtcPbJoinRoom.RCRTCPBKV rtcKV : userInfo.getUserDataList()) {
                            if (rtcKV != null && !TextUtils.isEmpty((CharSequence)rtcKV.getKey()) && !TextUtils.isEmpty((CharSequence)rtcKV.getValue())) {
                                data.put(rtcKV.getKey(), rtcKV.getValue());
                            }
                            rtcUser.setData(data);
                        }
                        rtcUserList.add(rtcUser);
                    }
                    HashMap<String, String> roomKVMap = new HashMap<String, String>(response.getEntriesCount());
                    for (RcRtcPbPullKv.RCRTCPBKVEntity entity : response.getEntriesList()) {
                        roomKVMap.put(entity.getKey(), entity.getValue());
                    }
                    if (callBack != null) {
                        callBack.onSuccess(rtcUserList, exParams, roomKVMap);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.leaveRoom(roomId, null);
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_JOIN_DATA, e.getMessage(), new IRCRTCFailedCallback(){

                        @Override
                        public void onFailed(RTCErrorCode errorCode) {
                            if (callBack != null) {
                                callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)RTCErrorCode.InvalidProtocolMessageError.getValue()));
                            }
                        }
                    });
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                if (callBack != null) {
                    callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRTCUserData(final String roomId, final IRongCoreRTCCallback.IRTCJoinRoomCallbackEx<Object[]> callBack) {
        byte[] pbBuffer;
        block5: {
            ReportUtil.libTask(ReportUtil.TAG.GETRTCUSERDATA, "roomId", roomId);
            pbBuffer = EMPTY_ELEMENT_DATA;
            try {
                RcRtcPbUlistData.RCRTCPBUserListDataRequest userListDataRequest = RcRtcPbUlistData.RCRTCPBUserListDataRequest.newBuilder().setOrder(1).build();
                pbBuffer = userListDataRequest.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!this.protocolIllegalStateException(roomId, RTC_U_DATA, pbBuffer, new IRCRTCFailedCallback(callBack){
                    final /* synthetic */ IRongCoreRTCCallback.IRTCJoinRoomCallbackEx val$callBack;
                    {
                        this.val$callBack = iRTCJoinRoomCallbackEx;
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        if (this.val$callBack != null) {
                            this.val$callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                        }
                    }
                })) break block5;
                return;
            }
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_U_DATA, true, pbBuffer, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbUlistData.RCRTCPBUserListDataResponse userListDataResponse = ((RcRtcPbUlistData.RCRTCPBUserListDataResponse.Builder)RcRtcPbUlistData.RCRTCPBUserListDataResponse.newBuilder().mergeFrom(bytes)).build();
                    ArrayList<Object> exParams = new ArrayList<Object>(3);
                    String token = userListDataResponse.getToken();
                    String sessionId = userListDataResponse.getSessionId();
                    HashMap<String, String> roomDataMap = null;
                    if (userListDataResponse.getRoomInfoList().size() > 0) {
                        roomDataMap = new HashMap<String, String>();
                        for (RcRtcPbJoinRoom.RCRTCPBKV roomData : userListDataResponse.getRoomInfoList()) {
                            roomDataMap.put(roomData.getKey(), roomData.getValue());
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        exParams.add(token);
                    }
                    if (!TextUtils.isEmpty((CharSequence)sessionId)) {
                        exParams.add(sessionId);
                    }
                    if (roomDataMap != null && roomDataMap.size() > 0) {
                        exParams.add(roomDataMap);
                    }
                    ArrayList<RTCUser> rtcUserList = new ArrayList<RTCUser>();
                    RTCUser rtcUser = null;
                    HashMap<String, String> data = null;
                    for (RcRtcPbJoinRoom.RCRTCPBUserInfo userInfo : userListDataResponse.getUsersList()) {
                        rtcUser = new RTCUser();
                        rtcUser.setUid(userInfo.getUserId());
                        data = new HashMap<String, String>();
                        for (RcRtcPbJoinRoom.RCRTCPBKV rtcKV : userInfo.getUserDataList()) {
                            if (rtcKV != null && !TextUtils.isEmpty((CharSequence)rtcKV.getKey()) && !TextUtils.isEmpty((CharSequence)rtcKV.getValue())) {
                                data.put(rtcKV.getKey(), rtcKV.getValue());
                            }
                            rtcUser.setData(data);
                        }
                        rtcUserList.add(rtcUser);
                    }
                    ReportUtil.libRes(ReportUtil.TAG.GETRTCUSERDATA, "roomId|rtcUserSize", roomId, rtcUserList.size());
                    if (callBack != null) {
                        callBack.onSuccess(rtcUserList, (Object)exParams.toArray());
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_U_DATA, e.getMessage(), new IRCRTCFailedCallback(){

                        @Override
                        public void onFailed(RTCErrorCode errorCode) {
                            if (callBack != null) {
                                callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)RTCErrorCode.InvalidProtocolMessageError.getValue()));
                            }
                        }
                    });
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.GETRTCUSERDATA, "roomId|code", roomId, errorCode.getValue());
                if (callBack != null) {
                    callBack.onError(IRongCoreEnum.CoreErrorCode.valueOf((int)errorCode.getValue()));
                }
            }
        });
    }

    public void queryJoinedRoom(final String roomId, String userId, final IRCRTCResultDataCallback<RCRTCJoinedRoomInfo[]> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.QUERY_JOINED_ROOM, "roomId|userId", roomId, userId);
        byte[] pbBuffer = EMPTY_ELEMENT_DATA;
        try {
            RcRtcPbQueryJoined.RCRTCPBQueryJoinedRequest queryUserJoinStatus = RcRtcPbQueryJoined.RCRTCPBQueryJoinedRequest.newBuilder().setUserId(userId).build();
            pbBuffer = queryUserJoinStatus.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.protocolIllegalStateException(roomId, RTC_QUERY_IN_ROOM_STATE, pbBuffer, new IRCRTCFailedCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        })) {
            return;
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, RTC_QUERY_IN_ROOM_STATE, true, pbBuffer, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.SyncCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    if (bytes == null) {
                        if (callBack != null) {
                            callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                        }
                        ReportUtil.libError(ReportUtil.TAG.QUERY_JOINED_ROOM, "code", RTCErrorCode.RongRTCCodeParameterError.getValue());
                        return;
                    }
                    RcRtcPbQueryJoined.RCRTCPBQueryJoinedResponse info = ((RcRtcPbQueryJoined.RCRTCPBQueryJoinedResponse.Builder)RcRtcPbQueryJoined.RCRTCPBQueryJoinedResponse.newBuilder().mergeFrom(bytes)).build();
                    String response = "";
                    int count = info.getInfoCount();
                    RCRTCJoinedRoomInfo[] joinedRoomInfo = new RCRTCJoinedRoomInfo[count];
                    JSONArray jsonArray = new JSONArray();
                    JSONObject jsonObject = null;
                    RCRTCJoinedRoomInfo roomInfo = null;
                    String deviceId = "";
                    String tmpRoomId = "";
                    long joinTime = 0L;
                    for (int i = 0; i < count; ++i) {
                        jsonObject = new JSONObject();
                        deviceId = info.getInfo(i).getDeviceId();
                        tmpRoomId = info.getInfo(i).getRoomId();
                        joinTime = info.getInfo(i).getJoinTime();
                        jsonObject.putOpt("deviceId", (Object)deviceId);
                        jsonObject.putOpt("roomId", (Object)tmpRoomId);
                        jsonObject.putOpt("joinTime", (Object)joinTime);
                        joinedRoomInfo[i] = roomInfo = new RCRTCJoinedRoomInfo(deviceId, tmpRoomId, joinTime);
                        jsonArray.put((Object)jsonObject);
                    }
                    response = jsonArray.toString();
                    ReportUtil.libRes(ReportUtil.TAG.QUERY_JOINED_ROOM, "response", response);
                    if (callBack == null) {
                        return;
                    }
                    callBack.onSuccess(joinedRoomInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_QUERY_IN_ROOM_STATE, e.getMessage(), new IRCRTCFailedCallback(){

                        @Override
                        public void onFailed(RTCErrorCode errorCode) {
                            if (callBack != null) {
                                callBack.onFailed(errorCode);
                            }
                        }
                    });
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode e) {
                ReportUtil.libError(ReportUtil.TAG.QUERY_JOINED_ROOM, "code", e.code);
                if (callBack == null) {
                    return;
                }
                callBack.onFailed(RTCErrorCode.valueOf(e.code));
            }
        });
    }

    public void getProbeRTCToken(final IRCRTCResultDataCallback<Pair<String, String>> callback) {
        final String roomId = this.getUserId();
        ReportUtil.libTask(ReportUtil.TAG.GETPROBERTCTOKEN, "userId", roomId);
        byte[] pbBuffer = EMPTY_ELEMENT_DATA;
        try {
            RcRtcPbToken.RCRTCPBTokenRequest tokenRequest = RcRtcPbToken.RCRTCPBTokenRequest.newBuilder().setRoomType(0).setLiveType(0).build();
            pbBuffer = tokenRequest.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.protocolIllegalStateException(roomId, PROBE_RTC_TOKEN, pbBuffer, callback)) {
            return;
        }
        IMLibRTCClient.getInstance().RTCSignaling(roomId, PROBE_RTC_TOKEN, true, pbBuffer, (IRongCoreCallback.ResultCallback)new IRongCoreCallback.ResultCallback<byte[]>(){

            public void onSuccess(byte[] bytes) {
                try {
                    RcRtcPbToken.RCRTCPBTokenResponse tokenResponse = ((RcRtcPbToken.RCRTCPBTokenResponse.Builder)RcRtcPbToken.RCRTCPBTokenResponse.newBuilder().mergeFrom(bytes)).build();
                    String token = tokenResponse.getToken();
                    ReportUtil.libRes(ReportUtil.TAG.GETPROBERTCTOKEN, "token", token);
                    if (callback != null) {
                        callback.onSuccess(Pair.create((Object)IMSignalWrapper.this.getUserId(), (Object)token));
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                    IMSignalWrapper.this.invalidProtocolException(roomId, IMSignalWrapper.RTC_TOKEN, e.getMessage(), callback);
                }
            }

            public void onError(IRongCoreEnum.CoreErrorCode e) {
                ReportUtil.libError(ReportUtil.TAG.GETPROBERTCTOKEN, "code|desc", e.getValue(), e.getMessage());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(e.getValue()));
                }
            }
        });
    }
}

