/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.stream;

import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileDownloadRandomAccessFile
implements FileDownloadOutputStream {
    private final BufferedOutputStream out;
    private final FileDescriptor fd;
    private final RandomAccessFile randomAccess;

    FileDownloadRandomAccessFile(File file) throws IOException {
        this.randomAccess = new RandomAccessFile(file, "rw");
        this.fd = this.randomAccess.getFD();
        this.out = new BufferedOutputStream(new FileOutputStream(this.randomAccess.getFD()));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flushAndSync() throws IOException {
        this.out.flush();
        this.fd.sync();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.randomAccess.close();
    }

    @Override
    public void seek(long offset) throws IOException {
        this.randomAccess.seek(offset);
    }

    @Override
    public void setLength(long totalBytes) throws IOException {
        this.randomAccess.setLength(totalBytes);
    }

    public static class Creator
    implements FileDownloadHelper.OutputStreamCreator {
        @Override
        public FileDownloadOutputStream create(File file) throws IOException {
            return new FileDownloadRandomAccessFile(file);
        }

        @Override
        public boolean supportSeek() {
            return true;
        }
    }
}

