/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.BindingXJSFunctionRegister;
import com.alibaba.android.bindingx.core.BindingXPropertyInterceptor;
import com.alibaba.android.bindingx.core.IEventHandler;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.Expression;
import com.alibaba.android.bindingx.core.internal.ExpressionHolder;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import com.alibaba.android.bindingx.core.internal.JSFunctionInterface;
import com.alibaba.android.bindingx.core.internal.JSMath;
import com.alibaba.android.bindingx.core.internal.TimingFunctions;
import com.alibaba.android.bindingx.core.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractEventHandler
implements IEventHandler {
    protected volatile Map<String, List<ExpressionHolder>> mExpressionHoldersMap;
    protected volatile Map<String, ExpressionPair> mInterceptorsMap;
    protected BindingXCore.JavaScriptCallback mCallback;
    protected final Map<String, Object> mScope = new HashMap<String, Object>();
    protected String mInstanceId;
    protected String mAnchorInstanceId;
    protected String mToken;
    protected Context mContext;
    protected PlatformManager mPlatformManager;
    protected ExpressionPair mExitExpressionPair;
    protected Object[] mExtensionParams;
    private Cache<String, Expression> mCachedExpressionMap = new Cache(16);
    private double previewLength = 0.0;

    public AbstractEventHandler(Context context, PlatformManager manager, Object ... extension) {
        this.mContext = context;
        this.mPlatformManager = manager;
        this.mInstanceId = extension != null && extension.length > 0 && extension[0] instanceof String ? (String)extension[0] : null;
    }

    @Override
    public void setAnchorInstanceId(String anchorInstanceId) {
        this.mAnchorInstanceId = anchorInstanceId;
    }

    @Override
    public void setGlobalConfig(@Nullable Map<String, Object> globalConfig) {
    }

    @Override
    public void onBindExpression(@NonNull String eventType, @Nullable Map<String, Object> globalConfig, @Nullable ExpressionPair exitExpressionPair, @NonNull List<Map<String, Object>> expressionArgs, @Nullable BindingXCore.JavaScriptCallback callback) {
        this.clearExpressions();
        this.transformArgs(eventType, expressionArgs);
        this.mCallback = callback;
        this.mExitExpressionPair = exitExpressionPair;
        if (!this.mScope.isEmpty()) {
            this.mScope.clear();
        }
        this.applyFunctionsToScope();
    }

    @Override
    @CallSuper
    public void onDestroy() {
        this.mCachedExpressionMap.clear();
        BindingXPropertyInterceptor.getInstance().clearCallbacks();
    }

    private void applyFunctionsToScope() {
        JSMath.applyToScope(this.mScope);
        TimingFunctions.applyToScope(this.mScope);
        Map<String, JSFunctionInterface> customFunctions = BindingXJSFunctionRegister.getInstance().getJSFunctions();
        if (customFunctions != null && !customFunctions.isEmpty()) {
            this.mScope.putAll(customFunctions);
        }
    }

    private void transformArgs(@NonNull String eventType, @NonNull List<Map<String, Object>> originalArgs) {
        if (this.mExpressionHoldersMap == null) {
            this.mExpressionHoldersMap = new HashMap<String, List<ExpressionHolder>>();
        }
        for (Map<String, Object> arg : originalArgs) {
            String targetRef = Utils.getStringValue(arg, "element");
            String targetInstanceId = Utils.getStringValue(arg, "instanceId");
            String property = Utils.getStringValue(arg, "property");
            ExpressionPair expressionPair = Utils.getExpressionPair(arg, "expression");
            Object configObj = arg.get("config");
            Map<String, Object> configMap = null;
            if (configObj != null && configObj instanceof Map) {
                try {
                    configMap = Utils.toMap(new JSONObject((Map)configObj));
                }
                catch (Exception e) {
                    LogProxy.e("parse config failed", e);
                }
            }
            if (TextUtils.isEmpty((CharSequence)targetRef) || TextUtils.isEmpty((CharSequence)property) || expressionPair == null) {
                LogProxy.e("skip illegal binding args[" + targetRef + "," + property + "," + expressionPair + "]");
                continue;
            }
            ExpressionHolder holder = new ExpressionHolder(targetRef, targetInstanceId, expressionPair, property, eventType, configMap);
            List<ExpressionHolder> holders = this.mExpressionHoldersMap.get(targetRef);
            if (holders == null) {
                holders = new ArrayList<ExpressionHolder>(4);
                this.mExpressionHoldersMap.put(targetRef, holders);
                holders.add(holder);
                continue;
            }
            if (holders.contains(holder)) continue;
            holders.add(holder);
        }
    }

    protected boolean evaluateExitExpression(ExpressionPair exitExpression, @NonNull Map<String, Object> scope) {
        boolean exit = false;
        if (ExpressionPair.isValid(exitExpression)) {
            Expression expression = new Expression(exitExpression.transformed);
            try {
                exit = (Boolean)expression.execute(scope);
            }
            catch (Exception e) {
                LogProxy.e("evaluateExitExpression failed. ", e);
            }
        }
        if (exit) {
            this.clearExpressions();
            try {
                this.onExit(scope);
            }
            catch (Exception e) {
                LogProxy.e("execute exit expression failed: ", e);
            }
            LogProxy.d("exit = true,consume finished");
        }
        return exit;
    }

    @Override
    public void setInterceptors(@Nullable Map<String, ExpressionPair> params) {
        this.mInterceptorsMap = params;
    }

    @Override
    public void performInterceptIfNeeded(@NonNull String interceptorName, @NonNull ExpressionPair condition, @NonNull Map<String, Object> scope) {
        if (!ExpressionPair.isValid(condition)) {
            return;
        }
        Expression expression = new Expression(condition.transformed);
        boolean shouldIntercept = false;
        try {
            shouldIntercept = (Boolean)expression.execute(scope);
        }
        catch (Exception e) {
            LogProxy.e("evaluate interceptor [" + interceptorName + "] expression failed. ", e);
        }
        if (shouldIntercept) {
            this.onUserIntercept(interceptorName, scope);
        }
    }

    private void tryInterceptAllIfNeeded(@NonNull Map<String, Object> scope) {
        if (this.mInterceptorsMap == null || this.mInterceptorsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ExpressionPair> entry : this.mInterceptorsMap.entrySet()) {
            String interceptorName = entry.getKey();
            ExpressionPair interceptCondition = entry.getValue();
            if (TextUtils.isEmpty((CharSequence)interceptorName) || interceptCondition == null) continue;
            this.performInterceptIfNeeded(interceptorName, interceptCondition, scope);
        }
    }

    protected void consumeExpression(@Nullable Map<String, List<ExpressionHolder>> args, @NonNull Map<String, Object> scope, @NonNull String currentType) throws IllegalArgumentException, JSONException {
        this.tryInterceptAllIfNeeded(scope);
        if (args == null) {
            LogProxy.e("expression args is null");
            return;
        }
        if (args.isEmpty()) {
            LogProxy.e("no expression need consumed");
            return;
        }
        if (LogProxy.sEnableLog) {
            LogProxy.d(String.format(Locale.getDefault(), "consume expression with %d tasks. event type is %s", args.size(), currentType));
        }
        LinkedList<String> extension = new LinkedList<String>();
        for (List<ExpressionHolder> holderList : args.values()) {
            for (ExpressionHolder holder : holderList) {
                Object obj;
                ExpressionPair expressionPair;
                String instanceId;
                if (!currentType.equals(holder.eventType)) {
                    LogProxy.d("skip expression with wrong event type.[expected:" + currentType + ",found:" + holder.eventType + "]");
                    continue;
                }
                extension.clear();
                if (this.mExtensionParams != null && this.mExtensionParams.length > 0) {
                    Collections.addAll(extension, this.mExtensionParams);
                }
                String string = instanceId = TextUtils.isEmpty((CharSequence)holder.targetInstanceId) ? this.mInstanceId : holder.targetInstanceId;
                if (!TextUtils.isEmpty((CharSequence)instanceId)) {
                    extension.add(instanceId);
                }
                if (!ExpressionPair.isValid(expressionPair = holder.expressionPair)) continue;
                Expression expression = (Expression)this.mCachedExpressionMap.get(expressionPair.transformed);
                if (expression == null) {
                    expression = new Expression(expressionPair.transformed);
                    this.mCachedExpressionMap.put(expressionPair.transformed, expression);
                }
                if ((obj = expression.execute(scope)) == null) {
                    LogProxy.e("failed to execute expression,expression result is null");
                    continue;
                }
                if (obj instanceof Double && Double.isNaN((Double)obj) || obj instanceof Float && Float.isNaN(((Float)obj).floatValue())) {
                    LogProxy.e("failed to execute expression,expression result is NaN");
                    continue;
                }
                View targetView = this.mPlatformManager.getViewFinder().findViewBy(holder.targetRef, extension.toArray());
                BindingXPropertyInterceptor.getInstance().performIntercept(targetView, holder.prop, obj, this.mPlatformManager.getResolutionTranslator(), holder.config, holder.targetRef, instanceId);
                this.previewLength = (Double)obj;
                if (targetView == null) {
                    LogProxy.e("failed to execute expression,target view not found.[ref:" + holder.targetRef + "]");
                    continue;
                }
                this.mPlatformManager.getViewUpdater().synchronouslyUpdateViewOnUIThread(targetView, holder.prop, obj, this.mPlatformManager.getResolutionTranslator(), holder.config, holder.targetRef, instanceId);
            }
        }
    }

    protected abstract void onExit(@NonNull Map<String, Object> var1);

    protected abstract void onUserIntercept(String var1, @NonNull Map<String, Object> var2);

    protected void clearExpressions() {
        LogProxy.d("all expression are cleared");
        if (this.mExpressionHoldersMap != null) {
            this.mExpressionHoldersMap.clear();
            this.mExpressionHoldersMap = null;
        }
        this.mExitExpressionPair = null;
    }

    @Override
    public void setToken(String token) {
        this.mToken = token;
    }

    @Override
    public void setExtensionParams(Object[] params) {
        this.mExtensionParams = params;
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private int maxSize;

        Cache(int maxSize) {
            super(4, 0.75f, true);
            this.maxSize = Math.max(maxSize, 4);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

