/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.text.TextUtils;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.font.FontAdapter;
import com.taobao.weex.ui.action.IExecutable;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;

public class ActionAddRule
implements IExecutable {
    private final String mPageId;
    private final String mType;
    private final JSONObject mData;

    public ActionAddRule(String pageId, String type, JSONObject data) {
        this.mPageId = pageId;
        this.mType = type;
        this.mData = data;
    }

    @Override
    public void executeAction() {
        WXSDKInstance instance = WXSDKManager.getInstance().getWXRenderManager().getWXSDKInstance(this.mPageId);
        if (instance == null || instance.isDestroy()) {
            return;
        }
        if (!"fontFace".equals(this.mType)) {
            return;
        }
        FontDO fontDO = this.parseFontDO(this.mData, instance);
        if (fontDO != null && !TextUtils.isEmpty((CharSequence)fontDO.getFontFamilyName())) {
            this.notifyAddFontRule(instance, fontDO);
            FontDO cacheFontDO = TypefaceUtil.getFontDO(fontDO.getFontFamilyName());
            if (cacheFontDO == null || !TextUtils.equals((CharSequence)cacheFontDO.getUrl(), (CharSequence)fontDO.getUrl())) {
                TypefaceUtil.putFontDO(fontDO);
                TypefaceUtil.loadTypeface(fontDO, true);
            } else {
                TypefaceUtil.loadTypeface(cacheFontDO, true);
            }
        }
    }

    private FontDO parseFontDO(JSONObject jsonObject, WXSDKInstance instance) {
        if (jsonObject == null) {
            return null;
        }
        String src = jsonObject.getString("src");
        String name = jsonObject.getString("fontFamily");
        return new FontDO(name, src, instance);
    }

    private void notifyAddFontRule(WXSDKInstance instance, FontDO fontDO) {
        FontAdapter fontAdapter = WXSDKManager.getInstance().getFontAdapter();
        if (fontAdapter != null) {
            fontAdapter.onAddFontRule(instance.getInstanceId(), fontDO.getFontFamilyName(), fontDO.getUrl());
        }
    }
}

