/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.WXImageQuality;

public class GlideImageAdapter {
    public static void setImage(final String url, final ImageView view, WXImageQuality quality, final WXImageStrategy strategy) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (view == null || view.getLayoutParams() == null) {
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)url)) {
                    view.setImageBitmap(null);
                    return;
                }
                String temp = url;
                if (url.startsWith("//")) {
                    temp = "http:" + url;
                }
                if (view.getLayoutParams().width <= 0 || view.getLayoutParams().height <= 0) {
                    return;
                }
                RequestOptions options = new RequestOptions();
                Resources resources = view.getResources();
                DisplayMetrics dm = resources.getDisplayMetrics();
                int width = dm.widthPixels;
                int height = dm.heightPixels;
                options.override(width, height);
                Context context = view.getContext();
                if (temp.contains(".gif")) {
                    Glide.with((Context)context).asGif().load(temp).apply((BaseRequestOptions)options).listener((RequestListener)new RequestListener<GifDrawable>(){

                        public boolean onLoadFailed(GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                            GlideImageAdapter.onImageFinish(strategy, url, view, false);
                            return false;
                        }

                        public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                            GlideImageAdapter.onImageFinish(strategy, url, view, true);
                            return false;
                        }
                    }).into(view);
                } else {
                    Glide.with((Context)context).load(temp).apply((BaseRequestOptions)options).listener((RequestListener)new RequestListener<Drawable>(){

                        public boolean onLoadFailed(GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                            GlideImageAdapter.onImageFinish(strategy, url, view, false);
                            return false;
                        }

                        public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                            GlideImageAdapter.onImageFinish(strategy, url, view, true);
                            return false;
                        }
                    }).into(view);
                }
            }
        };
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            WXSDKManager.getInstance().postOnUiThread(runnable, 0L);
        }
    }

    private static void onImageFinish(WXImageStrategy strategy, String url, ImageView view, boolean result) {
        if (strategy != null && strategy.getImageListener() != null) {
            strategy.getImageListener().onImageFinish(url, view, result, null);
        }
    }
}

