/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.webview;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.GeolocationPermissions;
import android.webkit.JavascriptInterface;
import android.webkit.JsPromptResult;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.FileProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.dcloud.android.widget.DCWebViewProgressBar;
import com.taobao.weex.ui.view.IWebView;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IActivityDelegate;
import io.dcloud.common.DHInterface.IActivityHandler;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.FileChooseDialog;
import io.dcloud.common.adapter.ui.webview.WebViewFactory;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.weex.WeexInstanceMgr;
import io.dcloud.feature.weex.adapter.webview.IDCWebView;
import io.dcloud.feature.weex.adapter.webview.WXDCWeb;
import io.dcloud.feature.weex.adapter.webview.video.FullscreenHolder;
import io.src.dcloud.adapter.DCloudAdapterUtil;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

public class DCWXWebView
implements IDCWebView {
    private Context mContext;
    private String mOrigin;
    private WebView mWebView;
    private FrameLayout mRootView;
    private boolean mShowLoading = true;
    private Handler mMessageHandler;
    private static final int POST_MESSAGE = 1;
    private static final int POST_MESSAGE_TO_CONTROL = 2;
    private static final String BRIDGE_NAME = "__dcloud_weex_";
    private static final int SDK_VERSION = Build.VERSION.SDK_INT;
    private IWebView.OnErrorListener mOnErrorListener;
    private IWebView.OnPageListener mOnPageListener;
    private WXDCWeb.OnDCMessageListener mOnMessageListener;
    private DCWebViewProgressBar mWebProgressView;
    private WeakReference<WXDCWeb> mDCWeb;
    public int mProgress = 0;
    private boolean isStart = false;
    private String mDefUserAgent;
    DCWXChromeClient chromeClient;
    String mSslType = "refuse";
    private View customView;
    private FrameLayout fullscreenContainer;
    private WebChromeClient.CustomViewCallback customViewCallback;
    private int defaultSystemUI = 0;

    public DCWXWebView(Context context, String origin, WXDCWeb wxdcWeb) {
        this.mContext = context;
        this.mOrigin = origin;
        this.mDCWeb = new WeakReference<WXDCWeb>(wxdcWeb);
        IWebview iwb = WeexInstanceMgr.self().findWebview(wxdcWeb.getInstance());
        if (iwb != null && iwb.obtainApp() != null) {
            this.mSslType = iwb.obtainApp().obtainConfigProperty("untrustedca");
        }
    }

    @Override
    public View getView() {
        this.mRootView = new FrameLayout(this.mContext);
        this.mRootView.setBackgroundColor(-1);
        this.mWebView = new WebView(this.mContext){

            protected void onScrollChanged(int l, int t, int oldl, int oldt) {
                super.onScrollChanged(l, t, oldl, oldt);
                AppEventForBlurManager.onScrollChanged((int)l, (int)t);
            }
        };
        FrameLayout.LayoutParams wvLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        wvLayoutParams.gravity = 17;
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)wvLayoutParams);
        this.mRootView.addView((View)this.mWebView);
        this.mWebView.setBackgroundColor(0);
        this.initWebView(this.mWebView);
        this.mMessageHandler = new MessageHandler(this);
        return this.mRootView;
    }

    @Override
    public void destroy() {
        if (this.getWebView() != null) {
            this.hideCustomView();
            this.getWebView().setWebViewClient(null);
            this.getWebView().setWebChromeClient(null);
            this.getWebView().removeAllViews();
            this.getWebView().destroy();
            this.mWebView = null;
            this.mDCWeb.clear();
            this.mOnMessageListener = null;
            this.mWebProgressView = null;
            this.mOnPageListener = null;
            this.mOnErrorListener = null;
        }
    }

    @Override
    public void loadUrl(String url) {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().loadUrl(url);
    }

    @Override
    public void loadDataWithBaseURL(String source) {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().loadDataWithBaseURL(this.mOrigin, source, "text/html", "utf-8", null);
    }

    @Override
    public void reload() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().reload();
    }

    @Override
    public void goBack() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().goBack();
    }

    @Override
    public void goForward() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().goForward();
    }

    @Override
    public void postMessage(Object msg) {
        if (this.getWebView() == null) {
            return;
        }
        try {
            JSONObject initData = new JSONObject();
            initData.put("type", (Object)"message");
            initData.put("data", msg);
            this.evaluateJS("javascript:(function () {var initData = " + initData.toString() + ";try {var event = new MessageEvent('onPostMessage', initData);window.dispatchEvent(event);} catch (e) {}})();");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setShowLoading(boolean shown) {
        this.mShowLoading = shown;
    }

    @Override
    public void setOnErrorListener(IWebView.OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    @Override
    public void setOnPageListener(IWebView.OnPageListener listener) {
        this.mOnPageListener = listener;
    }

    @Override
    public void setOnMessageListener(IWebView.OnMessageListener listener) {
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.chromeClient != null) {
            this.chromeClient.onResult(requestCode, resultCode, data);
        }
    }

    public void setOnDCMessageListener(WXDCWeb.OnDCMessageListener listener) {
        this.mOnMessageListener = listener;
    }

    private void showWebView(boolean shown) {
        this.mWebView.setVisibility(shown ? 0 : 4);
    }

    @Nullable
    public WebView getWebView() {
        return this.mWebView;
    }

    @Override
    public void setUserAgent(String ua, boolean overwrite) {
        if (this.mWebView != null) {
            WebSettings settings = this.mWebView.getSettings();
            if (!overwrite) {
                if (TextUtils.isEmpty((CharSequence)this.mDefUserAgent)) {
                    this.mDefUserAgent = settings.getUserAgentString();
                }
                ua = ua + this.mDefUserAgent + " " + ua;
            }
            settings.setUserAgentString(ua);
        }
    }

    private void initWebView(WebView wv) {
        WebSettings settings = wv.getSettings();
        WebViewFactory.openJSEnabled((Object)settings, null);
        settings.setAppCacheEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setDomStorageEnabled(true);
        settings.setSupportZoom(false);
        settings.setAllowFileAccess(false);
        settings.setBuiltInZoomControls(false);
        settings.setAllowContentAccess(true);
        settings.setSavePassword(false);
        if (Build.VERSION.SDK_INT >= 21) {
            settings.setMixedContentMode(0);
        }
        wv.removeJavascriptInterface("searchBoxJavaBridge_");
        wv.removeJavascriptInterface("accessibilityTraversal");
        wv.removeJavascriptInterface("accessibility");
        WebViewFactory.setFileAccess((Object)settings, (boolean)true);
        settings.setDefaultTextEncodingName("GB2312");
        wv.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (!(PdrUtil.isDeviceRootDir((String)url) || PdrUtil.isNetPath((String)url) || url.startsWith("file://"))) {
                    try {
                        if (url.startsWith("intent://")) {
                            List resolves;
                            Intent intent = Intent.parseUri((String)url, (int)1);
                            intent.addCategory("android.intent.category.BROWSABLE");
                            intent.setComponent(null);
                            if (Build.VERSION.SDK_INT >= 15) {
                                intent.setSelector(null);
                            }
                            if ((resolves = DCWXWebView.this.mContext.getPackageManager().queryIntentActivities(intent, 0)).size() > 0) {
                                Activity activity = (Activity)DCWXWebView.this.mContext;
                                activity.startActivityIfNeeded(intent, -1);
                            }
                        } else {
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                            intent.setFlags(0x10000000);
                            DCWXWebView.this.mContext.startActivity(intent);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                WXLogUtils.v("tag", "onPageStarted " + url);
                if (DCWXWebView.this.mOnPageListener != null) {
                    DCWXWebView.this.mOnPageListener.onPageStart(url);
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                WXLogUtils.v("tag", "onPageFinished " + url);
                if (DCWXWebView.this.isStart) {
                    DCWXWebView.this.isStart = false;
                    if (DCWXWebView.this.mWebProgressView != null) {
                        DCWXWebView.this.mWebProgressView.finishProgress();
                    }
                }
                if (DCWXWebView.this.mOnPageListener != null) {
                    DCWXWebView.this.mOnPageListener.onPageFinish(url, view.canGoBack(), view.canGoForward());
                }
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (DCWXWebView.this.mOnErrorListener != null) {
                    DCWXWebView.this.mOnErrorListener.onError("error", "page error");
                }
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                if (DCWXWebView.this.mOnErrorListener != null) {
                    DCWXWebView.this.mOnErrorListener.onError("error", "http error");
                }
            }

            public void onReceivedSslError(WebView view, final SslErrorHandler handler, final SslError error) {
                if (PdrUtil.isEquals((String)DCWXWebView.this.mSslType, (String)"refuse")) {
                    handler.cancel();
                } else if (PdrUtil.isEquals((String)DCWXWebView.this.mSslType, (String)"warning")) {
                    Context context = view.getContext();
                    final AlertDialog ad = new AlertDialog.Builder(context).create();
                    ad.setIcon(17301601);
                    ad.setTitle(R.string.dcloud_common_safety_warning);
                    ad.setCanceledOnTouchOutside(false);
                    String url = null;
                    if (Build.VERSION.SDK_INT >= 14) {
                        url = error.getUrl();
                    }
                    String msg = context.getString(R.string.dcloud_common_certificate_continue);
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        msg = url + "\n" + msg;
                    }
                    ad.setMessage((CharSequence)msg);
                    DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            if (which == -2) {
                                ad.cancel();
                                ad.dismiss();
                            } else if (which == -3) {
                                error.getCertificate().getIssuedBy();
                            } else if (which == -1) {
                                WebViewFactory.setSslHandlerState((Object)handler, (int)1);
                                ad.dismiss();
                            }
                        }
                    };
                    ad.setButton(-2, (CharSequence)context.getResources().getString(0x1040000), listener);
                    ad.setButton(-1, (CharSequence)context.getResources().getString(17039370), listener);
                    ad.show();
                } else {
                    WebViewFactory.setSslHandlerState((Object)handler, (int)1);
                }
                if (DCWXWebView.this.mOnErrorListener != null) {
                    DCWXWebView.this.mOnErrorListener.onError("error", "ssl error");
                }
            }
        });
        this.chromeClient = new DCWXChromeClient();
        wv.setWebChromeClient((WebChromeClient)this.chromeClient);
        if (Build.VERSION.SDK_INT > 18) {
            wv.addJavascriptInterface(new Object(){

                @JavascriptInterface
                public void postMessage(String message) {
                    DCWXWebView.this.onMessage(message, 1);
                }

                @JavascriptInterface
                public void postMessageToService(String message) {
                    DCWXWebView.this.onMessage(message, 2);
                }
            }, BRIDGE_NAME);
        }
    }

    private void startWebProgress() {
        if (this.mDCWeb.get() == null || ((WXDCWeb)this.mDCWeb.get()).getHostView() == null) {
            return;
        }
        if (this.mDCWeb.get() != null && ((WXDCWeb)this.mDCWeb.get()).getWebStyles() != null && !((WXDCWeb)this.mDCWeb.get()).getWebStyles().getBooleanValue("isProgress")) {
            return;
        }
        String url = this.getWebView().getUrl();
        if (TextUtils.isEmpty((CharSequence)url) || url.startsWith("file")) {
            return;
        }
        if (this.mWebProgressView == null) {
            this.mWebProgressView = new DCWebViewProgressBar(this.mWebView.getContext());
        }
        String colorStr = "#00FF00";
        if (((WXDCWeb)this.mDCWeb.get()).getWebStyles().containsKey((Object)"progressColor")) {
            colorStr = ((WXDCWeb)this.mDCWeb.get()).getWebStyles().getString("progressColor");
        }
        int colorInt = PdrUtil.stringToColor((String)colorStr);
        int heightInt = PdrUtil.convertToScreenInt((String)"2px", (int)this.mWebView.getMeasuredWidth(), (int)0, (float)this.mWebView.getScale());
        this.mWebProgressView.setColorInt(colorInt);
        this.mWebProgressView.setVisibility(0);
        this.mWebProgressView.setAlphaInt(255);
        if (this.mWebProgressView.getParent() == null) {
            this.mRootView.addView((View)this.mWebProgressView, new ViewGroup.LayoutParams(-1, heightInt));
        }
        this.mWebProgressView.startProgress();
    }

    private void onMessage(String message, int type) {
        if (message != null && this.mOnMessageListener != null) {
            Object m = null;
            try {
                m = JSON.parse((String)message);
            }
            catch (Exception e) {
                m = message;
            }
            Message threadMessage = new Message();
            threadMessage.what = type;
            threadMessage.obj = m;
            this.mMessageHandler.sendMessage(threadMessage);
        }
    }

    private void evaluateJS(String jsStr) {
        if (SDK_VERSION < 19) {
            this.mWebView.loadUrl(jsStr);
        } else {
            this.mWebView.evaluateJavascript(jsStr, null);
        }
    }

    private void showCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        if (this.customView != null) {
            callback.onCustomViewHidden();
            return;
        }
        if (this.mContext != null && this.mContext instanceof Activity) {
            Activity activityT = (Activity)this.mContext;
            FrameLayout activityContentView = null;
            IActivityHandler iActivityHandler = DCloudAdapterUtil.getIActivityHandler((Activity)activityT);
            if (iActivityHandler != null) {
                activityContentView = iActivityHandler.obtainActivityContentView();
                iActivityHandler.closeSideBar();
                iActivityHandler.setSideBarVisibility(8);
            } else if (activityT instanceof IActivityDelegate) {
                activityContentView = ((IActivityDelegate)activityT).obtainActivityContentView();
            }
            this.mWebView.setVisibility(8);
            this.fullscreenContainer = new FullscreenHolder(this.mContext);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.fullscreenContainer.addView(view, (ViewGroup.LayoutParams)lp);
            activityContentView.addView((View)this.fullscreenContainer, (ViewGroup.LayoutParams)lp);
            this.customView = view;
            this.setStatusBarVisibility(activityT, false);
            this.customViewCallback = callback;
        }
    }

    private void hideCustomView() {
        if (this.customView == null) {
            return;
        }
        if (this.mContext != null && this.mContext instanceof Activity) {
            Activity activityT = (Activity)this.mContext;
            this.setStatusBarVisibility(activityT, true);
            if (this.fullscreenContainer.getParent() != null) {
                ((ViewGroup)this.fullscreenContainer.getParent()).removeView((View)this.fullscreenContainer);
                this.fullscreenContainer.removeAllViews();
            }
            this.fullscreenContainer = null;
            this.customView = null;
            if (this.customViewCallback != null) {
                this.customViewCallback.onCustomViewHidden();
                this.customViewCallback = null;
            }
            this.mWebView.setVisibility(0);
        }
    }

    private void setStatusBarVisibility(Activity activity, boolean visible) {
        if (visible) {
            activity.getWindow().getDecorView().setSystemUiVisibility(this.defaultSystemUI);
        } else {
            this.defaultSystemUI = activity.getWindow().getDecorView().getSystemUiVisibility();
            activity.getWindow().getDecorView().setSystemUiVisibility(5894);
        }
    }

    private class DCWXChromeClient
    extends WebChromeClient {
        FileChooseDialog dialog;
        ValueCallback<Uri> mUploadMessage;
        ValueCallback<Uri[]> mUploadMessage21Level;

        private DCWXChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            DCWXWebView.this.mProgress = newProgress;
            if (!DCWXWebView.this.isStart && DCWXWebView.this.mProgress < 100) {
                DCWXWebView.this.startWebProgress();
                DCWXWebView.this.isStart = true;
            }
            if (DCWXWebView.this.mProgress >= 100 && DCWXWebView.this.isStart) {
                DCWXWebView.this.isStart = false;
                if (DCWXWebView.this.mWebProgressView != null) {
                    DCWXWebView.this.mWebProgressView.finishProgress();
                }
            }
            WXLogUtils.v("tag", "onPageProgressChanged " + newProgress);
        }

        public void onReceivedTitle(WebView view, String title) {
            super.onReceivedTitle(view, title);
            if (DCWXWebView.this.mOnPageListener != null) {
                DCWXWebView.this.mOnPageListener.onReceivedTitle(view.getTitle());
            }
        }

        public boolean onJsPrompt(WebView view, String url, String text, String defaultValue, JsPromptResult result) {
            return super.onJsPrompt(view, url, text, defaultValue, result);
        }

        public void onGeolocationPermissionsShowPrompt(final String origin, final GeolocationPermissions.Callback callback) {
            if (DCWXWebView.this.mContext instanceof Activity) {
                PermissionUtil.usePermission((Activity)((Activity)DCWXWebView.this.mContext), (String)"dc_weexsdk", (String)"LOCATION", (int)2, (PermissionUtil.Request)new PermissionUtil.Request(){

                    public void onGranted(String streamPerName) {
                        callback.invoke(origin, true, false);
                    }

                    public void onDenied(String streamPerName) {
                        callback.invoke(origin, false, false);
                    }
                });
            } else {
                super.onGeolocationPermissionsShowPrompt(origin, callback);
            }
        }

        @RequiresApi(api=21)
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            this.openFileChooserLogic(webView, null, filePathCallback, fileChooserParams.getAcceptTypes() != null ? fileChooserParams.getAcceptTypes()[0] : null, "");
            return true;
        }

        private void openFileChooserLogic(final WebView webView, final ValueCallback<Uri> uploadMsg, final ValueCallback<Uri[]> uploadMsg21Level, final String acceptType, final String capture) {
            if (DCWXWebView.this.mContext == null) {
                return;
            }
            PermissionUtil.usePermission((Activity)((Activity)DCWXWebView.this.mContext), (String)"dc_weexsdk", (String)"STORAGE", (int)2, (PermissionUtil.Request)new PermissionUtil.Request(){

                public void onGranted(String perName) {
                    DCWXChromeClient.this.showOpenFileChooser(webView, (ValueCallback<Uri>)uploadMsg, (ValueCallback<Uri[]>)uploadMsg21Level, acceptType, capture);
                }

                public void onDenied(String perName) {
                }
            });
        }

        private void showOpenFileChooser(WebView webView, ValueCallback<Uri> uploadMsg, ValueCallback<Uri[]> uploadMsg21Level, String acceptType, String capture) {
            this.mUploadMessage = uploadMsg;
            this.mUploadMessage21Level = uploadMsg21Level;
            Intent i = new Intent("android.intent.action.GET_CONTENT");
            i.addCategory("android.intent.category.OPENABLE");
            if (!PdrUtil.isEmpty((Object)acceptType)) {
                i.setType(acceptType);
            } else {
                i.setType("*/*");
            }
            this.dialog = new FileChooseDialog(webView.getContext(), (Activity)webView.getContext(), i);
            try {
                this.dialog.show();
                this.dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        try {
                            if (DCWXChromeClient.this.mUploadMessage21Level != null) {
                                DCWXChromeClient.this.mUploadMessage21Level.onReceiveValue(null);
                            } else if (DCWXChromeClient.this.mUploadMessage != null) {
                                DCWXChromeClient.this.mUploadMessage.onReceiveValue(null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onResult(int requestCode, int resultCode, Intent data) {
            block21: {
                block18: {
                    Uri value;
                    block20: {
                        block19: {
                            Cursor cursor;
                            if (this.dialog == null) {
                                return;
                            }
                            this.dialog.dismiss();
                            if (resultCode == 0) break block18;
                            value = null;
                            if (requestCode != 1) break block19;
                            if (data == null) {
                                if (this.mUploadMessage21Level != null) {
                                    this.mUploadMessage21Level.onReceiveValue(null);
                                } else if (this.mUploadMessage != null) {
                                    this.mUploadMessage.onReceiveValue(null);
                                }
                                this.dialog = null;
                                return;
                            }
                            value = data.getData();
                            if (value == null || !"content".equals(value.getScheme()) || (cursor = DCWXWebView.this.mContext.getContentResolver().query(value, new String[]{"_data"}, null, null, null)) == null) break block20;
                            if (cursor.moveToFirst()) {
                                try {
                                    String uriString;
                                    int columnIndex = cursor.getColumnIndexOrThrow("_data");
                                    if (columnIndex > -1 && PdrUtil.isEmpty((Object)(value = Uri.parse((String)(uriString = cursor.getString(columnIndex)))).getScheme())) {
                                        String scheme = uriString.startsWith("/") ? "file://" : "file:///";
                                        value = Uri.parse((String)(scheme + uriString));
                                    }
                                }
                                catch (Exception columnIndex) {
                                    // empty catch block
                                }
                            }
                            cursor.close();
                            break block20;
                        }
                        if (requestCode == 2 && this.dialog != null && this.dialog.uris != null) {
                            for (File u : this.dialog.uris) {
                                if (!u.exists()) continue;
                                value = FileProvider.getUriForFile((Context)DCWXWebView.this.mContext, (String)(DCWXWebView.this.mContext.getPackageName() + ".dc.fileprovider"), (File)u);
                                break;
                            }
                        }
                    }
                    Uri[] uris = null;
                    if (value != null) {
                        uris = new Uri[]{value};
                    }
                    if (this.mUploadMessage21Level != null) {
                        this.mUploadMessage21Level.onReceiveValue((Object)uris);
                    } else if (this.mUploadMessage != null) {
                        this.mUploadMessage.onReceiveValue((Object)value);
                    }
                    break block21;
                }
                if (this.mUploadMessage21Level != null) {
                    this.mUploadMessage21Level.onReceiveValue(null);
                } else if (this.mUploadMessage != null) {
                    this.mUploadMessage.onReceiveValue(null);
                }
            }
            this.dialog = null;
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            DCWXWebView.this.showCustomView(view, callback);
        }

        public void onHideCustomView() {
            DCWXWebView.this.hideCustomView();
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<DCWXWebView> mWv;

        private MessageHandler(DCWXWebView wv) {
            this.mWv = new WeakReference<DCWXWebView>(wv);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    if (this.mWv.get() == null || ((DCWXWebView)this.mWv.get()).mOnMessageListener == null) break;
                    HashMap<String, Object> initData = new HashMap<String, Object>();
                    initData.put("detail", msg.obj);
                    ((DCWXWebView)this.mWv.get()).mOnMessageListener.onMessage(initData, 1);
                    break;
                }
                case 2: {
                    if (this.mWv.get() == null || ((DCWXWebView)this.mWv.get()).mOnMessageListener == null) break;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("data", msg.obj);
                    ((DCWXWebView)this.mWv.get()).mOnMessageListener.onMessage(map, 2);
                }
            }
        }
    }
}

